/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mask.imask;

import com.ibm.mask.imask.AllCharacter;
import com.ibm.mask.imask.AlphaNumericCharacter;
import com.ibm.mask.imask.AlphaNumericWithSpaceCharacter;
import com.ibm.mask.imask.AlphabeticCharacter;
import com.ibm.mask.imask.LowerCaseCharacter;
import com.ibm.mask.imask.MaskCharacter;
import com.ibm.mask.imask.NonEditable;
import com.ibm.mask.imask.NumericCharacter;
import com.ibm.mask.imask.NumericWithSpaceCharacter;
import com.ibm.mask.imask.UpperCaseCharacter;
import java.io.Serializable;

class MaskString
implements Serializable {
    private MaskCharacter[] maskCharacter;
    private String actualMask;
    private static final int NUMERIC_CHAR = 0;
    private static final int ALL_CHAR = 1;
    private static final int ALPHA_NUM_CHAR = 2;
    private static final int ALPHA_BETA_CHAR = 3;
    private static final int UPPER_CHAR = 4;
    private static final int LOWER_CHAR = 5;
    private static final int STATIC_CHAR = 6;
    private static final int ALPHA_NUM_WITH_SPACE_CHAR = 7;
    private static final int NUMERIC_WITH_SPACE_CHAR = 8;
    private int[] maskCharacterUsed = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
    private String maskString;
    private char mCharacter = (char)95;

    public MaskString(String string, char c) {
        this.mCharacter = c;
        this.setMask(string);
    }

    public char charAt(int n) {
        return this.maskCharacter[n].maskChar();
    }

    public boolean isEditable(int n) {
        return this.maskCharacter[n].isEditable();
    }

    private int length(String string) {
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < string.length()) {
                if (string.charAt(n2) == '\\') {
                    ++n2;
                }
                ++n;
                ++n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return n;
        }
        return n;
    }

    public boolean matches(char c, int n) {
        return this.maskCharacter[n].isMatch(c);
    }

    public boolean matchType(char c, int n) {
        return this.maskCharacter[n].maskChar() == c;
    }

    public void setMask(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        this.actualMask = string;
        this.maskCharacter = new MaskCharacter[this.length(string)];
        int n2 = 0;
        while (n2 < string.length()) {
            char c = this.mCharacter;
            switch (string.charAt(n2)) {
                case '#': {
                    if (this.maskCharacterUsed[0] == -1) {
                        this.maskCharacter[n] = new NumericCharacter();
                        this.maskCharacterUsed[0] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[0]];
                    break;
                }
                case '*': {
                    if (this.maskCharacterUsed[8] == -1) {
                        this.maskCharacter[n] = new NumericWithSpaceCharacter();
                        this.maskCharacterUsed[8] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[8]];
                    break;
                }
                case '&': {
                    if (this.maskCharacterUsed[1] == -1) {
                        this.maskCharacter[n] = new AllCharacter();
                        this.maskCharacterUsed[1] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[1]];
                    break;
                }
                case 'A': {
                    if (this.maskCharacterUsed[2] == -1) {
                        this.maskCharacter[n] = new AlphaNumericCharacter();
                        this.maskCharacterUsed[2] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[2]];
                    break;
                }
                case '@': {
                    if (this.maskCharacterUsed[7] == -1) {
                        this.maskCharacter[n] = new AlphaNumericWithSpaceCharacter();
                        this.maskCharacterUsed[7] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[7]];
                    break;
                }
                case '?': {
                    if (this.maskCharacterUsed[3] == -1) {
                        this.maskCharacter[n] = new AlphabeticCharacter();
                        this.maskCharacterUsed[3] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[3]];
                    break;
                }
                case 'U': {
                    if (this.maskCharacterUsed[4] == -1) {
                        this.maskCharacter[n] = new UpperCaseCharacter();
                        this.maskCharacterUsed[4] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[4]];
                    break;
                }
                case 'L': {
                    if (this.maskCharacterUsed[5] == -1) {
                        this.maskCharacter[n] = new LowerCaseCharacter();
                        this.maskCharacterUsed[5] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[5]];
                    break;
                }
                case '\\': {
                    ++n2;
                }
                default: {
                    try {
                        c = string.charAt(n2);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        this.maskString = new String(stringBuffer.toString());
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                    if (this.maskCharacterUsed[6] == -1) {
                        this.maskCharacter[n] = new NonEditable();
                        this.maskCharacterUsed[6] = n;
                        break;
                    }
                    this.maskCharacter[n] = this.maskCharacter[this.maskCharacterUsed[6]];
                }
            }
            ++n;
            stringBuffer.append(c);
            ++n2;
        }
        this.maskString = new String(stringBuffer.toString());
    }

    public String toString() {
        return this.maskString;
    }
}

