/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import com.ibm.uvm.abt.edit.ColorPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class ColorEditor
extends PropertyEditorSupport {
    ColorPropertyEditor customEditor = null;

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            Color aColor = (Color)this.getValue();
            this.customEditor = aColor == null ? new ColorPropertyEditor() : new ColorPropertyEditor(aColor);
        }
        return this.customEditor;
    }

    public String getJavaInitializationString() {
        if (this.customEditor != null) {
            return this.customEditor.getColorInitializationString();
        }
        Color value = (Color)super.getValue();
        if (value != null) {
            int r = value.getRed();
            int g = value.getGreen();
            int b = value.getBlue();
            return "new java.awt.Color(" + r + "," + g + "," + b + ")";
        }
        return "new java.awt.Color(0, 0, 0)";
    }

    public Object getValue() {
        if (this.customEditor != null) {
            return this.customEditor.getColorValue();
        }
        return super.getValue();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        Color aColor = (Color)this.getValue();
        if (aColor != null) {
            Color oldColor = gfx.getColor();
            gfx.setColor(Color.black);
            gfx.drawRect(box.x, box.y, box.width - 3, box.height - 3);
            gfx.setColor((Color)this.getValue());
            gfx.fillRect(box.x + 1, box.y + 1, box.width - 4, box.height - 4);
            gfx.setColor(oldColor);
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    public void setValue(Object newValue) {
        super.setValue(newValue);
        if (this.customEditor != null) {
            this.customEditor.setColorValue((Color)newValue);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

