/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import com.ibm.uvm.abt.edit.FontPropertyEditor;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;

public class FontEditor
extends PropertyEditorSupport {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");
    FontPropertyEditor customEditor = null;

    public String getAsText() {
        Font font = (Font)this.getValue();
        String strStyle = font.isBold() ? (font.isItalic() ? resabtedit.getString("bolditalic") : resabtedit.getString("bold")) : (font.isItalic() ? resabtedit.getString("italic") : resabtedit.getString("plain"));
        return String.valueOf(font.getName()) + ", " + strStyle + ", " + font.getSize();
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            Font aFont = (Font)this.getValue();
            this.customEditor = aFont == null ? new FontPropertyEditor() : new FontPropertyEditor(aFont);
        }
        return this.customEditor;
    }

    public String getJavaInitializationString() {
        Font font = (Font)this.getValue();
        if (font != null) {
            return "new java.awt.Font(\"" + font.getFamily() + "\", " + font.getStyle() + ", " + font.getSize() + ")";
        }
        return "new java.awt.Font(\"dialog\", 0, 12)";
    }

    public Object getValue() {
        if (this.customEditor != null) {
            return this.customEditor.getFontValue();
        }
        return super.getValue();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    public void setValue(Object newValue) {
        super.setValue(newValue);
        if (this.customEditor != null) {
            this.customEditor.setFontValue((Font)newValue);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

