/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.OutputDeviceServiceState;
import com.ibm.jpos.services.ibmprinter.MicrPrinterState;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerServiceState;
import jpos.JposException;

public class POSPrinterServiceState
extends DeviceServiceState
implements OutputDeviceServiceState,
MicrPrinterState,
PrintQueueManagerServiceState {
    private int cartridgeNotify = 0;
    private boolean asyncMode = false;
    private int capCharacterSet = 998;
    private boolean capSlpLeft90 = false;
    private int characterSet = 0;
    private String characterSetList = "";
    private boolean coverOpen = false;
    private int errorLevel = 1;
    private int errorStation = 0;
    private String errorString = "";
    private boolean flagWhenIdle = false;
    private String fontTypefaceList = "";
    private int mapMode = 1;
    private int outputID = 0;
    private int rotateSpecial = 1;
    private boolean jrnEmpty = false;
    private boolean jrnLetterQuality = false;
    private int jrnLineChars = 0;
    private String jrnLineCharsList = "";
    private int jrnLineHeight = 0;
    private int jrnLineSpacing = 0;
    private int jrnLineWidth = 0;
    private boolean jrnNearEnd = false;
    private int capJrnColor = 1;
    private int jrnCartridgeState = 0x10000000;
    private int jrnCurrentCartridge = 1;
    private boolean capRec2Color = false;
    private String recBarCodeRotationList = "";
    private boolean recEmpty = false;
    private boolean recLetterQuality = false;
    private int recLineChars = 0;
    private String recLineCharsList = "";
    private int recLineHeight = 0;
    private int recLineSpacing = 0;
    private int recLinesToPaperCut = 0;
    private int recLineWidth = 0;
    private boolean recNearEnd = false;
    private int recSidewaysMaxChars = 0;
    private int recSidewaysMaxLines = 0;
    private int recRotateMode = 1;
    private boolean capRecBitmap = false;
    private int capRecColor = 1;
    private int recCartridgeState = 0x10000000;
    private int recCurrentCartridge = 1;
    private String slpBarCodeRotationList = "";
    private boolean slpEmpty = true;
    private boolean slpLetterQuality = false;
    private int slpLineChars = 0;
    private String slpLineCharsList = "";
    private int slpLineHeight = 0;
    private int slpLinesNearEndToEnd = 0;
    private int slpLineSpacing = 0;
    private int slpLineWidth = 0;
    private int slpMaxLines = 0;
    private boolean slpNearEnd = false;
    private int slpSidewaysMaxChars = 0;
    private int slpSidewaysMaxLines = 0;
    private int slpRotateMode = 1;
    private int capSlpColor = 1;
    private int slpCartridgeState = 0x10000000;
    private int slpCurrentCartridge = 1;
    private int slpPrintSide = 0;
    private boolean capSlpBothSidesPrint = false;
    public static final int POSPRINTER_SERVICE_VERSION = 1005134;
    public static final int PTR_CS_NO_ASCII_OR_ANSI_LOW = 101;
    public static final int PTR_CS_NO_ASCII_OR_ANSI_HIGH = 199;
    public static final int PTR_CS_CODEPAGE_LOW = 400;
    public static final int PTR_CS_CODEPAGE_HIGH = 990;

    POSPrinterServiceState() {
    }

    public boolean getCapConcurrentJrnRec() {
        return false;
    }

    public boolean getCapConcurrentJrnSlp() {
        return false;
    }

    public boolean getCapConcurrentRecSlp() {
        return false;
    }

    public boolean getCapCoverSensor() {
        return false;
    }

    public boolean getCapJrn2Color() {
        return false;
    }

    public boolean getCapJrnBold() {
        return false;
    }

    public boolean getCapJrnDhigh() {
        return false;
    }

    public boolean getCapJrnDwide() {
        return false;
    }

    public boolean getCapJrnDwideDhigh() {
        return false;
    }

    public boolean getCapJrnEmptySensor() {
        return false;
    }

    public boolean getCapJrnItalic() {
        return false;
    }

    public boolean getCapJrnNearEndSensor() {
        return false;
    }

    public boolean getCapJrnPresent() {
        return false;
    }

    public boolean getCapJrnUnderline() {
        return false;
    }

    public int getCapJrnCartridgeSensor() {
        return 0;
    }

    public int getCapJrnColor() {
        return this.getCapJrnPresent() ? this.capJrnColor : 0;
    }

    public int getJrnCurrentCartridge() {
        return this.jrnCurrentCartridge;
    }

    public synchronized int getJrnCartridgeState() {
        return this.jrnCartridgeState;
    }

    public boolean getCapRec2Color() {
        return this.capRec2Color;
    }

    public boolean getCapRecBarCode() {
        return false;
    }

    public boolean getCapRecBitmap() {
        return this.capRecBitmap;
    }

    public void setCapRecBitmap(boolean bl) {
        this.capRecBitmap = bl;
    }

    public boolean getCapRecBold() {
        return false;
    }

    public boolean getCapRecDhigh() {
        return false;
    }

    public boolean getCapRecDwide() {
        return false;
    }

    public boolean getCapRecDwideDhigh() {
        return false;
    }

    public boolean getCapRecEmptySensor() {
        return false;
    }

    public boolean getCapRecItalic() {
        return false;
    }

    public boolean getCapRecLeft90() {
        return false;
    }

    public boolean getCapRecNearEndSensor() {
        return false;
    }

    public boolean getCapRecPapercut() {
        return false;
    }

    public boolean getCapRecPresent() {
        return false;
    }

    public boolean getCapRecRight90() {
        return false;
    }

    public boolean getCapRecRotate180() {
        return false;
    }

    public boolean getCapRecStamp() {
        return false;
    }

    public boolean getCapRecUnderline() {
        return false;
    }

    public int getCapRecCartridgeSensor() {
        return 0;
    }

    public int getCapRecColor() {
        return this.capRecColor;
    }

    public int getCapRecMarkFeed() {
        return 0;
    }

    public int getRecCurrentCartridge() {
        return this.recCurrentCartridge;
    }

    public synchronized int getRecCartridgeState() {
        return this.recCartridgeState;
    }

    public boolean getCapSlp2Color() {
        return false;
    }

    public boolean getCapSlpBarCode() {
        return false;
    }

    public boolean getCapSlpBitmap() {
        return false;
    }

    public boolean getCapSlpBold() {
        return false;
    }

    public boolean getCapSlpDhigh() {
        return false;
    }

    public boolean getCapSlpDwide() {
        return false;
    }

    public boolean getCapSlpDwideDhigh() {
        return false;
    }

    public boolean getCapSlpEmptySensor() {
        return false;
    }

    public boolean getCapSlpFullslip() {
        return false;
    }

    public boolean getCapSlpItalic() {
        return false;
    }

    public boolean getCapSlpLeft90() {
        return this.capSlpLeft90;
    }

    public boolean getCapSlpNearEndSensor() {
        return false;
    }

    public boolean getCapSlpPresent() {
        return false;
    }

    public boolean getCapSlpRight90() {
        return false;
    }

    public boolean getCapSlpRotate180() {
        return false;
    }

    public boolean getCapSlpUnderline() {
        return false;
    }

    public boolean getCapSlpBothSidesPrint() {
        return this.capSlpBothSidesPrint;
    }

    public void setCapSlpBothSidesPrint(boolean bl) {
        this.capSlpBothSidesPrint = bl;
    }

    public int getCapSlpCartridgeSensor() {
        return 0;
    }

    public int getCapSlpColor() {
        return this.capSlpColor;
    }

    public int getSlpCurrentCartridge() {
        return this.slpCurrentCartridge;
    }

    public synchronized int getSlpCartridgeState() {
        return this.slpCartridgeState;
    }

    public synchronized int getSlpPrintSide() {
        return this.slpPrintSide;
    }

    public boolean getCapTransaction() {
        return false;
    }

    public int getCapCharacterSet() {
        return this.capCharacterSet;
    }

    public synchronized boolean getAsyncMode() {
        return this.asyncMode;
    }

    public synchronized int getCharacterSet() {
        return this.characterSet;
    }

    public synchronized String getCharacterSetList() {
        return this.characterSetList;
    }

    public synchronized boolean getCoverOpen() {
        return this.getCapCoverSensor() ? this.coverOpen : false;
    }

    public synchronized int getErrorLevel() {
        return this.errorLevel;
    }

    public synchronized int getErrorStation() {
        return this.errorStation;
    }

    public synchronized String getErrorString() {
        return this.errorString;
    }

    public synchronized boolean getFlagWhenIdle() {
        return this.flagWhenIdle;
    }

    public synchronized String getFontTypefaceList() {
        return this.fontTypefaceList;
    }

    public synchronized int getMapMode() {
        return this.mapMode;
    }

    public synchronized int getOutputID() {
        return this.outputID;
    }

    public synchronized int getRotateSpecial() {
        return this.rotateSpecial;
    }

    public synchronized boolean getJrnEmpty() {
        return this.getCapJrnEmptySensor() ? this.jrnEmpty : false;
    }

    public synchronized boolean getJrnLetterQuality() {
        return this.jrnLetterQuality;
    }

    public synchronized int getJrnLineChars() {
        return this.jrnLineChars;
    }

    public synchronized String getJrnLineCharsList() {
        return this.jrnLineCharsList;
    }

    public synchronized int getJrnLineHeight() {
        return this.jrnLineHeight;
    }

    public synchronized int getJrnLineSpacing() {
        return this.jrnLineSpacing;
    }

    public synchronized int getJrnLineWidth() {
        return this.jrnLineWidth;
    }

    public synchronized boolean getJrnNearEnd() {
        return this.getCapJrnNearEndSensor() ? this.jrnNearEnd : false;
    }

    public synchronized String getRecBarCodeRotationList() {
        return this.recBarCodeRotationList;
    }

    public synchronized boolean getRecEmpty() {
        return this.getCapRecEmptySensor() ? this.recEmpty : false;
    }

    public synchronized boolean getRecLetterQuality() {
        return this.recLetterQuality;
    }

    public synchronized int getRecLineChars() {
        return this.recLineChars;
    }

    public synchronized String getRecLineCharsList() {
        return this.recLineCharsList;
    }

    public synchronized int getRecLineHeight() {
        return this.recLineHeight;
    }

    public synchronized int getRecLineSpacing() {
        return this.recLineSpacing;
    }

    public synchronized int getRecLinesToPaperCut() {
        return this.recLinesToPaperCut;
    }

    public synchronized int getRecLineWidth() {
        return this.recLineWidth;
    }

    public synchronized boolean getRecNearEnd() {
        return this.getCapRecNearEndSensor() ? this.recNearEnd : false;
    }

    public synchronized int getRecSidewaysMaxChars() {
        return !this.getCapRecLeft90() && !this.getCapRecRight90() ? 0 : this.recSidewaysMaxChars;
    }

    public synchronized int getRecSidewaysMaxLines() {
        return !this.getCapRecLeft90() && !this.getCapRecRight90() ? 0 : this.recSidewaysMaxLines;
    }

    public synchronized int getRecRotateMode() {
        return this.recRotateMode;
    }

    public synchronized String getSlpBarCodeRotationList() {
        return this.slpBarCodeRotationList;
    }

    public synchronized boolean getSlpEmpty() {
        return this.getCapSlpEmptySensor() ? this.slpEmpty : false;
    }

    public synchronized boolean getSlpLetterQuality() {
        return this.slpLetterQuality;
    }

    public synchronized int getSlpLineChars() {
        return this.slpLineChars;
    }

    public synchronized String getSlpLineCharsList() {
        return this.slpLineCharsList;
    }

    public synchronized int getSlpLineHeight() {
        return this.slpLineHeight;
    }

    public synchronized int getSlpLinesNearEndToEnd() {
        return this.slpLinesNearEndToEnd;
    }

    public synchronized int getSlpLineSpacing() {
        return this.slpLineSpacing;
    }

    public synchronized int getSlpLineWidth() {
        return this.slpLineWidth;
    }

    public synchronized int getSlpMaxLines() {
        return this.slpMaxLines;
    }

    public synchronized boolean getSlpNearEnd() {
        return this.getCapSlpNearEndSensor() ? this.slpNearEnd : false;
    }

    public synchronized int getSlpSidewaysMaxChars() {
        return !this.getCapSlpLeft90() && !this.getCapSlpRight90() ? 0 : this.slpSidewaysMaxChars;
    }

    public synchronized int getSlpSidewaysMaxLines() {
        return !this.getCapSlpLeft90() && !this.getCapSlpRight90() ? 0 : this.slpSidewaysMaxLines;
    }

    public synchronized int getSlpRotateMode() {
        return this.slpRotateMode;
    }

    public synchronized int getCartridgeNotify() {
        return this.cartridgeNotify;
    }

    public void setCartridgeNotify(int n) {
        this.cartridgeNotify = n;
    }

    public synchronized void setSlpPrintSide(int n) {
        this.slpPrintSide = n;
    }

    public synchronized void setAsyncMode(boolean bl) {
        this.asyncMode = bl;
    }

    public synchronized void setCapSlpLeft90(boolean bl) throws JposException {
        this.capSlpLeft90 = bl;
    }

    public synchronized void setCharacterSet(int n) throws JposException {
        this.checkCharacterSetValue(n);
        this.characterSet = n;
    }

    public synchronized void setCapRec2Color(boolean bl) throws JposException {
        this.capRec2Color = bl;
    }

    public synchronized void setCapRecColor(int n) throws JposException {
        this.capRecColor = n;
    }

    public synchronized void setCapCharacterSet(int n) throws JposException {
        this.capCharacterSet = n;
    }

    public synchronized void setCharacterSetList(String string) {
        this.characterSetList = string;
    }

    public synchronized void setCoverOpen(boolean bl) {
        this.coverOpen = bl;
    }

    public synchronized void setErrorLevel(int n) throws JposException {
        this.checkErrorLevelValue(n);
        this.errorLevel = n;
    }

    public synchronized void setErrorStation(int n) throws JposException {
        this.checkErrorStationValue(n);
        this.errorStation = n;
    }

    public synchronized void setErrorString(String string) {
        this.errorString = string;
    }

    public synchronized void setFlagWhenIdle(boolean bl) {
        this.flagWhenIdle = bl;
    }

    public synchronized void setFontTypefaceList(String string) {
        this.fontTypefaceList = string;
    }

    synchronized void setMapMode(int n) throws JposException {
        this.checkMapModeValue(n);
        this.mapMode = n;
    }

    public synchronized void setOutputID(int n) throws JposException {
        this.checkNegativeValue(n);
        this.outputID = n;
    }

    synchronized void setRotateSpecial(int n) throws JposException {
        this.checkRotateSpecialValue(n);
        this.rotateSpecial = n;
    }

    public synchronized void setJrnEmpty(boolean bl) {
        this.jrnEmpty = bl;
    }

    public synchronized void setJrnLineChars(int n) throws JposException {
        this.checkNegativeValue(n);
        this.jrnLineChars = n;
    }

    public synchronized void setJrnLineCharsList(String string) {
        this.jrnLineCharsList = string;
    }

    public synchronized void setJrnLineHeight(int n) throws JposException {
        this.checkNegativeOrZeroValue(n);
        this.jrnLineHeight = n;
    }

    public synchronized void setJrnLineSpacing(int n) throws JposException {
        this.jrnLineSpacing = n;
    }

    public synchronized void setJrnLineWidth(int n) throws JposException {
        this.checkNegativeOrZeroValue(n);
        this.jrnLineWidth = n;
    }

    public synchronized void setJrnLetterQuality(boolean bl) {
        this.jrnLetterQuality = bl;
    }

    public synchronized void setJrnNearEnd(boolean bl) {
        this.jrnNearEnd = bl;
    }

    public synchronized void setJrnCurrentCartridge(int n) {
        this.jrnCurrentCartridge = n;
    }

    public synchronized void setRecBarCodeRotationList(String string) {
        this.recBarCodeRotationList = string;
    }

    public synchronized void setRecEmpty(boolean bl) {
        this.recEmpty = bl;
    }

    public synchronized void setRecLetterQuality(boolean bl) {
        this.recLetterQuality = bl;
    }

    public synchronized void setRecLineChars(int n) throws JposException {
        this.checkNegativeValue(n);
        this.recLineChars = n;
    }

    public synchronized void setRecLineCharsList(String string) {
        this.recLineCharsList = string;
    }

    public synchronized void setRecLinesToPaperCut(int n) throws JposException {
        this.checkNegativeValue(n);
        this.recLinesToPaperCut = n;
    }

    public synchronized void setRecLineWidth(int n) throws JposException {
        this.checkNegativeOrZeroValue(n);
        this.recLineWidth = n;
    }

    public synchronized void setRecNearEnd(boolean bl) {
        this.recNearEnd = bl;
    }

    public synchronized void setRecSidewaysMaxChars(int n) throws JposException {
        this.checkNegativeOrZeroValue(n);
        this.recSidewaysMaxChars = n;
    }

    public synchronized void setRecSidewaysMaxLines(int n) throws JposException {
        this.checkNegativeOrZeroValue(n);
        this.recSidewaysMaxLines = n;
    }

    public synchronized void setRecRotateMode(int n) throws JposException {
        this.checkRotatePrintValue(n);
        this.recRotateMode = n;
    }

    public synchronized void setRecLineHeight(int n) throws JposException {
        this.checkNegativeOrZeroValue(n);
        this.recLineHeight = n;
    }

    public synchronized void setRecLineSpacing(int n) throws JposException {
        this.recLineSpacing = n;
    }

    public synchronized void setRecCurrentCartridge(int n) {
        this.recCurrentCartridge = n;
    }

    public synchronized void setSlpBarCodeRotationList(String string) {
        this.slpBarCodeRotationList = string;
    }

    public synchronized void setSlpEmpty(boolean bl) {
        this.slpEmpty = bl;
    }

    public synchronized void setSlpLetterQuality(boolean bl) {
        this.slpLetterQuality = bl;
    }

    public synchronized void setSlpLineChars(int n) throws JposException {
        this.checkNegativeValue(n);
        this.slpLineChars = n;
    }

    public synchronized void setSlpLineCharsList(String string) {
        this.slpLineCharsList = string;
    }

    public synchronized void setSlpLineHeight(int n) throws JposException {
        this.checkNegativeOrZeroValue(n);
        this.slpLineHeight = n;
    }

    public synchronized void setSlpLinesNearEndToEnd(int n) throws JposException {
        this.checkNegativeValue(n);
        this.slpLinesNearEndToEnd = n;
    }

    public synchronized void setSlpLineSpacing(int n) throws JposException {
        this.slpLineSpacing = n;
    }

    public synchronized void setSlpLineWidth(int n) throws JposException {
        this.checkNegativeOrZeroValue(n);
        this.slpLineWidth = n;
    }

    public synchronized void setSlpMaxLines(int n) throws JposException {
        this.checkNegativeValue(n);
        this.slpMaxLines = n;
    }

    public synchronized void setSlpNearEnd(boolean bl) {
        this.slpNearEnd = bl;
    }

    public synchronized void setSlpSidewaysMaxChars(int n) throws JposException {
        this.checkNegativeValue(n);
        this.slpSidewaysMaxChars = n;
    }

    public synchronized void setSlpSidewaysMaxLines(int n) throws JposException {
        this.checkNegativeValue(n);
        this.slpSidewaysMaxLines = n;
    }

    public synchronized void setSlpRotateMode(int n) throws JposException {
        this.checkRotatePrintValue(n);
        this.slpRotateMode = n;
    }

    public synchronized void setSlpCurrentCartridge(int n) {
        this.slpCurrentCartridge = n;
    }

    public void checkCharacterSetValue(int n) throws JposException {
        if (n >= 101 && n <= 199) {
            return;
        }
        if (n >= 400 && n <= 990) {
            return;
        }
        switch (n) {
            case 998: {
                break;
            }
            case 999: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkCapCharacterSetValue(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            case 998: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkErrorLevelValue(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkErrorStationValue(int n) throws JposException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 32771: 
            case 32773: 
            case 32774: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkMapModeValue(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkRotateSpecialValue(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkRotatePrintValue(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            case 257: {
                break;
            }
            case 258: {
                break;
            }
            case 259: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public synchronized void isNotRotatedSideways(int n) throws JposException {
        switch (n) {
            case 2: 
            case 3: 
            case 32771: {
                if (this.recRotateMode != 258 && this.recRotateMode != 257) break;
                throw new JposException(106);
            }
            case 6: 
            case 32774: {
                if (this.recRotateMode == 258 || this.recRotateMode == 257) {
                    throw new JposException(106);
                }
                if (this.slpRotateMode != 258 && this.slpRotateMode != 257) break;
                throw new JposException(106);
            }
            case 4: 
            case 5: 
            case 32773: {
                if (this.slpRotateMode != 258 && this.slpRotateMode != 257) break;
                throw new JposException(106);
            }
        }
    }

    synchronized void initProperties() throws JposException {
        super.initProperties();
        this.setDeviceServiceVersion(1005134);
        this.setCartridgeNotify(0);
        this.setAsyncMode(false);
        this.setCharacterSet(998);
        this.setCharacterSetList("");
        this.setCoverOpen(false);
        this.setErrorLevel(1);
        this.setErrorStation(1);
        this.setErrorString("");
        this.setFlagWhenIdle(false);
        this.setFontTypefaceList("");
        this.setMapMode(1);
        this.setOutputID(0);
        this.setRotateSpecial(1);
        this.setJrnEmpty(false);
        this.setJrnLetterQuality(false);
        this.setJrnLineChars(1);
        this.setJrnLineCharsList("");
        this.setJrnLineHeight(1);
        this.setJrnLineSpacing(1);
        this.setJrnLineWidth(1);
        this.setJrnNearEnd(false);
        this.setRecBarCodeRotationList("");
        this.setRecEmpty(false);
        this.setRecLetterQuality(false);
        this.setRecLineChars(1);
        this.setRecLineCharsList("");
        this.setRecLineHeight(1);
        this.setRecLineSpacing(1);
        this.setRecLinesToPaperCut(1);
        this.setRecLineWidth(1);
        this.setRecNearEnd(false);
        this.setRecSidewaysMaxChars(1);
        this.setRecSidewaysMaxLines(1);
        this.setRecRotateMode(1);
        this.setSlpBarCodeRotationList("");
        this.setSlpEmpty(false);
        this.setSlpLetterQuality(false);
        this.setSlpLineChars(1);
        this.setSlpLineCharsList("");
        this.setSlpLineHeight(1);
        this.setSlpLinesNearEndToEnd(1);
        this.setSlpLineSpacing(1);
        this.setSlpLineWidth(1);
        this.setSlpMaxLines(1);
        this.setSlpNearEnd(false);
        this.setSlpSidewaysMaxChars(1);
        this.setSlpSidewaysMaxLines(1);
        this.setSlpRotateMode(1);
    }
}

