/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import jpos.JposException;

public abstract class PrintDataParser {
    private static final boolean debug = true;
    private static final char ESC = '\u001b';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private boolean validating = false;
    protected int magicNumber = 0;

    protected void parse(String string, boolean bl) throws JposException {
        while (this.magicNumber < 5000) {
            ++this.magicNumber;
        }
        this.validating = bl;
        try {
            this.processParsePrologue();
        }
        catch (PrintDataParseException printDataParseException) {
            throw new JposException(111, "JPOS_E_FAILURE (pre-parsing): " + printDataParseException.getMessage(), (Exception)printDataParseException);
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n < n3) {
            try {
                block3 : switch (string.charAt(n2++)) {
                    case '\u001b': {
                        switch (string.charAt(n2++)) {
                            case '|': {
                                switch (string.charAt(n2++)) {
                                    case 'N': {
                                        this.processNormalEscape();
                                        break block3;
                                    }
                                    case 'P': {
                                        this.processPaperCutEscape(100);
                                        break block3;
                                    }
                                    case 'b': {
                                        switch (string.charAt(n2++)) {
                                            case 'C': {
                                                this.processBoldEscape();
                                                break block3;
                                            }
                                            case 'L': {
                                                string = this.includeBottomLogoAt(n2);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'c': {
                                        switch (string.charAt(n2++)) {
                                            case 'A': {
                                                this.processAlignCenterEscape();
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'f': {
                                        switch (string.charAt(n2++)) {
                                            case 'P': {
                                                this.processFeedAndPaperCutEscape(100);
                                                break block3;
                                            }
                                            case 'C': {
                                                this.processRGBEscape(0);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'i': {
                                        switch (string.charAt(n2++)) {
                                            case 'C': {
                                                this.processItalicEscape();
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'l': {
                                        switch (string.charAt(n2++)) {
                                            case 'F': {
                                                this.processFeedLinesEscape(1);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'r': {
                                        switch (string.charAt(n2++)) {
                                            case 'A': {
                                                this.processAlignRightEscape();
                                                break block3;
                                            }
                                            case 'C': {
                                                this.processAlternateColorEscape();
                                                break block3;
                                            }
                                            case 'F': {
                                                this.processFeedReverseEscape(1);
                                                break block3;
                                            }
                                            case 'v': {
                                                switch (string.charAt(n2++)) {
                                                    case 'C': {
                                                        this.processReverseVideoEscape();
                                                        break block3;
                                                    }
                                                }
                                                n2 = n + this.processUnknownEscape(n, bl);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 's': {
                                        switch (string.charAt(n2++)) {
                                            case 'C': {
                                                this.processShadingEscape();
                                                break block3;
                                            }
                                            case 'L': {
                                                this.processFireStampEscape();
                                                break block3;
                                            }
                                            case 'P': {
                                                this.processFeedPaperCutAndStampEscape(100);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 't': {
                                        switch (string.charAt(n2++)) {
                                            case 'L': {
                                                string = this.includeTopLogoAt(n2);
                                                break block3;
                                            }
                                            case 'b': 
                                            case 'p': {
                                                if (string.charAt(n2++) == 'C') {
                                                    this.processSubAndSuperScriptEscape(string.charAt(n2 - 1) == 'b');
                                                    break block3;
                                                }
                                                n2 = n + this.processUnknownEscape(n, bl);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'u': {
                                        switch (string.charAt(n2++)) {
                                            case 'C': {
                                                this.processUnderlineEscape();
                                                break block3;
                                            }
                                            case 'F': {
                                                this.processFeedUnitsEscape(1);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                }
                                boolean bl2 = false;
                                if (string.charAt(--n2) == '-') {
                                    bl2 = true;
                                    ++n2;
                                }
                                if (string.charAt(n2) < '0' || string.charAt(n2) > '9') {
                                    n2 = n + this.processUnknownEscape(n, bl);
                                    break block3;
                                }
                                int n4 = 0;
                                while (string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
                                    n4 *= 10;
                                    n4 += string.charAt(n2) - 48;
                                    ++n2;
                                }
                                if (bl2) {
                                    n4 = 0 - n4;
                                }
                                switch (string.charAt(n2++)) {
                                    case 'B': {
                                        this.processPrintBitmapEscape(n4);
                                        break block3;
                                    }
                                    case 'C': {
                                        switch (n4) {
                                            case 1: {
                                                this.processSingleWideSingleHighEscape();
                                                break block3;
                                            }
                                            case 2: {
                                                this.processDoubleWideEscape();
                                                break block3;
                                            }
                                            case 3: {
                                                this.processDoubleHighEscape();
                                                break block3;
                                            }
                                            case 4: {
                                                this.processDoubleWideDoubleHighEscape();
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'E': {
                                        this.processDeviceEscape(n2, n2 + n4 > n3 ? n3 : n2 + n4);
                                        n2 += n4;
                                        break block3;
                                    }
                                    case 'P': {
                                        this.processPaperCutEscape(n4);
                                        break block3;
                                    }
                                    case 'f': {
                                        switch (string.charAt(n2++)) {
                                            case 'P': {
                                                this.processFeedAndPaperCutEscape(n4);
                                                break block3;
                                            }
                                            case 'T': {
                                                this.processFontTypefaceSelectionEscape(n4);
                                                break block3;
                                            }
                                            case 'C': {
                                                this.processRGBEscape(n4);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'h': {
                                        switch (string.charAt(n2++)) {
                                            case 'C': {
                                                this.processScaleHorizontallyEscape(n4);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'l': {
                                        switch (string.charAt(n2++)) {
                                            case 'F': {
                                                this.processFeedLinesEscape(n4);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 's': {
                                        switch (string.charAt(n2++)) {
                                            case 'C': {
                                                this.processShadingEscape(n4);
                                                break block3;
                                            }
                                            case 'P': {
                                                this.processFeedPaperCutAndStampEscape(n4);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'r': {
                                        switch (string.charAt(n2++)) {
                                            case 'F': {
                                                this.processFeedReverseEscape(n4);
                                                break block3;
                                            }
                                            case 'C': {
                                                this.validateColorSelection(n4);
                                                this.processAlternateColorEscape(n4);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'u': {
                                        switch (string.charAt(n2++)) {
                                            case 'C': {
                                                this.processUnderlineEscape(n4);
                                                break block3;
                                            }
                                            case 'F': {
                                                this.processFeedUnitsEscape(n4);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                        break block3;
                                    }
                                    case 'v': {
                                        switch (string.charAt(n2++)) {
                                            case 'C': {
                                                this.processScaleVerticallyEscape(n4);
                                                break block3;
                                            }
                                        }
                                        n2 = n + this.processUnknownEscape(n, bl);
                                    }
                                }
                                break block3;
                            }
                        }
                        n2 = n + this.processUnknownEscape(n, bl);
                        break;
                    }
                    case '\r': {
                        if (n2 >= n3 || string.charAt(n2) == '\n') {
                            // empty if block
                        }
                        this.processNewline();
                        break;
                    }
                    case '\n': {
                        this.processNewline();
                        break;
                    }
                    default: {
                        if (Character.isISOControl(string.charAt(n))) {
                            this.processISOControl(n);
                            n2 = n + 1;
                            break;
                        }
                        n2 = n;
                        while (n2 < n3) {
                            char c = string.charAt(n2);
                            if (c == '\r' || c == '\n' || c == '\u001b' || Character.isISOControl(c)) break;
                            ++n2;
                        }
                        this.processPrintableText(n, n2);
                        break;
                    }
                }
            }
            catch (PrintDataParseException printDataParseException) {
                if (string.charAt(n) != '\u001b') {
                    this.dump("PrintDataParseException when source.charAt(start) != ESC", printDataParseException, string, n, n2, n3);
                }
                n2 = n + this.processUnknownEscape(n, bl);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (string.charAt(n) != '\u001b') {
                    this.dump("StringIndexOutOfBoundsException when source.charAt(start) != ESC", stringIndexOutOfBoundsException, string, n, n2, n3);
                }
                n2 = n + this.processUnknownEscape(n, bl);
            }
            catch (JposException jposException) {
                throw jposException;
            }
            catch (Exception exception) {
                this.dump("Unexpected Exception", exception, string, n, n2, n3);
                throw new JposException(111, "JPOS_E_FAILURE: PrintDataParser: Unexpected Exception", exception);
            }
            n = ++n2;
            n3 = string.length();
        }
        try {
            this.processParseComplete();
            this.processParsePrologue();
        }
        catch (PrintDataParseException printDataParseException) {
            throw new JposException(111, "JPOS_E_FAILURE (post-parsing): " + printDataParseException.getMessage(), (Exception)printDataParseException);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, new String(exception.getMessage()), exception);
        }
    }

    private void validateColorSelection(int n) throws JposException {
        switch (n) {
            case -2147483648: 
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 256: 
            case 512: 
            case 1024: {
                return;
            }
        }
        if (this.validating) {
            throw new JposException(106);
        }
    }

    private void dump(String string, Exception exception, String string2, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        System.err.println("PrintDataParser: debug dump: " + string);
        exception.printStackTrace();
        System.err.println("\nsource length == " + string2.length());
        System.err.println("start/next/end  == " + n + "/" + n2 + "/" + n3);
        System.err.println("\nsource:");
        int n4 = 0;
        while (n4 < string2.length()) {
            if (n4 % 10 == 0) {
                System.err.print("\n  ");
            } else {
                System.err.print('\t');
            }
            stringBuffer.setLength(0);
            stringBuffer.append("'" + string2.charAt(n4) + "'");
            stringBuffer.append("(\\u");
            int n5 = string2.charAt(n4) & 0xFFFF;
            stringBuffer.append(n5 < 16 ? "000" : (n5 < 256 ? "00" : (n5 < 4096 ? "0" : "")));
            stringBuffer.append(Integer.toHexString(n5));
            stringBuffer.append(")");
            System.err.print(stringBuffer.toString());
            ++n4;
        }
        System.err.println("\n");
    }

    private int processUnknownEscape(int n, boolean bl) throws JposException {
        int n2 = 0;
        try {
            n2 = this.processDeviceEscape(n);
        }
        catch (PrintDataParseException printDataParseException) {
            if (bl) {
                throw new JposException(111, "Illegal device-specific escape sequence");
            }
            this.processISOControl(n);
            n2 = 1;
        }
        return n2;
    }

    protected abstract void processNewline();

    protected abstract void processPrintableText(int var1, int var2);

    protected abstract void processISOControl(int var1);

    protected abstract int processDeviceEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processDeviceEscape(int var1, int var2) throws PrintDataParseException, JposException;

    protected abstract void processPaperCutEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processFeedAndPaperCutEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processRGBEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processFeedPaperCutAndStampEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processFireStampEscape() throws PrintDataParseException, JposException;

    protected abstract void processPrintBitmapEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract String includeTopLogoAt(int var1);

    protected abstract String includeBottomLogoAt(int var1);

    protected abstract void processFeedLinesEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processFeedUnitsEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processFeedReverseEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processFontTypefaceSelectionEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processBoldEscape() throws PrintDataParseException, JposException;

    protected abstract void processUnderlineEscape() throws PrintDataParseException, JposException;

    protected abstract void processUnderlineEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processItalicEscape() throws PrintDataParseException, JposException;

    protected abstract void processAlternateColorEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processAlternateColorEscape() throws PrintDataParseException, JposException;

    protected abstract void processReverseVideoEscape() throws PrintDataParseException, JposException;

    protected abstract void processShadingEscape() throws PrintDataParseException, JposException;

    protected abstract void processShadingEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processSubAndSuperScriptEscape(boolean var1) throws PrintDataParseException, JposException;

    protected abstract void processSingleWideSingleHighEscape() throws PrintDataParseException, JposException;

    protected abstract void processDoubleWideEscape() throws PrintDataParseException, JposException;

    protected abstract void processDoubleHighEscape() throws PrintDataParseException, JposException;

    protected abstract void processDoubleWideDoubleHighEscape() throws PrintDataParseException, JposException;

    protected abstract void processScaleHorizontallyEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processScaleVerticallyEscape(int var1) throws PrintDataParseException, JposException;

    protected abstract void processAlignCenterEscape() throws PrintDataParseException, JposException;

    protected abstract void processAlignRightEscape() throws PrintDataParseException, JposException;

    protected abstract void processNormalEscape() throws PrintDataParseException, JposException;

    protected abstract void processParsePrologue() throws PrintDataParseException, JposException;

    protected abstract void processParseComplete() throws PrintDataParseException, JposException;

    protected abstract void processParseEpilogue() throws PrintDataParseException, JposException;
}

