/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.jcomm.IBM4610PrintDataCompiler;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Printer;
import jpos.JposException;
import jpos.POSPrinterConst;

public class IBM4610EPrintDataCompiler
extends IBM4610PrintDataCompiler
implements POSPrinterConst,
Printer {
    private static final String className = "IBM4610EPrintDataCompiler";
    private PrinterFont selectedPrinterFont = null;

    IBM4610EPrintDataCompiler(POSPrinterServiceState pOSPrinterServiceState) throws JposException {
        super(pOSPrinterServiceState);
    }

    protected byte[] getPrologueBytes() throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getPrologueBytes()", "Entry");
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        ByteBuffer byteBuffer = new ByteBuffer();
        int n = this.getStation();
        int n2 = 0;
        int n3 = -1;
        block0 : switch (n) {
            case 2: {
                n2 = this.getServiceState().getRecLineChars();
                switch (this.getRotation()) {
                    case 1: {
                        byteBuffer.append(27).append(123).append(0);
                        break block0;
                    }
                    case 259: {
                        byteBuffer.append(27).append(123).append(1);
                        break block0;
                    }
                }
                throw new JposException(111, "unsupported rotation");
            }
            case 4: {
                n2 = this.getServiceState().getSlpLineChars();
                switch (this.getRotation()) {
                    case 1: {
                        byteBuffer.append(27).append(99).append(49).append(4);
                        break block0;
                    }
                    case 258: {
                        this.reverseLines();
                        byteBuffer.append(27).append(99).append(49).append(8);
                        break block0;
                    }
                }
                throw new JposException(111, "unsupported rotation");
            }
            default: {
                throw new JposException(111);
            }
        }
        int n4 = 0;
        while (n4 < printerFontArray.length) {
            if (printerFontArray[n4].station == n) {
                if (printerFontArray[n4].lineChars == n2) {
                    n3 = n4;
                    break;
                }
                if (printerFontArray[n4].lineChars > n2 && (n3 == -1 || printerFontArray[n3].lineChars > printerFontArray[n4].lineChars)) {
                    n3 = n4;
                }
            }
            ++n4;
        }
        Tracer.trace(4, className, "getPrologueBytes()", "lineChars == " + n2);
        if (n3 == -1) {
            throw new JposException(111);
        }
        this.selectedPrinterFont = printerFontArray[n3];
        Tracer.trace(4, className, "getPrologueBytes()", "bestMatch == " + this.selectedPrinterFont.lineChars);
        block12 : switch (n) {
            case 4: {
                if (this.selectedPrinterFont.diWidth == 0) {
                    byteBuffer.append(27).append(36).append(0).append(0);
                } else if (this.selectedPrinterFont.fontType == 2) {
                    byteBuffer.append(27).append(36).append(0).append(72);
                } else {
                    byteBuffer.append(27).append(36).append(0).append(90);
                }
                switch (this.selectedPrinterFont.fontType) {
                    case 2: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(1, true);
                        this.setPrinterMode(2, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using spread font");
                        break block12;
                    }
                    case 1: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(3, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using normal font");
                        break block12;
                    }
                    case 3: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(3, false);
                        Tracer.trace(4, className, "getPrologueBytes()", "using small font");
                        break block12;
                    }
                    case 5: {
                        byteBuffer.append(27).append(82).append(6);
                        break block12;
                    }
                    case 13: {
                        byteBuffer.append(27).append(32).append(4);
                        byteBuffer.append(27).append(82).append(8);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                    case 14: {
                        byteBuffer.append(27).append(32).append(3);
                        byteBuffer.append(27).append(82).append(6);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                    case 15: {
                        byteBuffer.append(27).append(32).append(2);
                        byteBuffer.append(27).append(82).append(4);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                    case 16: {
                        byteBuffer.append(27).append(32).append(1);
                        byteBuffer.append(27).append(82).append(2);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                    case 17: {
                        byteBuffer.append(27).append(32).append(0);
                        byteBuffer.append(27).append(82).append(0);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                }
                Tracer.trace(4, className, "getPrologueBytes()", "unrecognized font");
                throw new JposException(106);
            }
            case 2: {
                switch (this.selectedPrinterFont.fontType) {
                    case 2: {
                        byteBuffer.append(27).append(32).append(5);
                        this.setPrinterMode(1, true);
                        this.setPrinterMode(2, false);
                        break block12;
                    }
                    case 1: {
                        byteBuffer.append(27).append(32).append(3);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                    case 3: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                    case 4: {
                        byteBuffer.append(27).append(32).append(2);
                        this.setPrinterMode(1, false);
                        this.setPrinterMode(2, true);
                        break block12;
                    }
                    case 5: {
                        byteBuffer.append(27).append(82).append(6);
                        break block12;
                    }
                    case 10: {
                        byteBuffer.append(27).append(32).append(3);
                        byteBuffer.append(27).append(82).append(6);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                    case 11: {
                        byteBuffer.append(27).append(32).append(1);
                        byteBuffer.append(27).append(82).append(2);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                    case 12: {
                        byteBuffer.append(27).append(32).append(0);
                        byteBuffer.append(27).append(82).append(0);
                        this.setPrinterMode(3, false);
                        break block12;
                    }
                }
                throw new JposException(111, "unrecognized font");
            }
            default: {
                Tracer.trace(4, className, "getPrologueBytes()", "non-supported station");
                throw new JposException(106);
            }
        }
        byteBuffer.append(27).append(33).append(this.getPrinterMode());
        Tracer.trace(4, className, "getPrologueBytes()", "Exit");
        return byteBuffer.getBytes();
    }

    protected byte[] getAlternateColorBytes(int n) throws PrintDataParseException, JposException {
        switch (n) {
            case 1: {
                return new byte[]{27, 114, 0};
            }
            case 2: {
                return new byte[]{27, 114, 1};
            }
        }
        return new byte[0];
    }

    protected byte[] getNormalBytes() {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.append(super.getNormalBytes());
        byteBuffer.append(27).append(114);
        if (this.getStation() == 2 && this.getServiceState().getRecCurrentCartridge() == 2) {
            byteBuffer.append(1);
        } else {
            byteBuffer.append(0);
        }
        return byteBuffer.getBytes();
    }

    protected byte[] getScaleHorizontallyBytes(int n) throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getScaleHorizontallyBytes()", "Entry");
        if ((n > 8 || n < 1) && this.isValidating()) {
            throw new JposException(106);
        }
        n = this.getActualHorizontalScaleFactor(n);
        Tracer.trace(4, className, "getScaleHorizontallyBytes()", "Actual factor = " + n);
        return new byte[]{29, 33, this.scaleByte(n, this.currentVerticalScale)};
    }

    protected byte[] getScaleVerticallyBytes(int n) throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getScaleVerticallyBytes()", "Entry");
        if ((n > 8 || n < 1) && this.isValidating()) {
            throw new JposException(106);
        }
        n = this.getActualVerticalScaleFactor(n);
        Tracer.trace(4, className, "getScaleVerticallyBytes()", "Actual factor = " + n);
        return new byte[]{29, 33, this.scaleByte(this.currentHorizontalScale, n)};
    }

    protected int getActualHorizontalScaleFactor(int n) {
        return this.getActualScaleFactor(n);
    }

    protected int getActualVerticalScaleFactor(int n) {
        return this.getActualScaleFactor(n);
    }

    protected int getActualScaleFactor(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 8) {
            n = 8;
        }
        return n;
    }

    private byte scaleByte(int n, int n2) {
        this.currentHorizontalScale = n--;
        this.currentVerticalScale = n2--;
        return (byte)((n << 4) + n2);
    }
}

