/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

public class Rs232MsrDataHdr {
    private static final byte TRACK_ERROR = 69;
    private static final byte TRACK1_START_SENTINAL = 37;
    private static final byte TRACK2_START_SENTINAL = 59;
    private static final byte TRACK3_START_SENTINAL = 43;
    private static final byte TRACKJ_START_SENTINAL = 37;
    private static final byte TRACK_END_SENTINAL = 63;
    private static final byte POS_MSR_TRK_ERROR = 1;
    private int track = 0;
    private boolean trackError = false;
    private short length = 0;
    private int trackIndex = 0;

    private Rs232MsrDataHdr() {
    }

    public Rs232MsrDataHdr(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(byArray, 0);
    }

    public Rs232MsrDataHdr(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = n;
        this.trackError = false;
        if (n2 < byArray.length) {
            if (byArray[n2] == 69) {
                this.trackError = true;
                this.trackIndex = n2;
            } else {
                this.track = 0;
                if (byArray[n2] == 37) {
                    this.track = 1;
                }
                if (byArray[n2] == 59) {
                    this.track = 2;
                }
                if (byArray[n2] == 43) {
                    this.track = 4;
                }
                if (byArray[n2] == 37) {
                    this.track = 8;
                }
                if (byArray[++n2] == 69) {
                    this.trackError = true;
                }
                this.length = 0;
                while (this.track != 0 && byArray[n2] != 63) {
                    this.length = (short)(this.length + 1);
                    ++n2;
                }
                this.trackIndex = n2 + 1;
            }
        }
    }

    public int getTrack() {
        return this.track;
    }

    public boolean getTrackError() {
        return this.trackError;
    }

    public short getLength() {
        return this.length;
    }

    public int getTrackIndex() {
        return this.trackIndex;
    }
}

