/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.jcomm.Serial4610Connection;
import com.ibm.jpos.services.jcomm.Serial4610ConnectionClient;
import com.ibm.jpos.services.jcomm.Serial4610Const;
import com.ibm.jpos.services.jcomm.Serial4610Event;
import com.ibm.jpos.services.jcomm.Serial4610PrnChaseCompleteListener;
import com.ibm.jpos.services.jcomm.Serial4610PrnDataAvailListener;
import com.ibm.jpos.services.jcomm.Serial4610PrnPrinterErrorListener;
import com.ibm.jpos.services.jcomm.Serial4610PrnStatusChangeListener;
import com.ibm.jpos.services.jcomm.Serial4610SysDeviceOfflineListener;
import com.ibm.jpos.services.jcomm.Serial4610SysDeviceOnlineListener;
import com.ibm.jpos.services.jcomm.Serial4610TillClosedListener;
import com.ibm.jpos.services.jcomm.Serial4610TillOpenedListener;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Printer;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;
import jpos.JposConst;
import jpos.JposException;
import jpos.config.JposEntry;

public class Serial4610Device
implements JposConst,
Serial4610Const,
Printer {
    private static final byte[] CHASE_CMD = new byte[]{27, 83, 95, 16, 5, 52};
    private Serial4610ConnectionClient client = new Serial4610ConnectionClient(){

        public void serial4610EventOccurred(Serial4610Event serial4610Event) {
            Serial4610Device.this.queue.write(serial4610Event);
        }

        public JposEntry getJposEntry() {
            return Serial4610Device.this.jposEntry;
        }
    };
    private static final String className = "Serial4610Device";
    private int drawerNumber = 1;
    private byte[] openTillCommand = null;
    private byte[] oldStatus = null;
    private byte[] status = null;
    private boolean unlocked = false;
    private boolean drawerOpenSignalsReversed = false;
    private JposEntry jposEntry = null;
    private Queue queue = new Queue();
    private Serial4610Connection serial4610Connection = null;
    private Serial4610PrnChaseCompleteListener serial4610PrnChaseCompleteListener = null;
    private Serial4610PrnDataAvailListener serial4610PrnDataAvailListener = null;
    private Serial4610PrnPrinterErrorListener serial4610PrnPrinterErrorListener = null;
    private Serial4610PrnStatusChangeListener serial4610PrnStatusChangeListener = null;
    private Serial4610SysDeviceOfflineListener serial4610SysDeviceOfflineListener = null;
    private Serial4610SysDeviceOnlineListener serial4610SysDeviceOnlineListener = null;
    private Serial4610TillClosedListener serial4610TillClosedListener = null;
    private Serial4610TillOpenedListener serial4610TillOpenedListener = null;

    public synchronized Object getIOSemaphore() throws JposException {
        Tracer.trace(4, className, "getIOSemaphore()", "Entry");
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        Tracer.trace(4, className, "getIOSemaphore()", "Exit");
        return this.serial4610Connection.getIOSemaphore();
    }

    public synchronized void chase() throws JposException {
        Tracer.trace(4, className, "chase()", "Entry");
        try {
            this.serial4610Connection.write(this.client, CHASE_CMD);
        }
        catch (NullPointerException nullPointerException) {
            if (this.serial4610Connection == null) {
                throw new JposException(101);
            }
            nullPointerException.printStackTrace();
            throw new JposException(111, "JPOS_E_FAILURE: Internal Error", (Exception)nullPointerException);
        }
        Tracer.trace(4, className, "chase()", "Exit");
    }

    public synchronized void lock() throws JposException {
        Tracer.trace(4, className, "lock()", "Entry");
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        this.unlocked = false;
        Tracer.trace(4, className, "lock()", "Exit");
    }

    public synchronized void unlock() throws JposException {
        Tracer.trace(4, className, "unlock()", "Entry");
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        if (!this.serial4610Connection.isOnline(this.client)) {
            throw new JposException(108);
        }
        this.unlocked = true;
        Tracer.trace(4, className, "unlock()", "Exit");
    }

    public synchronized boolean isOnline() {
        Tracer.trace(4, className, "isOnline()", "Entry");
        boolean bl = false;
        try {
            bl = this.serial4610Connection.isOnline(this.client);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "isOnline()", "Exit: " + (bl ? "true" : "false"));
        return bl;
    }

    public synchronized int getDefaultCodePage() throws JposException {
        Tracer.trace(4, className, "getDefaultCodePage()", "Entry");
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        int n = this.serial4610Connection.getDefaultCodePage(this.client);
        Tracer.trace(4, className, "getDefaultCodePage()", "Exit, returning " + Integer.toString(n));
        return n;
    }

    public synchronized int getCodePage() throws JposException {
        Tracer.trace(4, className, "getCodePage()", "Entry");
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        int n = this.serial4610Connection.getCodePage(this.client);
        Tracer.trace(4, className, "getCodePage()", "Exit, returning " + Integer.toString(n));
        return n;
    }

    public synchronized void setCodePage(int n) throws JposException {
        Tracer.trace(4, className, "setCodePage(" + Integer.toString(n) + ")", "Entry");
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        this.serial4610Connection.setCodePage(this.client, n);
        Tracer.trace(4, className, "setCodePage()", "Exit");
    }

    public synchronized byte[] getPrinterID() throws JposException {
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        return this.serial4610Connection.getPrinterID(this.client);
    }

    public synchronized byte[] getStatus() throws JposException {
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        return this.serial4610Connection.getStatus(this.client);
    }

    public synchronized void close() throws JposException {
        Tracer.trace(4, className, "close()", "Entry");
        if (this.serial4610Connection != null) {
            this.queue.clear();
            this.queue.write(new Serial4610Event(-1));
            this.serial4610PrnChaseCompleteListener = null;
            this.serial4610PrnDataAvailListener = null;
            this.serial4610PrnPrinterErrorListener = null;
            this.serial4610PrnStatusChangeListener = null;
            this.serial4610SysDeviceOfflineListener = null;
            this.serial4610SysDeviceOnlineListener = null;
            this.serial4610TillClosedListener = null;
            this.serial4610TillOpenedListener = null;
            this.unlocked = false;
            this.serial4610Connection.close(this.client);
            this.serial4610Connection = null;
        }
        Tracer.trace(4, className, "close()", "Exit");
    }

    public synchronized void open(JposEntry jposEntry) throws JposException {
        Tracer.trace(4, className, "open()", "Entry");
        if (this.serial4610Connection == null) {
            this.jposEntry = jposEntry;
            Enumeration enumeration = jposEntry.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equalsIgnoreCase("commSignalsReversed")) {
                    this.drawerOpenSignalsReversed = jposEntry.getPropertyValue(string).toString().equalsIgnoreCase("true");
                }
                if (!string.equalsIgnoreCase("commDrawerNumber")) continue;
                this.drawerNumber = Integer.parseInt(jposEntry.getPropertyValue(string).toString());
                switch (this.drawerNumber) {
                    case 1: {
                        this.openTillCommand = new byte[]{27, 112, 0, 50, 50};
                        break;
                    }
                    case 2: {
                        this.openTillCommand = new byte[]{27, 112, 1, 50, 50};
                        break;
                    }
                    default: {
                        throw new JposException(108);
                    }
                }
            }
            this.queue.clear();
            this.serial4610Connection = Serial4610Connection.open(this.client);
            this.status = this.serial4610Connection.getStatus(this.client);
            this.oldStatus = this.status;
            new QueueReader().start();
        }
        Tracer.trace(4, className, "open()", "Exit");
    }

    public int write(byte[] byArray) throws JposException {
        return this.write(byArray, byArray.length);
    }

    public synchronized int write(byte[] byArray, int n) throws JposException {
        Tracer.trace(4, className, "write()", "Entry");
        if (this.serial4610Connection == null) {
            throw new JposException(101);
        }
        int n2 = this.serial4610Connection.write(this.client, byArray, n);
        Tracer.trace(4, className, "write()", "Exit");
        return n2;
    }

    public final void openTill() throws JposException {
        this.write(this.openTillCommand);
    }

    public final boolean isTillOpen() {
        return this.drawerOpenSignalsReversed ? (this.status[6] & 8) == 0 : (this.status[6] & 8) != 0;
    }

    public synchronized void addSerial4610PrnChaseCompleteListener(Serial4610PrnChaseCompleteListener serial4610PrnChaseCompleteListener) throws TooManyListenersException {
        Tracer.trace(4, className, "addSerial4610PrnChaseCompleteListener()", "Entry");
        if (this.serial4610PrnChaseCompleteListener != null) {
            throw new TooManyListenersException();
        }
        this.serial4610PrnChaseCompleteListener = serial4610PrnChaseCompleteListener;
        Tracer.trace(4, className, "addSerial4610PrnChaseCompleteListener()", "Exit");
    }

    public synchronized void removeSerial4610PrnChaseCompleteListener() {
        Tracer.trace(4, className, "removeSerial4610PrnChaseCompleteListener()", "Entry");
        this.serial4610PrnChaseCompleteListener = null;
        Tracer.trace(4, className, "removeSerial4610PrnChaseCompleteListener()", "Exit");
    }

    public synchronized void addSerial4610PrnDataAvailListener(Serial4610PrnDataAvailListener serial4610PrnDataAvailListener) throws TooManyListenersException {
        Tracer.trace(4, className, "addSerial4610PrnPrnDataAvailListener()", "Entry");
        if (this.serial4610PrnDataAvailListener != null) {
            throw new TooManyListenersException();
        }
        this.serial4610PrnDataAvailListener = serial4610PrnDataAvailListener;
        Tracer.trace(4, className, "addSerial4610PrnPrnDataAvailListener()", "Exit");
    }

    public synchronized void removeSerial4610PrnDataAvailListener() {
        Tracer.trace(4, className, "removeSerial4610PrnPrnDataAvailListener()", "Entry");
        this.serial4610PrnDataAvailListener = null;
        Tracer.trace(4, className, "removeSerial4610PrnPrnDataAvailListener()", "Exit");
    }

    public synchronized void addSerial4610PrnPrinterErrorListener(Serial4610PrnPrinterErrorListener serial4610PrnPrinterErrorListener) throws TooManyListenersException {
        Tracer.trace(4, className, "addSerial4610PrnPrinterErrorListener()", "Entry");
        if (this.serial4610PrnPrinterErrorListener != null) {
            throw new TooManyListenersException();
        }
        this.serial4610PrnPrinterErrorListener = serial4610PrnPrinterErrorListener;
        Tracer.trace(4, className, "addSerial4610PrnPrinterErrorListener()", "Exit");
    }

    public synchronized void removeSerial4610PrnPrinterErrorListener() {
        Tracer.trace(4, className, "removeSerial4610PrnPrinterErrorListener()", "Entry");
        this.serial4610PrnPrinterErrorListener = null;
        Tracer.trace(4, className, "removeSerial4610PrnPrinterErrorListener()", "Exit");
    }

    public synchronized void addSerial4610PrnStatusChangeListener(Serial4610PrnStatusChangeListener serial4610PrnStatusChangeListener) throws TooManyListenersException {
        Tracer.trace(4, className, "addSerial4610PrnStatusChangeListener()", "Entry");
        if (this.serial4610PrnStatusChangeListener != null) {
            throw new TooManyListenersException();
        }
        this.serial4610PrnStatusChangeListener = serial4610PrnStatusChangeListener;
        Tracer.trace(4, className, "addSerial4610PrnStatusChangeListener()", "Exit");
    }

    public synchronized void removeSerial4610PrnStatusChangeListener() {
        Tracer.trace(4, className, "removeSerial4610PrnStatusChangeListener()", "Entry");
        this.serial4610PrnStatusChangeListener = null;
        Tracer.trace(4, className, "removeSerial4610PrnStatusChangeListener()", "Exit");
    }

    public synchronized void addSerial4610SysDeviceOfflineListener(Serial4610SysDeviceOfflineListener serial4610SysDeviceOfflineListener) throws TooManyListenersException {
        Tracer.trace(4, className, "addSerial4610SysDeviceOfflineListener()", "Entry");
        if (this.serial4610SysDeviceOfflineListener != null) {
            throw new TooManyListenersException();
        }
        this.serial4610SysDeviceOfflineListener = serial4610SysDeviceOfflineListener;
        Tracer.trace(4, className, "addSerial4610SysDeviceOfflineListener()", "Exit");
    }

    public synchronized void removeSerial4610SysDeviceOfflineListener() {
        Tracer.trace(4, className, "removeSerial4610SysDeviceOfflineListener()", "Entry");
        this.serial4610SysDeviceOfflineListener = null;
        Tracer.trace(4, className, "removeSerial4610SysDeviceOfflineListener()", "Exit");
    }

    public synchronized void addSerial4610SysDeviceOnlineListener(Serial4610SysDeviceOnlineListener serial4610SysDeviceOnlineListener) throws TooManyListenersException {
        Tracer.trace(4, className, "addSerial4610SysDeviceOnlineListener()", "Entry");
        if (this.serial4610SysDeviceOnlineListener != null) {
            throw new TooManyListenersException();
        }
        Tracer.trace(4, className, "addSerial4610SysDeviceOnlineListener()", "Exit");
        this.serial4610SysDeviceOnlineListener = serial4610SysDeviceOnlineListener;
    }

    public synchronized void removeSerial4610SysDeviceOnlineListener() {
        Tracer.trace(4, className, "removeSerial4610SysDeviceOnlineListener()", "Entry");
        this.serial4610SysDeviceOnlineListener = null;
        Tracer.trace(4, className, "removeSerial4610SysDeviceOnlineListener()", "Exit");
    }

    public synchronized void addSerial4610TillClosedListener(Serial4610TillClosedListener serial4610TillClosedListener) throws TooManyListenersException {
        Tracer.trace(4, className, "addSerial4610TillClosedListener()", "Entry");
        if (this.serial4610TillClosedListener != null) {
            throw new TooManyListenersException();
        }
        this.serial4610TillClosedListener = serial4610TillClosedListener;
        Tracer.trace(4, className, "addSerial4610TillClosedListener()", "Exit");
    }

    public synchronized void removeSerial4610TillClosedListener() {
        Tracer.trace(4, className, "removeSerial4610TillClosedListener()", "Entry");
        this.serial4610TillClosedListener = null;
        Tracer.trace(4, className, "removeSerial4610TillClosedListener()", "Exit");
    }

    public synchronized void addSerial4610TillOpenedListener(Serial4610TillOpenedListener serial4610TillOpenedListener) throws TooManyListenersException {
        Tracer.trace(4, className, "addSerial4610TillOpenedListener()", "Entry");
        if (this.serial4610TillOpenedListener != null) {
            throw new TooManyListenersException();
        }
        this.serial4610TillOpenedListener = serial4610TillOpenedListener;
        Tracer.trace(4, className, "addSerial4610TillOpenedListener()", "Exit");
    }

    public synchronized void removeSerial4610TillOpenedListener() {
        Tracer.trace(4, className, "removeSerial4610TillOpenedListener()", "Entry");
        this.serial4610TillOpenedListener = null;
        Tracer.trace(4, className, "removeSerial4610TillOpenedListener()", "Exit");
    }

    static /* synthetic */ byte[] access$602(Serial4610Device serial4610Device, byte[] byArray) {
        serial4610Device.oldStatus = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$702(Serial4610Device serial4610Device, byte[] byArray) {
        serial4610Device.status = byArray;
        return byArray;
    }

    private class Queue {
        private Vector v = new Vector();

        private Queue() {
        }

        public synchronized Object read() {
            while (this.v.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Object var1_2 = null;
            var1_2 = this.v.elementAt(0);
            this.v.removeElementAt(0);
            return var1_2;
        }

        public synchronized void write(Object object) {
            this.v.addElement(object);
            this.notify();
        }

        public final synchronized void clear() {
            this.v.removeAllElements();
        }

        public final int size() {
            return this.v.size();
        }
    }

    private class QueueReader
    extends Thread {
        private static final String className = "Serial4610Device.QueueReader";

        private QueueReader() {
        }

        public void run() {
            Tracer.trace(4, className, "run()", "Entry");
            Serial4610Event serial4610Event = null;
            while (true) {
                serial4610Event = (Serial4610Event)Serial4610Device.this.queue.read();
                Serial4610Device serial4610Device = Serial4610Device.this;
                synchronized (serial4610Device) {
                    if (Serial4610Device.this.serial4610Connection == null) {
                        return;
                    }
                    switch (serial4610Event.getEventType()) {
                        case -1: {
                            return;
                        }
                        case 1: {
                            try {
                                Serial4610Device.this.serial4610SysDeviceOfflineListener.serial4610SysDeviceOffline();
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 2: {
                            try {
                                Serial4610Device.this.serial4610SysDeviceOnlineListener.serial4610SysDeviceOnline();
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 3: {
                            if (!Serial4610Device.this.unlocked) break;
                            Serial4610Device.access$602(Serial4610Device.this, Serial4610Device.this.status);
                            Serial4610Device.access$702(Serial4610Device.this, serial4610Event.getStatus());
                            if ((Serial4610Device.this.status[4] & 8) != 0) {
                                try {
                                    Serial4610Device.this.serial4610PrnChaseCompleteListener.serial4610PrnChaseCompleteOccurred();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (serial4610Event.getData().length != 0) {
                                try {
                                    Serial4610Device.this.serial4610PrnDataAvailListener.serial4610PrnDataAvailOccurred(Serial4610Device.this.status, serial4610Event.getData());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if ((Serial4610Device.this.status[0] & 0x80 | Serial4610Device.this.status[2] & 0x7F | Serial4610Device.this.status[6] & 0x80) != 0) {
                                int n = 0;
                                if ((Serial4610Device.this.status[0] & 0x80) != 0) {
                                    n = Short.MIN_VALUE;
                                } else if ((Serial4610Device.this.status[2] & 0x40) != 0) {
                                    n = 16384;
                                } else if ((Serial4610Device.this.status[2] & 0x20) != 0) {
                                    n = 1024;
                                } else if ((Serial4610Device.this.status[2] & 8) != 0) {
                                    n = 512;
                                } else if ((Serial4610Device.this.status[2] & 4) != 0) {
                                    n = 16;
                                } else if ((Serial4610Device.this.status[2] & 2) != 0) {
                                    n = 2;
                                } else if ((Serial4610Device.this.status[2] & 1) != 0) {
                                    n = 1024;
                                } else if ((Serial4610Device.this.status[6] & 0x80) != 0) {
                                    n = 8192;
                                }
                                try {
                                    Serial4610Device.this.serial4610PrnPrinterErrorListener.serial4610PrnPrinterErrorOccurred(Serial4610Device.this.status, n);
                                }
                                catch (Exception exception) {}
                            } else if (((Serial4610Device.this.status[0] ^ Serial4610Device.this.oldStatus[0]) & 0x7F) != 0 || (Serial4610Device.this.status[1] ^ Serial4610Device.this.oldStatus[1]) != 0 || ((Serial4610Device.this.status[2] ^ Serial4610Device.this.oldStatus[2]) & 0x7F) != 0 || ((Serial4610Device.this.status[4] ^ Serial4610Device.this.oldStatus[4]) & 0xFB) != 0 || ((Serial4610Device.this.status[5] ^ Serial4610Device.this.oldStatus[6]) & 0x77) != 0 || (Serial4610Device.this.status[7] ^ Serial4610Device.this.oldStatus[7]) != 0) {
                                try {
                                    Serial4610Device.this.serial4610PrnStatusChangeListener.serial4610PrnStatusChangeOccurred(Serial4610Device.this.status);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (((Serial4610Device.this.status[6] ^ Serial4610Device.this.oldStatus[6]) & 8) == 0) break;
                            try {
                                boolean bl = Serial4610Device.this.drawerOpenSignalsReversed ? (Serial4610Device.this.status[6] & 8) == 0 : (Serial4610Device.this.status[6] & 8) != 0;
                                if (bl) {
                                    Serial4610Device.this.serial4610TillOpenedListener.serial4610TillOpenedOccurred();
                                    break;
                                }
                                Serial4610Device.this.serial4610TillClosedListener.serial4610TillClosedOccurred();
                                break;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }
}

