/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.MICRServiceImp;
import com.ibm.jpos.services.MICRServiceState;
import com.ibm.jpos.services.jcomm.Serial4610Device;
import com.ibm.jpos.services.jcomm.Serial4610DeviceServiceImp;
import com.ibm.jpos.services.jcomm.Serial4610PrnDataAvailListener;
import com.ibm.jpos.services.jcomm.Serial4610PrnPrinterErrorListener;
import com.ibm.jpos.services.jcomm.Serial4610PrnStatusChangeListener;
import com.ibm.jpos.util.BooleanMonitor;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import java.util.TooManyListenersException;
import jpos.JposException;
import jpos.MICRConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public abstract class Serial4610MICRServiceImp
extends Serial4610DeviceServiceImp
implements MICRServiceImp,
MICRConst {
    private EventCallbacks eventCallback = null;
    private JposException errorEventException = null;
    private MICRListener mickey = new MICRListener();
    private Serial4610Device serial4610Device = this.getSerial4610Device();
    private boolean insertMode = false;
    private boolean removeMode = false;
    private boolean exceptionTFound = false;
    private String transit = "";
    private int type = 99;
    private int spaces = 0;
    private char field = '\u0000';
    private char skip = '\u0000';
    private int size = 0;
    private int acc_rl = 0;
    private BooleanMonitor documentInserted = new BooleanMonitor(false);
    private BooleanMonitor documentRegistered = new BooleanMonitor(false);
    private MICRServiceState micrState = null;
    private DeviceServiceAbstraction serviceAbstraction = null;
    private BooleanMonitor micrEventAvailable = new BooleanMonitor(false);
    private Serial4610MICREvent micrEvent = null;
    private static final String className = "Serial4610MICRServiceImp";

    protected Serial4610MICRServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        this.serviceAbstraction = deviceServiceAbstraction;
        try {
            this.serial4610Device.addSerial4610PrnStatusChangeListener(this.mickey);
            this.serial4610Device.addSerial4610PrnDataAvailListener(this.mickey);
            this.serial4610Device.addSerial4610PrnPrinterErrorListener(this.mickey);
        }
        catch (TooManyListenersException tooManyListenersException) {
            Tracer.trace(1, className, "Serial4610MICRServiceImp()", "Internal error: TooManyListenersException");
        }
    }

    public void deleteImp() throws JposException {
        super.deleteImp();
        this.serial4610Device.removeSerial4610PrnDataAvailListener();
        this.serial4610Device.removeSerial4610PrnPrinterErrorListener();
        this.serial4610Device.removeSerial4610PrnStatusChangeListener();
    }

    public void setAutoDisable(boolean bl) throws JposException {
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
    }

    public void claim(int n) throws JposException {
        Tracer.trace(4, className, "claim(" + Integer.toString(n) + ")", "Entry");
        super.claim(n);
        Tracer.trace(4, className, "claim()", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        super.open(string, eventCallbacks);
        this.micrState = (MICRServiceState)this.getDeviceServiceState();
        this.eventCallback = eventCallbacks;
        if ((this.getSerial4610Device().getPrinterID()[2] & 1) == 0) {
            throw new JposException(108);
        }
        this.documentInserted = new BooleanMonitor(false);
        this.documentRegistered = new BooleanMonitor(false);
        this.processStatus(this.serial4610Device.getStatus());
        this.micrState.setState(2);
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
    }

    public void beginInsertion(int n) throws JposException {
        Tracer.trace(4, className, "beginInsertion(" + Integer.toString(n) + ")", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            if (this.micrState.getCoverOpen()) {
                throw new JposException(111);
            }
            this.serial4610Device.write(new byte[]{27, 102, 0, 0, 27, 99, 48, 4});
            this.insertMode = true;
            this.removeMode = false;
            this.documentInserted.waitForTrue(n);
            Tracer.trace(4, className, "beginInsertion", "Exit");
        }
    }

    public void beginRemoval(int n) throws JposException {
        Tracer.trace(4, className, "beginRemoval(" + Integer.toString(n) + ")", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            if (this.micrState.getCoverOpen()) {
                throw new JposException(111, "JPOS_E_FAILURE: Cover open");
            }
            if (this.documentInserted.is(true)) {
                this.serial4610Device.write(new byte[]{27, 99, 48, 4, 27, 105});
            }
            this.insertMode = false;
            this.removeMode = true;
            try {
                this.serial4610Device.write(new byte[]{27, 99, 48, 2});
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.documentInserted.waitForFalse(n);
            Tracer.trace(4, className, "beginRemoval", "Exit");
        }
    }

    public void clearInput() throws JposException {
    }

    public void endInsertion() throws JposException {
        Tracer.trace(4, className, "endInsertion()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            if (!this.insertMode) {
                throw new JposException(106);
            }
            this.insertMode = false;
            if ((this.serial4610Device.getStatus()[0] & 0x20) == 32) {
                try {
                    this.serial4610Device.write(new byte[]{27, 99, 48, 2});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new JposException(111, "JPOS_E_FAILURE: Ribbon cover open");
            }
            if (this.documentInserted.is(false)) {
                try {
                    this.serial4610Device.write(new byte[]{27, 99, 48, 2});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new JposException(114, 201);
            }
            this.micrEventAvailable.set(false);
            this.micrEvent = null;
            this.serial4610Device.write(new byte[]{27, 99, 48, 4, 27, 73});
            try {
                this.micrEventAvailable.waitFor(true, 10000);
                this.micrEvent.post();
            }
            catch (Exception exception) {
                if (this.documentInserted.is(false)) {
                    throw new JposException(114, 201);
                }
                if (!this.serial4610Device.isOnline()) {
                    throw new JposException(108);
                }
                throw new JposException(111);
            }
            Tracer.trace(4, className, "endInsertion", "Exit");
        }
    }

    public void endRemoval() throws JposException {
        Tracer.trace(4, className, "endRemoval()", "Entry");
        if (!this.removeMode) {
            throw new JposException(106);
        }
        this.removeMode = false;
        if (this.documentInserted.is(true)) {
            throw new JposException(114, 202);
        }
        Tracer.trace(4, className, "endRemoval()", "Exit");
    }

    private void processStatus(byte[] byArray) {
        if ((byArray[0] & 0x60) != 0) {
            this.micrState.setCoverOpen(true);
        } else {
            this.micrState.setCoverOpen(false);
        }
        if ((byArray[1] & 7) != 7) {
            this.documentInserted.set(true);
        } else {
            this.documentInserted.set(false);
        }
        if ((byArray[1] & 1) == 0) {
            this.documentRegistered.set(true);
        } else {
            this.documentRegistered.set(false);
        }
    }

    class Serial4610MICRErrorEvent
    implements Serial4610MICREvent {
        private static final String className = "Serial4610MICRServiceImp$Serial4610MICRErrorEvent";
        private MICRServiceState serviceState = null;
        private ErrorEvent errorEvent = null;
        private String rawData;

        public Serial4610MICRErrorEvent(MICRServiceState mICRServiceState, String string) {
            Tracer.trace(4, className, "ctor", "Entry");
            this.serviceState = mICRServiceState;
            this.rawData = string;
            this.errorEvent = new ValidatingErrorEvent(Serial4610MICRServiceImp.this.eventCallback.getEventSource(), 111, 0, 2, 12);
            Tracer.trace(4, className, "ctor", "Exit");
        }

        public void post() throws JposException {
            Serial4610MICRServiceImp.this.micrState.setState(4);
            Serial4610MICRServiceImp.this.getEventQueueManager().postEvent(this);
        }

        public void setErrorCode(int n, int n2) {
            int n3 = 2;
            int n4 = 12;
            this.errorEvent = new ErrorEvent((Object)Serial4610MICRServiceImp.this.eventCallback.getEventSource(), 111, 0, n3, n4);
        }

        public JposEvent getJposEvent() {
            return this.errorEvent;
        }

        public void doneFiring() {
        }

        public void prepareToFire() {
            try {
                this.serviceState.setRawData(this.rawData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private class ValidatingErrorEvent
        extends ErrorEvent {
            public ValidatingErrorEvent(Object object, int n, int n2, int n3, int n4) {
                super(object, n, n2, n3, n4);
            }

            public void setErrorResponse(int n) {
                switch (this.getErrorLocus()) {
                    case 2: {
                        switch (n) {
                            case 12: {
                                this.errorResponse = n;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (n) {
                            case 12: 
                            case 13: {
                                this.errorResponse = n;
                            }
                        }
                    }
                }
            }
        }
    }

    private class Serial4610MICRDataEvent
    implements Serial4610MICREvent,
    MICRConst {
        private DataEvent dataEvent = null;
        private MICRServiceState micrState = null;
        private String rawData = null;

        public Serial4610MICRDataEvent(MICRServiceState mICRServiceState, String string) {
            Tracer.trace(4, Serial4610MICRServiceImp.className, "Serial4610MICRDataEvent", "MICR Dataevent ctor raw=" + string);
            this.micrState = mICRServiceState;
            this.rawData = string;
            this.dataEvent = new DataEvent((Object)Serial4610MICRServiceImp.this.eventCallback.getEventSource(), 0);
        }

        public void post() throws JposException {
            if (this.micrState.getAutoDisable()) {
                this.micrState.setDeviceEnabled(false);
            }
            Serial4610MICRServiceImp.this.getEventQueueManager().postEvent(this);
        }

        public JposEvent getJposEvent() {
            return this.dataEvent;
        }

        public void doneFiring() {
        }

        public void prepareToFire() {
            block21: {
                Tracer.trace(4, Serial4610MICRServiceImp.className, "prepareToFire", "Entering prepareToFire");
                int n = 0;
                String string = new String("");
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = true;
                Tracer.trace(4, Serial4610MICRServiceImp.className, "prepareToFire", "Init properties " + this.rawData);
                try {
                    this.micrState.setAccountNumber("");
                    this.micrState.setAmount("");
                    this.micrState.setBankNumber("");
                    this.micrState.setEPC("");
                    this.micrState.setRawData("");
                    this.micrState.setSerialNumber("");
                    this.micrState.setTransitNumber("");
                    this.micrState.setBankNumber("");
                    try {
                        this.micrState.setCheckType(Serial4610MICRServiceImp.this.type);
                        this.micrState.setCountryCode(99);
                    }
                    catch (JposException jposException) {
                        // empty catch block
                    }
                    this.micrState.setRawData(this.rawData);
                    Tracer.trace(4, Serial4610MICRServiceImp.className, "prepareToFire", "Setting properties");
                    int n2 = 0;
                    while (n2 < this.rawData.length()) {
                        switch (this.rawData.charAt(n2)) {
                            case 't': {
                                if (!bl5) {
                                    bl5 = true;
                                    bl2 = false;
                                    this.micrState.setTransitNumber(string);
                                    break;
                                }
                                bl5 = false;
                                bl2 = true;
                                break;
                            }
                            case 'o': {
                                if (!bl5) {
                                    bl5 = true;
                                    bl3 = false;
                                    if (n > 0) {
                                        this.micrState.setSerialNumber(this.micrState.getAccountNumber());
                                        this.micrState.setAccountNumber(string);
                                    } else {
                                        this.micrState.setAccountNumber(string);
                                    }
                                    ++n;
                                    break;
                                }
                                bl3 = true;
                                bl5 = false;
                                break;
                            }
                            case 'a': {
                                if (!bl5) {
                                    bl5 = true;
                                    bl = false;
                                    this.micrState.setAmount(string);
                                    break;
                                }
                                bl = true;
                                bl5 = false;
                                break;
                            }
                            default: {
                                string = string + this.rawData.charAt(n2);
                                if (!bl5) {
                                    if (!bl4 || n != 0) break;
                                    if (string.length() <= 5 && string.length() > 2 && (this.rawData.charAt(n2 + 1) == ' ' || this.rawData.charAt(n2 + 1) == '-')) {
                                        this.micrState.setSerialNumber(string);
                                        bl4 = false;
                                        bl5 = true;
                                        break;
                                    }
                                    if (!bl4) break;
                                    break;
                                }
                                if (this.rawData.charAt(n2 + 1) == 't' && Character.isDigit(this.rawData.charAt(n2))) {
                                    bl5 = true;
                                    this.micrState.setEPC(string);
                                    bl4 = false;
                                    break;
                                }
                                if (this.rawData.charAt(n2) == ' ' || this.rawData.charAt(n2) == '-') {
                                    bl4 = false;
                                    bl5 = true;
                                    break;
                                }
                                bl4 = true;
                                bl5 = false;
                            }
                        }
                        if (bl5) {
                            string = "";
                        }
                        ++n2;
                    }
                    if (string.length() > 0) {
                        this.micrState.setSerialNumber(string);
                    }
                    this.readExceptionTable();
                    Tracer.trace(4, Serial4610MICRServiceImp.className, "prepareToFire", "Setting properties Successful");
                }
                catch (Exception exception) {
                    Tracer.trace(4, Serial4610MICRServiceImp.className, "prepareToFire", "Setting properties failed");
                    if (Tracer.getTraceLevel() <= 3) break block21;
                    exception.printStackTrace();
                }
            }
        }

        public void readExceptionTable() {
            String string = "";
            JposEntryInfo jposEntryInfo = Serial4610MICRServiceImp.this.getDeviceServiceState().getJposEntryInfo();
            int n = 0;
            while (true) {
                String string2 = "";
                String string3 = "exceptionTable" + n;
                String string4 = "";
                string2 = (String)jposEntryInfo.getPropertyValue(string3);
                if (string2 != null) {
                    string4 = string2.substring(1, 10);
                    if (string4.equals(this.micrState.getTransitNumber())) {
                        this.setExceptionTable(string2);
                        break;
                    }
                } else {
                    Serial4610MICRServiceImp.this.exceptionTFound = false;
                    break;
                }
                ++n;
            }
            try {
                if (Serial4610MICRServiceImp.this.exceptionTFound) {
                    String string5 = this.micrState.getAccountNumber();
                    if (Serial4610MICRServiceImp.this.spaces == 68) {
                        int n2 = 0;
                        while (n2 < string5.length()) {
                            if (string5.charAt(n2) != ' ') {
                                string = string + string5.charAt(n2);
                            }
                            ++n2;
                        }
                    }
                    this.micrState.setCheckType(Serial4610MICRServiceImp.this.type);
                    this.micrState.setAccountNumber(string5.substring(Character.getNumericValue(Serial4610MICRServiceImp.this.skip)));
                    this.micrState.setBankNumber(Serial4610MICRServiceImp.this.transit.substring(4, 8));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setExceptionTable(String string) {
            string.toUpperCase();
            try {
                Serial4610MICRServiceImp.this.type = string.charAt(0);
                Serial4610MICRServiceImp.this.transit = string.substring(1, 10);
                Serial4610MICRServiceImp.this.spaces = string.charAt(10);
                Serial4610MICRServiceImp.this.field = string.charAt(11);
                Serial4610MICRServiceImp.this.skip = string.charAt(12);
                Serial4610MICRServiceImp.this.size = string.charAt(13);
                Serial4610MICRServiceImp.this.acc_rl = string.charAt(14);
                if (Serial4610MICRServiceImp.this.acc_rl == 82 || Serial4610MICRServiceImp.this.acc_rl == 76) {
                    Serial4610MICRServiceImp.this.exceptionTFound = true;
                }
                if (Serial4610MICRServiceImp.this.type == 66) {
                    Serial4610MICRServiceImp.this.type = 2;
                    Serial4610MICRServiceImp.this.exceptionTFound = true;
                } else if (Serial4610MICRServiceImp.this.type == 80) {
                    Serial4610MICRServiceImp.this.type = 1;
                    Serial4610MICRServiceImp.this.exceptionTFound = true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private static interface Serial4610MICREvent
    extends JposEventContainer {
        public void post() throws JposException;
    }

    private class MICRListener
    implements Serial4610PrnDataAvailListener,
    Serial4610PrnStatusChangeListener,
    Serial4610PrnPrinterErrorListener {
        private MICRListener() {
        }

        public void serial4610PrnDataAvailOccurred(byte[] byArray, byte[] byArray2) {
            Tracer.trace(4, Serial4610MICRServiceImp.className, "serial4610PrnDataAvailOccurred()", "Entry");
            if (Serial4610MICRServiceImp.this.micrState.getDeviceEnabled()) {
                Tracer.trace(4, Serial4610MICRServiceImp.className, "serial4610PrnDataAvailOccurred()", "Device is enabled");
                if ((byArray[4] & 4) != 0) {
                    Tracer.trace(4, Serial4610MICRServiceImp.className, "serial4610PrnDataAvailOccurred()", "Data is from MICR");
                    try {
                        String string = byArray2.length > 0 ? new String(byArray2, 1, byArray2.length - 1, "ASCII").replace('T', 't').replace('A', 'o').replace('$', 'a') : "?";
                        Tracer.trace(4, Serial4610MICRServiceImp.className, "serial4610PrnDataAvailOccurred()", "data: \"" + string + "\"");
                        if (string.length() < 3 || string.indexOf("?") != -1) {
                            Serial4610MICRServiceImp.this.micrEvent = new Serial4610MICRErrorEvent(Serial4610MICRServiceImp.this.micrState, string);
                        } else {
                            Serial4610MICRServiceImp.this.micrEvent = new Serial4610MICRDataEvent(Serial4610MICRServiceImp.this.micrState, string);
                        }
                        Serial4610MICRServiceImp.this.micrEventAvailable.set(true);
                    }
                    catch (Exception exception) {
                        Tracer.trace(4, Serial4610MICRServiceImp.className, "serial4610PrnDataAvailOccurred()", "Unexpected error: " + exception.toString());
                    }
                } else {
                    Tracer.trace(4, Serial4610MICRServiceImp.className, "serial4610PrnDataAvailOccurred()", "Data is not from MICR");
                }
            }
            Tracer.trace(4, Serial4610MICRServiceImp.className, "serial4610PrnDataAvailOccurred()", "Exit");
        }

        public void serial4610PrnStatusChangeOccurred(byte[] byArray) {
            Serial4610MICRServiceImp.this.processStatus(byArray);
        }

        public void serial4610PrnPrinterErrorOccurred(byte[] byArray, int n) {
            Serial4610MICRServiceImp.this.processStatus(byArray);
            if (Serial4610MICRServiceImp.this.micrEventAvailable.is(false)) {
                Serial4610MICRServiceImp.this.micrEvent = new Serial4610MICRErrorEvent(Serial4610MICRServiceImp.this.micrState, " ");
                Serial4610MICRServiceImp.this.micrEventAvailable.set(true);
            }
        }
    }
}

