/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import jpos.JposException;

public class BooleanMonitor {
    private boolean[] trueMonitor;
    private boolean[] falseMonitor;
    private static final boolean debug = false;

    public BooleanMonitor() {
        this.trueMonitor = new boolean[]{false};
        this.falseMonitor = new boolean[]{true};
    }

    public BooleanMonitor(boolean bl) {
        this.trueMonitor = new boolean[]{bl};
        this.falseMonitor = new boolean[]{!bl};
    }

    public void forceTimeout() {
        boolean[] blArray = this.trueMonitor;
        synchronized (blArray) {
            boolean[] blArray2 = this.falseMonitor;
            synchronized (blArray2) {
                boolean bl = this.isTrue();
                this.set(true);
                this.set(false);
                this.set(bl);
            }
        }
    }

    public boolean is(boolean bl) {
        return bl ? this.trueMonitor[0] : this.falseMonitor[0];
    }

    public boolean is() {
        return this.trueMonitor[0];
    }

    public boolean get() {
        return this.trueMonitor[0];
    }

    public boolean isTrue() {
        return this.trueMonitor[0];
    }

    public boolean isFalse() {
        return this.falseMonitor[0];
    }

    public void waitForTrue(int n) throws JposException {
        this.dprintln("waiting for true, now " + (this.trueMonitor[0] ? "true" : "false"));
        this.waitForBoolean(true, n);
        this.dprintln("wait satisfied, now " + (this.trueMonitor[0] ? "true" : "false"));
    }

    public void waitForFalse(int n) throws JposException {
        this.dprintln("waiting for false, now " + (this.trueMonitor[0] ? "true" : "false"));
        this.waitForBoolean(false, n);
        this.dprintln("wait satisfied, now " + (this.trueMonitor[0] ? "true" : "false"));
    }

    public void waitFor(boolean bl, int n) throws JposException {
        this.waitForBoolean(bl, n);
    }

    public void waitFor(boolean bl) throws JposException {
        this.waitForBoolean(bl, -1);
    }

    public void waitForBoolean(boolean bl, int n) throws JposException {
        boolean[] blArray;
        boolean[] blArray2 = blArray = bl ? this.trueMonitor : this.falseMonitor;
        if (n < -1) {
            throw new JposException(106);
        }
        if (n == 0 && !blArray[0]) {
            throw new JposException(112);
        }
        boolean[] blArray3 = blArray;
        synchronized (blArray3) {
            if (n == -1) {
                while (!blArray[0]) {
                    try {
                        blArray.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.dprintln("wait interrupted, continuing");
                    }
                }
            } else {
                long l = System.currentTimeMillis();
                long l2 = l + (long)n;
                while (l < l2 && !blArray[0]) {
                    try {
                        blArray.wait(l2 - l);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        this.dprintln("wait interrupted, continuing");
                        l = System.currentTimeMillis();
                    }
                }
                this.dprintln("wait satisfied, now " + (this.trueMonitor[0] ? "true" : "false"));
                if (!blArray[0]) {
                    this.dprintln("timed out, throwing exception");
                    throw new JposException(112);
                }
            }
        }
    }

    public void set(boolean bl) {
        this.dprintln("setting " + (bl ? "true" : "false"));
        boolean[] blArray = this.trueMonitor;
        synchronized (blArray) {
            boolean[] blArray2 = this.falseMonitor;
            synchronized (blArray2) {
                this.trueMonitor[0] = bl;
                boolean bl2 = this.falseMonitor[0] = !bl;
                if (this.trueMonitor[0]) {
                    this.trueMonitor.notifyAll();
                } else {
                    this.falseMonitor.notifyAll();
                }
            }
            this.dprintln("set complete");
        }
    }

    private void dprintln(String string) {
    }
}

