/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.handlers.http;

import br.com.auttar.clientservices.handlers.HandlerConfiguration;
import br.com.auttar.clientservices.handlers.http.HttpCheckout;
import br.com.auttar.clientservices.handlers.http.HttpCheckoutTaxReceipt;
import br.com.auttar.clientservices.handlers.http.HttpPayment;
import br.com.auttar.clientservices.model.Checkout;
import br.com.auttar.clientservices.model.Payment;
import br.com.auttar.clientservices.model.SearchCheckout;
import br.com.auttar.clientservices.model.TaxReceiptRequest;
import br.com.auttar.clientservices.services.CheckoutListener;
import br.com.auttar.clientservices.services.PaymentListener;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.TaxReceiptListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HttpClient
implements CheckoutListener,
TaxReceiptListener,
PaymentListener {
    private HandlerConfiguration configuration;
    private ExecutorService executor;

    public HttpClient(HandlerConfiguration configuration) {
        this.configuration = configuration;
        this.executor = Executors.newCachedThreadPool();
    }

    @Override
    public void onGetTaxReceipt(SessionMessage sessionMessage, TaxReceiptRequest taxReceiptRequest) {
        HttpCheckoutTaxReceipt<TaxReceiptRequest> httpRequestHandler = new HttpCheckoutTaxReceipt<TaxReceiptRequest>(sessionMessage, taxReceiptRequest, this.configuration);
        this.executor.execute(httpRequestHandler);
    }

    @Override
    public void onTaxReceiptGenerate(SessionMessage sessionMessage, TaxReceiptRequest taxReceiptRequest) {
        HttpCheckoutTaxReceipt<TaxReceiptRequest> httpRequestHandler = new HttpCheckoutTaxReceipt<TaxReceiptRequest>(sessionMessage, taxReceiptRequest, this.configuration);
        this.executor.execute(httpRequestHandler);
    }

    @Override
    public void onGetCheckout(SessionMessage sessionMessage, SearchCheckout checkout) {
        HttpCheckout<SearchCheckout> httpRequestHandler = new HttpCheckout<SearchCheckout>(sessionMessage, checkout, this.configuration);
        this.executor.execute(httpRequestHandler);
    }

    @Override
    public void onPostStartPayment(SessionMessage sessionMessage, Checkout checkout) {
        HttpCheckout<Checkout> httpRequestHandler = new HttpCheckout<Checkout>(sessionMessage, checkout, this.configuration);
        this.executor.execute(httpRequestHandler);
    }

    @Override
    public void onPostCancelPayment(SessionMessage sessionMessage, Checkout checkout) {
        HttpCheckout<Checkout> httpRequestHandler = new HttpCheckout<Checkout>(sessionMessage, checkout, this.configuration);
        this.executor.execute(httpRequestHandler);
    }

    @Override
    public void onPayment(SessionMessage sessionMessage, Payment payment) {
        HttpPayment<Payment> httpRequestHandler = new HttpPayment<Payment>(sessionMessage, payment, this.configuration);
        this.executor.execute(httpRequestHandler);
    }
}

