/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.handlers.socket;

import br.com.auttar.clientservices.services.CheckoutListener;
import br.com.auttar.clientservices.services.MessageService;
import br.com.auttar.clientservices.services.PaymentListener;
import br.com.auttar.clientservices.services.TaxReceiptListener;
import br.com.auttar.framework.socket.MessageSocketHandler;
import br.com.auttar.framework.socket.MonitorSocketEvent;
import br.com.auttar.framework.socket.ServerSocket;
import br.com.auttar.framework.socket.SocketHandler;
import java.nio.channels.SocketChannel;

public class LocalServiceSocket
extends ServerSocket {
    private MessageService messageService;

    public <M extends MessageSocketHandler> LocalServiceSocket(String host, int porta, Class<M> messageSocketHandler) {
        super(host, porta, messageSocketHandler);
    }

    public <S extends SocketHandler, M extends MessageSocketHandler> LocalServiceSocket(String host, int porta, Class<M> messageSocketHandler, Class<S> socketHandler) {
        super(host, porta, messageSocketHandler, socketHandler);
    }

    public <S extends SocketHandler, M extends MessageSocketHandler> LocalServiceSocket(String host, int porta, Class<M> messageSocketHandler, Class<S> socketHandler, MessageService messageService) {
        super(host, porta, messageSocketHandler, socketHandler);
        this.messageService = messageService;
    }

    @Override
    protected SocketHandler createSocketHandler(SocketChannel socketChannel) throws IllegalArgumentException {
        Object listener;
        SocketHandler socketHandler = super.createSocketHandler(socketChannel);
        if (socketHandler instanceof CheckoutListener) {
            listener = (CheckoutListener)((Object)socketHandler);
            this.messageService.addCheckoutListener((CheckoutListener)listener);
        }
        if (socketHandler instanceof TaxReceiptListener) {
            listener = (TaxReceiptListener)((Object)socketHandler);
            this.messageService.addTaxReceiptListener((TaxReceiptListener)listener);
        }
        if (socketHandler instanceof PaymentListener) {
            listener = (PaymentListener)((Object)socketHandler);
            this.messageService.addPaymentListener((PaymentListener)listener);
        }
        return socketHandler;
    }

    @Override
    public void OnClose(MonitorSocketEvent event) {
        Object listener;
        super.OnClose(event);
        SocketHandler socketHandler = event.getOrigem();
        if (socketHandler instanceof CheckoutListener) {
            listener = (CheckoutListener)((Object)socketHandler);
            this.messageService.removeCheckoutListener((CheckoutListener)listener);
        }
        if (socketHandler instanceof TaxReceiptListener) {
            listener = (TaxReceiptListener)((Object)socketHandler);
            this.messageService.removeTaxReceiptListener((TaxReceiptListener)listener);
        }
        if (socketHandler instanceof PaymentListener) {
            listener = (PaymentListener)((Object)socketHandler);
            this.messageService.removePaymentListener((PaymentListener)listener);
        }
    }
}

