/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.EventProcessing;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.InputDeviceService;
import com.ibm.jpos.services.InputDeviceServiceState;
import com.ibm.jpos.services.OutputDeviceService;
import com.ibm.jpos.services.ServiceRegistry;
import com.ibm.jpos.util.Timer;
import com.ibm.jpos.util.Timerable;
import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;

public abstract class DeviceService
implements BaseService,
DeviceServiceAbstraction {
    private DeviceServiceState deviceServiceState = null;
    private EventQueueManager eventQueueManager = null;
    private EventCallbacks eventCallbacks = null;
    protected DeviceServiceImp deviceServiceImp = null;
    private boolean timerExpired = false;
    public Tracer tracer = TracerFactory.getInstance().createTracer("System", "DeviceService");
    private static long timestmp = -1L;
    public static final int MAXIMUM_TRACE_STRING = 250;
    public static final int CLAIM_POLLING_TIMEOUT = 200;
    public static final String DEFAULT_DEVICESERVICE_DEVCAT = "com.ibm.jpos.services.DeviceService";

    public DeviceService(DeviceServiceImp imp) {
        this.deviceServiceImp = imp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapServiceAllowManagement() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapServiceAllowManagement," + state.getCapServiceAllowManagement());
            }
            return state.getCapServiceAllowManagement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapUpdateStatistics() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapUpdateStatistics," + state.getCapUpdateStatistics());
            }
            return state.getCapUpdateStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapUpdateFirmware() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapUpdateFirmware," + state.getCapUpdateFirmware());
            }
            return state.getCapUpdateFirmware();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapStatisticsReporting() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapStatisticsReporting," + state.getCapStatisticsReporting());
            }
            return state.getCapStatisticsReporting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapCompareFirmwareVersion() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapCompareFirmwareVersion," + state.getCapCompareFirmwareVersion());
            }
            return state.getCapCompareFirmwareVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapPowerReporting() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapPowerReporting," + state.getCapPowerReporting());
            }
            return state.getCapPowerReporting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerNotify() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getPowerNotify," + state.getPowerNotify());
            }
            return state.getPowerNotify();
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "setPowerNotify," + powerNotify);
        }
        DeviceServiceState state = this.getDeviceServiceState();
        state.isOpen();
        if (state.getDeviceEnabled()) {
            throw new JposException(106);
        }
        if (state.getCapPowerReporting() == 0) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().setPowerNotify(powerNotify);
        state.setPowerNotify(powerNotify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerState() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getPowerState," + state.getPowerState());
            }
            return state.getPowerState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCheckHealthText() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCheckHealthText," + state.getCheckHealthText());
            }
            return state.getCheckHealthText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getClaimed() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getClaimed," + state.getClaimed());
            }
            return state.getClaimed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDeviceEnabled() throws JposException {
        DeviceServiceState state;
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->getDeviceEnabled");
        }
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--getDeviceEnabled," + state.getDeviceEnabled());
            }
            return state.getDeviceEnabled();
        }
    }

    public synchronized void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->setDeviceEnabled," + deviceEnabled);
        }
        this.getDeviceServiceState().isOpenClaim();
        DeviceServiceState state = this.getDeviceServiceState();
        if (deviceEnabled) {
            this.checkOnline();
        }
        this.getDeviceServiceImp().setDeviceEnabled(deviceEnabled);
        this.getDeviceServiceState().setDeviceEnabled(deviceEnabled);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--setDeviceEnabled," + deviceEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceServiceDescription() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getDeviceServiceDescription," + state.getDeviceServiceDescription());
            }
            return state.getDeviceServiceDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeviceServiceVersion() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getDeviceServiceVersion," + state.getDeviceServiceVersion());
            }
            return state.getDeviceServiceVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFreezeEvents() throws JposException {
        DeviceServiceState state;
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->getFreezeEvents");
        }
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--getFreezeEvents," + state.getFreezeEvents());
            }
            return state.getFreezeEvents();
        }
    }

    public synchronized void setFreezeEvents(boolean freezeEvents) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->setFreezeEvents," + freezeEvents);
        }
        DeviceServiceState state = this.getDeviceServiceState();
        state.isOpen();
        if (state.getFreezeEvents() == freezeEvents) {
            return;
        }
        this.getDeviceServiceImp().setFreezeEvents(freezeEvents);
        this.getEventQueueManager().setFreezeEvents(freezeEvents);
        state.setFreezeEvents(freezeEvents);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--setFreezeEvents," + freezeEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalDeviceDescription() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getPhysicalDeviceDescription," + state.getPhysicalDeviceDescription());
            }
            return state.getPhysicalDeviceDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalDeviceName() throws JposException {
        DeviceServiceState state;
        DeviceServiceState deviceServiceState = state = this.getDeviceServiceState();
        synchronized (deviceServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getPhysicalDeviceName," + state.getPhysicalDeviceName());
            }
            return state.getPhysicalDeviceName();
        }
    }

    public int getState() throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getState," + this.getDeviceServiceState().getState());
        }
        return this.getDeviceServiceState().getState();
    }

    public synchronized void claim(int timeout) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->claim," + timeout);
        }
        DeviceServiceState state = this.getDeviceServiceState();
        state.isOpen();
        this.checkTimeoutArg(timeout);
        this.checkOnline();
        if (state.getClaimed()) {
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--claim," + timeout);
            }
            return;
        }
        Throwable exception = null;
        if (this.getClaimedService() == null) {
            try {
                this.getDeviceServiceImp().claim(timeout);
                state.setClaimed(true);
                if (this.tracer.isOn()) {
                    this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--claim," + timeout);
                }
                return;
            }
            catch (JposException jE) {
                if (jE.getErrorCode() == 108) {
                    throw jE;
                }
                exception = jE;
            }
        }
        if (timeout == 0) {
            throw new JposException(112, String.valueOf(112), (Exception)exception);
        }
        if (timeout == -1) {
            while (true) {
                try {
                    this.getDeviceServiceImp().claim(timeout);
                    state.setClaimed(true);
                }
                catch (JposException jE) {
                    if (jE.getErrorCode() == 108) {
                        throw jE;
                    }
                    exception = jE;
                }
                catch (Exception e) {
                    exception = e;
                }
                if (state.getClaimed()) {
                    if (this.tracer.isOn()) {
                        this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--claim," + timeout);
                    }
                    return;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.getClaimPollingWait());
                }
                catch (InterruptedException e) {}
            }
        }
        this.timerExpired = false;
        Timer timer = new Timer(new Timerable(){

            public void timerExpired() {
                DeviceService.this.timerExpired = true;
            }
        });
        timer.setTime(timeout);
        timer.start();
        while (!this.timerExpired) {
            try {
                this.getDeviceServiceImp().claim(timeout);
                state.setClaimed(true);
            }
            catch (JposException jE) {
                if (jE.getErrorCode() == 108) {
                    throw jE;
                }
                exception = jE;
            }
            catch (Exception e) {
                exception = e;
            }
            if (state.getClaimed()) {
                if (this.tracer.isOn()) {
                    this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--claim," + timeout);
                }
                return;
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.getClaimPollingWait());
            }
            catch (InterruptedException e) {}
        }
        if (this.timerExpired && !state.getClaimed()) {
            throw new JposException(112, String.valueOf(112), (Exception)exception);
        }
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--claim," + timeout);
        }
    }

    public synchronized void open(String logicalName, EventCallbacks cb) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->open," + logicalName);
            this.tracer.println(3, (Object)this.getDeviceServiceState().getJposEntryInfo().getJposEntry());
        }
        this.getDeviceServiceState().setDeviceService(this);
        this.getDeviceServiceState().initProperties();
        this.eventCallbacks = cb;
        this.eventQueueManager = new EventQueueManager(cb, this.newEventProcessing(), this.getinstanceID());
        if (this instanceof InputDeviceService) {
            this.eventQueueManager.setDataEventEnabled(((InputDeviceServiceState)((Object)this.getDeviceServiceState())).getDataEventEnabled());
        } else if (this instanceof OutputDeviceService) {
            this.eventQueueManager.setDataEventEnabled(true);
        }
        this.getDeviceServiceImp().open(logicalName, cb);
        this.getDeviceServiceState().setState(2);
        ServiceRegistry.getInstance().addDeviceService(this.getDeviceServiceState().getServiceKey(), this);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--open," + logicalName);
        }
    }

    public synchronized void close() throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->close");
        }
        DeviceServiceState state = this.getDeviceServiceState();
        state.isOpen();
        if (this.getClaimed()) {
            if (this.getDeviceEnabled()) {
                this.setDeviceEnabled(false);
            }
            this.release();
        }
        this.getDeviceServiceImp().close();
        this.eventCallbacks = null;
        this.eventQueueManager.terminate();
        this.eventQueueManager = null;
        state.setState(1);
        ServiceRegistry.getInstance().removeDeviceService(state.getServiceKey(), this);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--close");
        }
    }

    public synchronized void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->compareFirmwareVersion");
        }
        this.getDeviceServiceState().isOpenClaimEnable();
        if (!this.getDeviceServiceState().getCapCompareFirmwareVersion()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().compareFirmwareVersion(firmwareFileName, result);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--compareFirmwareVersion");
        }
    }

    public synchronized void checkHealth(int level) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->checkHealth," + level);
        }
        this.getDeviceServiceState().isOpenClaimEnable();
        this.checkCheckHealthArg(level);
        this.getDeviceServiceImp().checkHealth(level);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--checkHealth," + level);
        }
    }

    public synchronized void directIO(int command, int[] data, Object object) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->directIO");
            if (data != null) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "directIO," + command + "," + Util.toFormatedHexString((int[])data) + "," + object);
            } else {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "directIO," + command + "," + data + "," + object);
            }
        }
        this.getDeviceServiceState().isOpen();
        this.getDeviceServiceImp().directIO(command, data, object);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--directIO");
        }
    }

    public abstract void release() throws JposException;

    public synchronized void resetStatistics(String statisticsBuffer) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->resetStatistics");
        }
        if (!this.getDeviceServiceState().getCapStatisticsReporting() || !this.getDeviceServiceState().getCapUpdateStatistics()) {
            throw new JposException(106);
        }
        this.getDeviceServiceState().isOpenClaimEnable();
        this.getDeviceServiceImp().resetStatistics(statisticsBuffer);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--resetStatistics");
        }
    }

    public synchronized void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->retrieveStatistics," + Util.toString((String[])statisticsBuffer));
        }
        this.checkStatisticArg(statisticsBuffer);
        if (!this.getDeviceServiceState().getCapStatisticsReporting()) {
            throw new JposException(106);
        }
        this.getDeviceServiceState().isOpenClaimEnable();
        this.getDeviceServiceImp().retrieveStatistics(statisticsBuffer);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--retrieveStatistics," + Util.toString((String[])statisticsBuffer));
        }
    }

    public synchronized void updateFirmware(String firmwareFileName) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->updateFirmware");
        }
        this.getDeviceServiceState().isOpenClaimEnable();
        if (!this.getDeviceServiceState().getCapUpdateFirmware()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().updateFirmware(firmwareFileName);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--updateFirmware");
        }
    }

    public synchronized void updateStatistics(String statisticsBuffer) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->updateStatistics");
        }
        if (!this.getDeviceServiceState().getCapStatisticsReporting() || !this.getDeviceServiceState().getCapUpdateStatistics()) {
            throw new JposException(106);
        }
        this.getDeviceServiceState().isOpenClaimEnable();
        this.getDeviceServiceImp().updateStatistics(statisticsBuffer);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--updateStatistics");
        }
    }

    protected boolean isOnline() {
        return this.getDeviceServiceImp() == null ? false : this.getDeviceServiceImp().isOnline();
    }

    protected void checkOnline() throws JposException {
        if (!this.isOnline()) {
            throw new JposException(108);
        }
    }

    protected synchronized void releaseSharable() throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->releaseSharable");
        }
        DeviceServiceState state = this.getDeviceServiceState();
        state.isOpen();
        if (!state.getClaimed()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().release();
        state.setClaimed(false);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--releaseSharable");
        }
    }

    protected synchronized void releaseExclusive() throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->releaseExclusive");
        }
        DeviceServiceState state = this.getDeviceServiceState();
        state.isOpen();
        if (!state.getClaimed()) {
            throw new JposException(106);
        }
        if (this.getDeviceEnabled()) {
            this.setDeviceEnabled(false);
        }
        this.getDeviceServiceImp().release();
        state.setClaimed(false);
        this.getEventQueueManager().removeAllEvents();
        if (state.getState() == 4) {
            state.setState(2);
        }
        if (this instanceof InputDeviceService) {
            ((InputDeviceServiceState)((Object)state)).setDataCount(0);
        }
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--releaseExclusive");
        }
    }

    public String getDeviceCategory() {
        return DEFAULT_DEVICESERVICE_DEVCAT;
    }

    synchronized DeviceServiceImp getDeviceServiceImp() {
        return this.deviceServiceImp;
    }

    protected synchronized void setDeviceServiceImp(DeviceServiceImp imp) {
        this.deviceServiceImp = imp;
    }

    public DeviceServiceState getDeviceServiceState() {
        return this.deviceServiceState;
    }

    protected synchronized void setDeviceServiceState(DeviceServiceState state) {
        this.deviceServiceState = state;
    }

    protected EventProcessing newEventProcessing() {
        return new DefaultEventProcessing();
    }

    public EventQueueManager getEventQueueManager() throws JposException {
        if (this.eventQueueManager == null) {
            throw new JposException(101);
        }
        return this.eventQueueManager;
    }

    public Object getEventSource() throws JposException {
        if (this.eventCallbacks == null) {
            throw new JposException(101);
        }
        return this.eventCallbacks.getEventSource();
    }

    protected void checkZeroArg(int i) throws JposException {
        if (i == 0) {
            throw new JposException(106);
        }
    }

    protected void checkNullArg(Object o) throws JposException {
        if (o == null) {
            throw new JposException(106);
        }
    }

    protected void checkNegativeArg(int i) throws JposException {
        if (i < 0) {
            throw new JposException(106);
        }
    }

    protected void checkTimeoutArg(int i) throws JposException {
        if (i < -1) {
            throw new JposException(106);
        }
    }

    protected void checkIntArrayArg(int[] intArray) throws JposException {
        if (intArray == null || intArray.length < 1) {
            throw new JposException(106);
        }
    }

    protected void checkStatisticArg(String[] statisticsBuffer) throws JposException {
        this.checkNullArg(statisticsBuffer);
        if (statisticsBuffer.length != 1) {
            throw new JposException(106);
        }
        if (statisticsBuffer[0] == null) {
            throw new JposException(106);
        }
    }

    protected void checkCheckHealthArg(int level) throws JposException {
        switch (level) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    protected void checkClaimedService() throws JposException {
        DeviceServiceState state = this.getDeviceServiceState();
        DeviceService claimedService = ServiceRegistry.getInstance().getClaimedService(state.getServiceKey());
        if (claimedService != null && claimedService != this) {
            throw new JposException(102);
        }
    }

    protected DeviceService getClaimedService() {
        DeviceServiceState state = this.getDeviceServiceState();
        return ServiceRegistry.getInstance().getClaimedService(state.getServiceKey());
    }

    protected int getClaimPollingWait() {
        return 200;
    }

    public synchronized void deleteInstance() throws JposException {
        this.getDeviceServiceImp().deleteImp();
        this.getDeviceServiceState().setZombified(true);
    }

    protected void preEventProcessing(ErrorEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postEventProcessing(ErrorEvent event) {
        block14: {
            try {
                DeviceServiceState deviceServiceState;
                DeviceServiceState state = this.getDeviceServiceState();
                if (event.getErrorLocus() == 2) {
                    deviceServiceState = state;
                    synchronized (deviceServiceState) {
                        state.setState(2);
                    }
                }
                if (event.getErrorResponse() == 12) {
                    this.getEventQueueManager().removeAllErrorEvent();
                    if (this instanceof InputDeviceService) {
                        this.getEventQueueManager().removeAllDataEvent();
                        ((InputDeviceServiceState)((Object)state)).setDataCount(0);
                    }
                    deviceServiceState = state;
                    synchronized (deviceServiceState) {
                        state.setState(2);
                        break block14;
                    }
                }
                if (event.getErrorResponse() != 13) break block14;
                deviceServiceState = state;
                synchronized (deviceServiceState) {
                    state.setState(4);
                }
            }
            catch (JposException e) {
                if (!this.tracer.isOn()) break block14;
                this.tracer.print((Exception)((Object)e));
            }
        }
    }

    protected synchronized void preEventProcessing(DataEvent event) {
        block4: {
            if (this instanceof InputDeviceService) {
                try {
                    InputDeviceServiceState state = (InputDeviceServiceState)((Object)this.getDeviceServiceState());
                    ((InputDeviceService)((Object)this)).setDataEventEnabled(false);
                    if (state.getDataCount() > 0) {
                        state.setDataCount(state.getDataCount() - 1);
                    }
                }
                catch (JposException e) {
                    if (!this.tracer.isOn()) break block4;
                    this.tracer.print((Exception)((Object)e));
                }
            }
        }
    }

    protected synchronized void postEventProcessing(DataEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newDataEventPosted() {
        if (this instanceof InputDeviceService) {
            InputDeviceServiceState state;
            InputDeviceServiceState inputDeviceServiceState = state = (InputDeviceServiceState)((Object)this.getDeviceServiceState());
            synchronized (inputDeviceServiceState) {
                block6: {
                    try {
                        state.setDataCount(state.getDataCount() + 1);
                    }
                    catch (JposException e) {
                        if (!this.tracer.isOn()) break block6;
                        this.tracer.print((Exception)((Object)e));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newErrorEventPosted(ErrorEvent event) {
        block6: {
            DeviceServiceState deviceState = null;
            try {
                DeviceServiceState deviceServiceState = deviceState = this.getDeviceServiceState();
                synchronized (deviceServiceState) {
                    deviceState.setState(4);
                }
                if (event.getErrorLocus() == 2 && this.getEventQueueManager().isEnqueuedDataEvent()) {
                    ErrorEvent errorEvent = new ErrorEvent(event.getSource(), event.getErrorCode(), event.getErrorCodeExtended(), 3, 13);
                    this.getEventQueueManager().enqueueInFront((JposEvent)errorEvent);
                }
            }
            catch (JposException e) {
                if (!this.tracer.isOn()) break block6;
                this.tracer.print((Exception)((Object)e));
            }
        }
    }

    public void enhTrace(String servicesClass, String instanceID, long timeStamp, String method_args) {
        if (method_args.length() > 250) {
            method_args = method_args.substring(0, 250);
        }
        try {
            if (method_args.length() > 1 && method_args.indexOf(44) == -1) {
                this.tracer.println(1, servicesClass + "," + instanceID + "," + method_args + "()");
            } else if (method_args.length() > 1 && method_args.indexOf(44) > -1) {
                this.tracer.println(1, servicesClass + "," + instanceID + "," + method_args.substring(0, method_args.indexOf(44)) + "(" + method_args.substring(method_args.indexOf(44) + 1, method_args.length()) + ")");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public long gettimeStamp() {
        return System.currentTimeMillis();
    }

    public static long getFsttmStamp() {
        if (timestmp == -1L) {
            timestmp = System.currentTimeMillis();
        }
        return timestmp;
    }

    public String getinstanceID() {
        return this.toString().substring(this.toString().indexOf("@"), this.toString().length());
    }

    protected class DefaultEventProcessing
    implements EventProcessing {
        protected DefaultEventProcessing() {
        }

        public void preEventProcessing(ErrorEvent e) {
            DeviceService.this.preEventProcessing(e);
        }

        public void postEventProcessing(ErrorEvent e) {
            DeviceService.this.postEventProcessing(e);
        }

        public void preEventProcessing(DataEvent e) {
            DeviceService.this.preEventProcessing(e);
        }

        public void postEventProcessing(DataEvent e) {
            DeviceService.this.postEventProcessing(e);
        }

        public void newDataEventPosted() {
            DeviceService.this.newDataEventPosted();
        }

        public void newErrorEventPosted(ErrorEvent e) {
            DeviceService.this.newErrorEventPosted(e);
        }
    }
}

