/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.HardTotalsServiceImp;
import com.ibm.jpos.services.HardTotalsServiceState;
import com.ibm.jpos.util.Timer;
import com.ibm.jpos.util.Timerable;
import jpos.JposException;
import jpos.services.HardTotalsService19;

public abstract class HardTotalsService
extends DeviceService
implements HardTotalsService19 {
    private boolean timerExpired = false;
    public static final String HARDTOTALS_DEVCAT = "com.ibm.jpos.services.HardTotalsService";

    public HardTotalsService(HardTotalsServiceImp imp) {
        super(imp);
        this.setDeviceServiceState(new HardTotalsServiceState());
    }

    public synchronized void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->setDeviceEnabled," + deviceEnabled);
        }
        this.getDeviceServiceState().isOpen();
        this.getDeviceServiceImp().setDeviceEnabled(deviceEnabled);
        this.getDeviceServiceState().setDeviceEnabled(deviceEnabled);
        HardTotalsServiceState htState = this.getHardTotalsServiceState();
        if (deviceEnabled && htState.getTotalsSize() <= 0) {
            HardTotalsServiceImp imp = (HardTotalsServiceImp)this.getDeviceServiceImp();
            imp.setTotalsSize();
            imp.getPersistentFile();
        }
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--setDeviceEnabled," + deviceEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapErrorDetection() throws JposException {
        HardTotalsServiceState state;
        HardTotalsServiceState hardTotalsServiceState = state = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapErrorDetection" + state.getCapErrorDetection());
            }
            return state.getCapErrorDetection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapSingleFile() throws JposException {
        HardTotalsServiceState state;
        HardTotalsServiceState hardTotalsServiceState = state = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapSingleFile" + state.getCapSingleFile());
            }
            return state.getCapSingleFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapTransactions() throws JposException {
        HardTotalsServiceState state;
        HardTotalsServiceState hardTotalsServiceState = state = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapTransactions" + state.getCapTransactions());
            }
            return state.getCapTransactions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeData() throws JposException {
        HardTotalsServiceState state;
        HardTotalsServiceState hardTotalsServiceState = state = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState) {
            state.isOpenEnable();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getFreeData" + state.getFreeData());
            }
            return state.getFreeData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfFiles() throws JposException {
        HardTotalsServiceState state;
        HardTotalsServiceState hardTotalsServiceState = state = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState) {
            state.isOpenEnable();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getNumberOfFiles" + state.getNumberOfFiles());
            }
            return state.getNumberOfFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalsSize() throws JposException {
        HardTotalsServiceState state;
        HardTotalsServiceImp imp = this.getHardTotalsServiceImp();
        HardTotalsServiceState hardTotalsServiceState = state = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState) {
            state.isOpenEnable();
            int ret = state.getTotalsSize();
            if (ret == -1) {
                imp.setTotalsSize();
                ret = state.getTotalsSize();
                state.setFreeData(ret);
            }
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getTotalsSize" + ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTransactionInProgress() throws JposException {
        HardTotalsServiceState state;
        HardTotalsServiceState hardTotalsServiceState = state = this.getHardTotalsServiceState();
        synchronized (hardTotalsServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getTransactionInProgress" + state.getTransactionInProgress());
            }
            return state.getTransactionInProgress();
        }
    }

    public synchronized void release() throws JposException {
        super.releaseSharable();
    }

    public synchronized void beginTrans() throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "beginTrans");
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        state.isOpenEnable();
        this.getHardTotalsServiceImp().beginTrans();
    }

    public synchronized void checkHealth(int level) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->checkHealth," + level);
        }
        this.getDeviceServiceState().isOpenEnable();
        this.checkClaimedService();
        this.checkCheckHealthArg(level);
        this.getDeviceServiceImp().checkHealth(level);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--checkHealth," + level);
        }
    }

    public synchronized void claimFile(int hTotalsFile, int timeout) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "claimFile," + hTotalsFile + "," + timeout);
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        this.checkNegativeArg(hTotalsFile);
        this.checkTimeoutArg(timeout);
        state.isOpenEnable();
        Throwable exception = null;
        if (timeout == -1) {
            while (true) {
                try {
                    this.getHardTotalsServiceImp().claimFile(hTotalsFile, timeout);
                    return;
                }
                catch (JposException jE) {
                    if (jE.getErrorCode() == 108) {
                        throw jE;
                    }
                    exception = jE;
                }
                catch (Exception e) {
                    exception = e;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.getClaimPollingWait());
                }
                catch (InterruptedException e) {}
            }
        }
        this.timerExpired = false;
        Timer timer = new Timer(new Timerable(){

            public void timerExpired() {
                HardTotalsService.this.timerExpired = true;
            }
        });
        timer.setTime(timeout);
        timer.start();
        do {
            try {
                this.getHardTotalsServiceImp().claimFile(hTotalsFile, timeout);
                return;
            }
            catch (JposException jE) {
                if (jE.getErrorCode() == 108) {
                    throw jE;
                }
                exception = jE;
            }
            catch (Exception e) {
                exception = e;
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.getClaimPollingWait());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (!this.timerExpired);
        if (this.timerExpired) {
            throw new JposException(112, String.valueOf(112), (Exception)exception);
        }
    }

    public synchronized void commitTrans() throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "commitTrans");
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        state.isOpenEnable();
        this.getHardTotalsServiceImp().commitTrans();
    }

    public synchronized void create(String fileName, int[] hTotalsFile, int size, boolean errorDetection) throws JposException {
        HardTotalsServiceState state;
        block3: {
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "create," + fileName + "," + size + "," + errorDetection);
            }
            state = this.getHardTotalsServiceState();
            this.checkNullArg(fileName);
            this.checkNullArg(hTotalsFile);
            this.checkNegativeArg(size);
            state.isOpen();
            try {
                state.isClaim();
            }
            catch (JposException e) {
                if (e.getErrorCode() != 102) break block3;
                throw e;
            }
        }
        state.isEnable();
        this.checkClaimedService();
        this.checkName(fileName);
        this.checkOnline();
        this.getHardTotalsServiceImp().create(fileName, hTotalsFile, size, errorDetection);
    }

    public synchronized void delete(String fileName) throws JposException {
        HardTotalsServiceState state;
        block4: {
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "delete," + fileName);
            }
            state = this.getHardTotalsServiceState();
            this.checkNullArg(fileName);
            state.isOpen();
            try {
                state.isClaim();
            }
            catch (JposException e) {
                if (e.getErrorCode() != 102) break block4;
                throw e;
            }
        }
        state.isEnable();
        this.checkClaimedService();
        this.checkName(fileName);
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(-1, fileName)) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().delete(fileName);
    }

    public synchronized void find(String fileName, int[] hTotalsFile, int[] size) throws JposException {
        HardTotalsServiceState state;
        block3: {
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "find," + fileName);
            }
            state = this.getHardTotalsServiceState();
            this.checkNullArg(fileName);
            this.checkNullArg(hTotalsFile);
            this.checkNullArg(size);
            state.isOpen();
            try {
                state.isClaim();
            }
            catch (JposException e) {
                if (e.getErrorCode() != 102) break block3;
                throw e;
            }
        }
        state.isEnable();
        this.checkClaimedService();
        this.checkName(fileName);
        this.getHardTotalsServiceImp().find(fileName, hTotalsFile, size);
    }

    public synchronized void findByIndex(int index, String[] fileName) throws JposException {
        HardTotalsServiceState state;
        block3: {
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "findByIndex," + index);
            }
            state = this.getHardTotalsServiceState();
            this.checkNegativeArg(index);
            this.checkNullArg(fileName);
            state.isOpen();
            try {
                state.isClaim();
            }
            catch (JposException e) {
                if (e.getErrorCode() != 102) break block3;
                throw e;
            }
        }
        state.isEnable();
        this.checkClaimedService();
        this.getHardTotalsServiceImp().findByIndex(index, fileName);
    }

    public synchronized void read(int hTotalsFile, byte[] data, int offset, int count) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "read," + hTotalsFile + "," + offset + "," + count);
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        this.checkNegativeArg(hTotalsFile);
        this.checkNullArg(data);
        this.checkNegativeArg(offset);
        this.checkNegativeArg(count);
        this.checkOutOfBounds(data, count);
        state.isOpenEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(hTotalsFile, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().read(hTotalsFile, data, offset, count);
    }

    public synchronized void recalculateValidationData(int hTotalsFile) throws JposException {
        HardTotalsServiceState state;
        block4: {
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "recalculateValidationData," + hTotalsFile);
            }
            state = this.getHardTotalsServiceState();
            this.checkNegativeArg(hTotalsFile);
            state.isOpen();
            try {
                state.isClaim();
            }
            catch (JposException e) {
                if (e.getErrorCode() != 102) break block4;
                throw e;
            }
        }
        state.isEnable();
        this.checkClaimedService();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(hTotalsFile, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().recalculateValidationData(hTotalsFile);
    }

    public synchronized void releaseFile(int hTotalsFile) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "releaseFile," + hTotalsFile);
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        this.checkNegativeArg(hTotalsFile);
        state.isOpenEnable();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(hTotalsFile, "")) {
            throw new JposException(106);
        }
        this.getHardTotalsServiceImp().releaseFile(hTotalsFile);
    }

    public synchronized void rename(int hTotalsFile, String fileName) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "rename," + hTotalsFile + "," + fileName);
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        this.checkNegativeArg(hTotalsFile);
        this.checkNullArg(fileName);
        state.isOpenEnable();
        this.checkClaimedService();
        this.checkName(fileName);
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(hTotalsFile, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().rename(hTotalsFile, fileName);
    }

    public synchronized void rollback() throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "rollback");
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        state.isOpenEnable();
        this.getHardTotalsServiceImp().rollback();
    }

    public synchronized void setAll(int hTotalsFile, byte value) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "setAll," + hTotalsFile + "," + value);
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        this.checkNegativeArg(hTotalsFile);
        state.isOpenEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(hTotalsFile, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().setAll(hTotalsFile, value);
    }

    public synchronized void validateData(int hTotalsFile) throws JposException {
        HardTotalsServiceState state;
        block4: {
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "validateData," + hTotalsFile);
            }
            state = this.getHardTotalsServiceState();
            this.checkNegativeArg(hTotalsFile);
            state.isOpen();
            try {
                state.isClaim();
            }
            catch (JposException e) {
                if (e.getErrorCode() != 102) break block4;
                throw e;
            }
        }
        state.isEnable();
        this.checkClaimedService();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(hTotalsFile, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().validateData(hTotalsFile);
    }

    public synchronized void write(int hTotalsFile, byte[] data, int offset, int count) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "write," + hTotalsFile + "," + offset + "," + count);
        }
        HardTotalsServiceState state = this.getHardTotalsServiceState();
        this.checkNegativeArg(hTotalsFile);
        this.checkNullArg(data);
        this.checkNegativeArg(offset);
        this.checkNegativeArg(count);
        state.isOpenEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (this.getHardTotalsServiceImp().fileClaimedByOther(hTotalsFile, "")) {
            throw new JposException(102);
        }
        this.getHardTotalsServiceImp().write(hTotalsFile, data, offset, count);
    }

    private void checkName(String name) throws JposException {
        if (!name.equals("") && name.length() > 10) {
            throw new JposException(106);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) >= ' ' && name.charAt(i) <= '\u007f') continue;
            throw new JposException(106);
        }
    }

    private void checkOutOfBounds(byte[] data, int count) throws JposException {
        if (data.length < count) {
            throw new JposException(106);
        }
    }

    public synchronized void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->compareFirmwareVersion");
        }
        this.getDeviceServiceState().isOpenClaimEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (!this.getDeviceServiceState().getCapCompareFirmwareVersion()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().compareFirmwareVersion(firmwareFileName, result);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--compareFirmwareVersion");
        }
    }

    public synchronized void updateFirmware(String firmwareFileName) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->updateFirmware");
        }
        this.getDeviceServiceState().isOpenClaimEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (!this.getDeviceServiceState().getCapUpdateFirmware()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().updateFirmware(firmwareFileName);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--updateFirmware");
        }
    }

    protected HardTotalsServiceState getHardTotalsServiceState() {
        return (HardTotalsServiceState)this.getDeviceServiceState();
    }

    protected HardTotalsServiceImp getHardTotalsServiceImp() {
        return (HardTotalsServiceImp)this.getDeviceServiceImp();
    }

    public final String getDeviceCategory() {
        return HARDTOTALS_DEVCAT;
    }
}

