/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.LineDisplayService;
import com.ibm.jpos.services.LineDisplayServiceMsg;
import com.ibm.jpos.services.LineDisplayServiceState;
import jpos.JposException;

public final class IBM4840APA
extends LineDisplayService {
    private static final String ASCII_CUSTOM_GLYPH_LIST = "0020-00FF";
    private static final String ENGLISH_437_CUSTOM_GLYPH_LIST = "0001-0007,0009,000B,000C,000E-001A,0001C-00FF";
    private static final String JAPANESE_932_CUSTOM_GLYPH_LIST = "8140-81FF,8240-84FF,8840-88FF,8940-9FFF,E040-E0FF,E140-EAFF";
    private static final String KOREAN_1361_CUSTOM_GLYPH_LIST = "A1A0-A1FF,A2A0-ACFF,B0A0-B0FF,B1A0-C8FF,CAA0-CAFF,CBA0-FDFF";
    private static final String SIMPLIFIED_CHINESE_936_CUSTOM_GLYPH_LIST = "A1A0-A1FF,A2A0-A9FF,B0A0-B0FF,B1A0-F7FF";
    private static final String TRADITIONAL_CHINESE_950_CUSTOM_GLYPH_LIST = "A140-A1FF,A240-C6FF,C940-C9FF,CA40-F9FF";
    private static final int DISP_CS_ENGLISH = 437;
    private static final int DISP_CS_JAPANESE = 932;
    private static final int DISP_CS_KOREAN = 1361;
    private static final int DISP_CS_SIMPLIFIED_CHINESE = 936;
    private static final int DISP_CS_TRADITIONAL_CHINESE = 950;

    public IBM4840APA() {
        super(null);
        this.setDeviceServiceState(new State());
    }

    public void checkDirectIOArg(int command, int[] data) throws JposException {
        super.checkDirectIOArg(command, data);
        int numberOfRowsToSet = data[0];
        int screenModeArg = -1;
        if (command == 0) {
            if (numberOfRowsToSet == 4 || numberOfRowsToSet == 5) {
                screenModeArg = 0;
            } else if (numberOfRowsToSet == 2) {
                screenModeArg = 2;
            }
            this.checkScreenModeArg(screenModeArg);
        }
    }

    public void checkScreenModeArg(int screenMode) throws JposException {
        LineDisplayServiceState state = this.getLineDisplayServiceState();
        super.checkScreenModeArg(screenMode);
        if ((screenMode == 0 || screenMode == 1) && state.getCharacterSet() != 998 && state.getCharacterSet() != 437) {
            throw new JposException(106, "Invalid number of rows to set for the current character set");
        }
        if (screenMode == 2 && state.getCharacterSet() != 437 && state.getCharacterSet() != 932 && state.getCharacterSet() != 1361 && state.getCharacterSet() != 936 && state.getCharacterSet() != 950) {
            throw new JposException(106, "Invalid number of rows to set for the current character set");
        }
    }

    public void checkDirectIOInitService() throws JposException {
        LineDisplayServiceState state = this.getLineDisplayServiceState();
        state.isOpen();
    }

    public void checkCursorTypeArg(int cursorType) throws JposException {
        LineDisplayServiceState state = this.getLineDisplayServiceState();
        if (state.getCapCursorType() != 8 || cursorType != 4 && cursorType != 0) {
            throw new JposException(106);
        }
    }

    public void checkDefineGlyphArg(int glyphCode, byte[] glyph) throws JposException {
        LineDisplayServiceState state = this.getLineDisplayServiceState();
        boolean exists = false;
        boolean isElementaSet = false;
        String customGlyphList = state.getCustomGlyphList();
        String subSet = "";
        int glyphListLength = customGlyphList.length();
        int pointer = 0;
        int comma = -1;
        int middleLine = -1;
        if ((state.getRows() == 4 || state.getRows() == 5) && glyph.length != 7) {
            throw new JposException(106, "invalid arguments to define the glyph");
        }
        if (state.getRows() == 2 && state.getGlyphWidth() == 8 && state.getGlyphHeight() == 16 && glyph.length != 16) {
            throw new JposException(106, "invalid arguments to define the glyph");
        }
        if (state.getRows() == 2 && state.getGlyphWidth() == 16 && state.getGlyphHeight() == 16 && glyph.length != 32) {
            throw new JposException(106, "invalid arguments to define the glyph");
        }
        if (customGlyphList.length() > 0) {
            while (!exists && pointer < glyphListLength) {
                comma = customGlyphList.indexOf(44);
                if (comma != -1) {
                    subSet = customGlyphList.substring(0, comma);
                    pointer += comma;
                } else {
                    subSet = customGlyphList;
                    pointer += subSet.length();
                }
                middleLine = subSet.indexOf(45);
                if (middleLine != -1) {
                    isElementaSet = true;
                }
                if (isElementaSet) {
                    String leftSubString = subSet.substring(0, middleLine);
                    String rightSubString = subSet.substring(middleLine + 1, subSet.length());
                    int minorValue = this.hexToInt(leftSubString);
                    int higherValue = this.hexToInt(rightSubString);
                    if (glyphCode >= minorValue && glyphCode <= higherValue) {
                        exists = true;
                    }
                } else {
                    int aloneValue = this.hexToInt(subSet);
                    if (glyphCode == aloneValue) {
                        exists = true;
                    }
                }
                if (comma != -1) {
                    customGlyphList = customGlyphList.substring(comma + 1);
                }
                comma = -1;
                middleLine = -1;
                subSet = "";
                isElementaSet = false;
            }
        }
        if (!exists) {
            throw new JposException(106);
        }
    }

    public void updateCustomGlyphList() throws JposException {
        LineDisplayServiceState state = this.getLineDisplayServiceState();
        if (this.getCharacterSet() == 998) {
            state.setCustomGlyphList(ASCII_CUSTOM_GLYPH_LIST);
        } else if (state.getCharacterSet() == 437) {
            state.setCustomGlyphList(ENGLISH_437_CUSTOM_GLYPH_LIST);
        } else if (this.getCharacterSet() == 932) {
            state.setCustomGlyphList(JAPANESE_932_CUSTOM_GLYPH_LIST);
        } else if (this.getCharacterSet() == 1361) {
            state.setCustomGlyphList(KOREAN_1361_CUSTOM_GLYPH_LIST);
        } else if (this.getCharacterSet() == 936) {
            state.setCustomGlyphList(SIMPLIFIED_CHINESE_936_CUSTOM_GLYPH_LIST);
        } else if (this.getCharacterSet() == 950) {
            state.setCustomGlyphList(TRADITIONAL_CHINESE_950_CUSTOM_GLYPH_LIST);
        }
    }

    public void validRowsForCharacterSet(int characterSet) throws JposException {
        LineDisplayServiceState state = this.getLineDisplayServiceState();
        if ((characterSet == 932 || characterSet == 1361 || characterSet == 936 || characterSet == 950) && state.getRows() != 2) {
            throw new JposException(106, "invalid character set for the current number of rows");
        }
        if ((characterSet == 437 || characterSet == 998) && state.getRows() != 4 && state.getRows() != 5 && state.getRows() != 2) {
            throw new JposException(106, "invalid character set for the current number of rows");
        }
    }

    private class State
    extends LineDisplayServiceState {
        private State() {
        }

        public int getCapBlink() {
            return 1;
        }

        public boolean getCapBrightness() {
            return true;
        }

        public boolean getCapDescriptors() {
            return false;
        }

        public int getCapCharacterSet() {
            return 998;
        }

        public boolean getCapCustomGlyph() {
            return true;
        }

        public boolean getCapScreenMode() {
            return true;
        }

        synchronized void initProperties() throws JposException {
            super.initProperties();
            this.setDeviceServiceDescription(LineDisplayServiceMsg.IBM_DISPLAY_4840_APA_DEVICE_SERVICE_DESCRIPTION);
            this.setPhysicalDeviceDescription(LineDisplayServiceMsg.IBM_DISPLAY_4840_APA_PHYSICAL_DEVICE_DESCRIPTION);
            this.setPhysicalDeviceName(LineDisplayServiceMsg.IBM_DISPLAY_4840_APA_PHYSICAL_DEVICE_NAME);
            this.setDeviceRows(2);
            this.setDeviceColumns(20);
            this.setRows(2);
            this.setColumns(20);
            this.setScreenModeList("4x20,5x20,2x20");
            int[] validCharSets = new int[]{437, 932, 1361, 936, 950, 998};
            this.setValidCharacterSets(validCharSets);
            this.setCharacterSetList("437, 932, 1361, 936, 950, " + String.valueOf(998));
            this.setScreenModeListDirectIO("4, 5, 2");
            this.setCharacterSet(437);
            if (this.getCharacterSet() == 998) {
                this.setCustomGlyphList(IBM4840APA.ASCII_CUSTOM_GLYPH_LIST);
            } else if (this.getCharacterSet() == 437) {
                this.setCustomGlyphList(IBM4840APA.ENGLISH_437_CUSTOM_GLYPH_LIST);
            } else if (this.getCharacterSet() == 932) {
                this.setCustomGlyphList(IBM4840APA.JAPANESE_932_CUSTOM_GLYPH_LIST);
            } else if (this.getCharacterSet() == 1361) {
                this.setCustomGlyphList(IBM4840APA.KOREAN_1361_CUSTOM_GLYPH_LIST);
            } else if (this.getCharacterSet() == 936) {
                this.setCustomGlyphList(IBM4840APA.SIMPLIFIED_CHINESE_936_CUSTOM_GLYPH_LIST);
            } else if (this.getCharacterSet() == 950) {
                this.setCustomGlyphList(IBM4840APA.TRADITIONAL_CHINESE_950_CUSTOM_GLYPH_LIST);
            }
        }
    }
}

