/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.Tracer;

public final class Semaphore {
    private boolean value;
    private boolean doTrace = false;
    private String name = "";
    private long sem_num;
    private static String className = "Semaphore";
    private static long currentSemNum = 0L;

    public Semaphore() {
        this(false, false, "");
    }

    public Semaphore(boolean value) {
        this(value, false, "");
    }

    public Semaphore(boolean value, boolean trace, String name) {
        this.value = value;
        this.doTrace = trace;
        this.name = name;
        if (this.doTrace) {
            this.sem_num = ++currentSemNum;
            Tracer.trace(3, className, "Semaphore", " Sem " + name + this.sem_num + " is created. Init to " + value);
        }
    }

    public Semaphore(boolean value, boolean trace) {
        this(value, trace, "");
    }

    public synchronized int waitForSet() {
        int rc = 0;
        if (this.doTrace) {
            Tracer.trace(3, className, "Semaphore", "waitForSet " + this.name + this.sem_num);
        }
        while (!this.value) {
            try {
                if (this.doTrace) {
                    Tracer.trace(3, className, "Semaphore", " Sem " + this.name + this.sem_num + " waiting forever");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " finished waiting forever");
        }
        return rc;
    }

    public synchronized int waitForSet(long timeout) {
        int rc = 0;
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "waitForSet(" + timeout + ") " + this.name + this.sem_num);
        }
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " waiting " + timeout + " millisecs.");
        }
        try {
            if (!this.value) {
                if (this.doTrace) {
                    Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " is false, waiting " + timeout + " millisecs.");
                }
                this.wait(timeout);
            } else if (this.doTrace) {
                Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " is set, not waiting.");
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " finished waiting " + timeout + " millisecs.");
        }
        if (!this.value) {
            rc = 112;
            if (this.doTrace) {
                Tracer.trace(2, className, "Semaphore", " Sem " + this.name + this.sem_num + " is false, returning " + rc);
            }
        }
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "waitForSet(" + timeout + ") exit rc = " + rc);
        }
        return rc;
    }

    public synchronized void set() {
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "Set sem " + this.name + this.sem_num);
        }
        this.value = true;
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "Sem " + this.name + this.sem_num + " is " + this.value + ", notifiying");
        }
        this.notify();
    }

    public synchronized void reset() {
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "Reset sem " + this.name + this.sem_num);
        }
        this.value = false;
        if (this.doTrace) {
            Tracer.trace(2, className, "Semaphore", "Sem " + this.name + this.sem_num + " is " + this.value + ", notifiying");
        }
        this.notify();
    }

    public boolean isOn() {
        return this.value;
    }

    public boolean isOff() {
        return !this.value;
    }
}

