/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio;

import com.ibm.jsio.SioException;
import com.ibm.jsio.SioServices;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class SioHostManager {
    private static boolean propertiesLoaded = false;
    private static Properties properties = new Properties();
    private static SioServices sioServices = null;
    public static final String JSIO_PROPERTIES_FILE = "jsio.properties";
    public static final String JSIO_JSIOSERVICES_PROPERTY = "jsio.services";
    private static final String PROPERTIES_FILE_NOT_FOUND = "Properties file jsio.properties not found.";
    private static final String PROPERTIES_FILE_IOEXCEPTION_READING = "IOException while reading properties file jsio.properties";
    private static final String PROPERTIES_FILE_IOEXCEPTION_CLOSING = "IOException while closing properties file jsio.properties";

    private SioHostManager() {
    }

    public static synchronized SioServices getSioServices() throws SioException, SecurityException {
        if (null == sioServices) {
            sioServices = SioHostManager.createSioServices();
        }
        return sioServices;
    }

    public static synchronized Properties getProperties() throws SioException, SecurityException {
        if (!propertiesLoaded) {
            SioHostManager.setupProperties();
        }
        return (Properties)properties.clone();
    }

    private static SioServices createSioServices() throws SioException, SecurityException {
        String className = SioHostManager.getProperties().getProperty(JSIO_JSIOSERVICES_PROPERTY);
        if (null == className) {
            throw new SioException(SioHostManager.sioServices_PROPERTY_NOT_DEFINED());
        }
        try {
            return (SioServices)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfE) {
            throw new SioException(SioHostManager.sioServices_CLASSNOTFOUNDEXCEPTION(className) + " : " + cnfE.getMessage());
        }
        catch (ExceptionInInitializerError eiiE) {
            throw new SioException(SioHostManager.sioServices_EXCEPTIONININITIALIZERERROR(className) + " : " + eiiE.getMessage());
        }
        catch (InstantiationException iE) {
            throw new SioException(SioHostManager.sioServices_INSTANTIATIONEXCEPTION(className) + " : " + iE.getMessage());
        }
        catch (IllegalAccessException iaE) {
            throw new SioException(SioHostManager.sioServices_ILLEGALACCESSEXCEPTION(className) + " : " + iaE.getMessage());
        }
        catch (ClassCastException ccE) {
            throw new SioException(SioHostManager.sioServices_CLASSCASTEXCEPTION(className) + " : " + ccE.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private static void setupProperties() throws SioException, SecurityException {
        block8: {
            InputStream i = ClassLoader.getSystemResourceAsStream(JSIO_PROPERTIES_FILE);
            if (null == i) {
                throw new SioException(PROPERTIES_FILE_NOT_FOUND);
            }
            properties.load(i);
            Object var3_1 = null;
            try {
                i.close();
            }
            catch (IOException ioE) {
                Tracer t = TracerFactory.getInstance().createTracer("JSIO", "SioHostManager");
                t.println(2, "IOException while closing properties file jsio.properties : " + ioE.getMessage());
            }
            break block8;
            {
                catch (IOException ioE) {
                    throw new SioException("IOException while reading properties file jsio.properties : " + ioE.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    i.close();
                }
                catch (IOException ioE) {
                    Tracer t = TracerFactory.getInstance().createTracer("JSIO", "SioHostManager");
                    t.println(2, "IOException while closing properties file jsio.properties : " + ioE.getMessage());
                }
                throw throwable;
            }
        }
        propertiesLoaded = true;
    }

    private static final String sioServices_PROPERTY_NOT_DEFINED() {
        return "The property jsio.services is not defined as the implementation class of sioServices";
    }

    private static final String sioServices_CLASSNOTFOUNDEXCEPTION(String c) {
        return "The sioServices implementation class " + c + " was found found";
    }

    private static final String sioServices_EXCEPTIONININITIALIZERERROR(String c) {
        return "an Exception occurred during initialization of the sioServices Class " + c;
    }

    private static final String sioServices_INSTANTIATIONEXCEPTION(String c) {
        return "An Exception occurred during instantiation of the sioServices implementation " + c;
    }

    private static final String sioServices_ILLEGALACCESSEXCEPTION(String c) {
        return "An IllegalAccessException occurred while creating the sioServices implementation " + c;
    }

    private static final String sioServices_CLASSCASTEXCEPTION(String c) {
        return "The class " + c + " does not implement sioServices";
    }
}

