/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.event;

import com.ibm.jsio.event.SioServicesEvent;
import com.ibm.jsio.event.SioServicesEventHelper;
import com.ibm.jsio.event.SioServicesListener;
import com.ibm.jutil.tasks.FifoScheduler;
import com.ibm.jutil.tasks.Task;
import com.ibm.jutil.tasks.TaskScheduler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultSioServicesEventHelper
implements SioServicesEventHelper {
    private List listeners = new ArrayList();
    private TaskScheduler taskScheduler = new FifoScheduler();

    public void fireSioDeviceAttachedEvent(SioServicesEvent event) {
        this.taskScheduler.post((Task)new SioDeviceAttachedEventTask(event));
    }

    public void fireSioDeviceDetachedEvent(SioServicesEvent event) {
        this.taskScheduler.post((Task)new SioDeviceDetachedEventTask(event));
    }

    public synchronized void addSioServicesListener(SioServicesListener listener) {
        if (null != listener && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeSioServicesListener(SioServicesListener listener) {
        if (null != listener) {
            this.listeners.remove(listener);
        }
    }

    public synchronized int getListenerCount() {
        return this.listeners.size();
    }

    private class SioDeviceDetachedEventTask
    extends AbstractEventTask {
        SioDeviceDetachedEventTask(SioServicesEvent event) {
            super(event);
        }

        protected void fireEvent(SioServicesEvent event, SioServicesListener listener) {
            listener.sioDeviceDetached(event);
        }
    }

    private class SioDeviceAttachedEventTask
    extends AbstractEventTask {
        SioDeviceAttachedEventTask(SioServicesEvent event) {
            super(event);
        }

        protected void fireEvent(SioServicesEvent event, SioServicesListener listener) {
            listener.sioDeviceAttached(event);
        }
    }

    private abstract class AbstractEventTask
    implements Task {
        private SioServicesEvent sioServicesEvent = null;

        AbstractEventTask(SioServicesEvent event) {
            this.sioServicesEvent = event;
        }

        protected abstract void fireEvent(SioServicesEvent var1, SioServicesListener var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            ArrayList listenersCopy = null;
            List list = DefaultSioServicesEventHelper.this.listeners;
            synchronized (list) {
                listenersCopy = new ArrayList(DefaultSioServicesEventHelper.this.listeners);
            }
            Iterator iterator = listenersCopy.iterator();
            while (iterator.hasNext()) {
                SioServicesListener listener = (SioServicesListener)iterator.next();
                this.fireEvent(this.sioServicesEvent, listener);
            }
        }

        public Exception getException() {
            return null;
        }

        public boolean isExecuted() {
            return false;
        }

        public boolean isInException() {
            return false;
        }

        public String getName() {
            return "";
        }
    }
}

