/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioException;
import com.ibm.jsio.os.sockets.SioImpUtil;
import com.ibm.jsio.os.sockets.SioQueryDeviceElement;
import com.ibm.jsio.os.sockets.SioQueryParser;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SioQueryXercesParser
implements SioQueryParser {
    private boolean parserInitialized = false;
    private XMLReader xmlReader = new SAXParser();
    private DefaultContentHandler contentHandler = new DefaultContentHandler();
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private Tracer tracer = TracerFactory.getInstance().createTracer("JSIO", SioImpUtil.getClassName(this));
    public static final int DECIMAL = 10;
    public static final int HEX = 16;
    public static final String TAG_QUERY = "query";
    public static final String TAG_UPDATE = "update";
    public static final String TAG_DEVICE = "device";
    public static final String TAG_DEVICE_NUMBER = "deviceNumber";
    public static final String TAG_SLOT_NUMBER = "slotNumber";
    public static final String TAG_PORT_NUMBER = "portNumber";
    public static final String TAG_TCP_PORT = "tcpPort";

    public List parse(String data) throws SioException {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "--> parse()");
        }
        List devList = null;
        try {
            this.initParser();
            this.xmlReader.parse(new InputSource(new ByteArrayInputStream(data.getBytes())));
            devList = this.contentHandler.getDeviceList();
        }
        catch (SAXException se) {
            throw new SioException("Could not parse XML file: " + this.xmlReader, se);
        }
        catch (IOException ioe) {
            throw new SioException("Could not parse XML file: " + this.xmlReader + " IOException.message = " + ioe.getMessage(), ioe);
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<-- parse()");
        }
        return devList;
    }

    protected void initParser() throws SioException {
        if (this.parserInitialized) {
            return;
        }
        try {
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.xmlReader.setContentHandler(this.contentHandler);
            this.xmlReader.setErrorHandler(this.errorHandler);
            this.parserInitialized = true;
        }
        catch (SAXException se) {
            throw new SioException("Could not initialize SAX parser!", se);
        }
    }

    protected class DefaultErrorHandler
    implements ErrorHandler {
        public void warning(SAXParseException exception) throws SAXException {
            if (SioQueryXercesParser.this.tracer.isOn()) {
                SioQueryXercesParser.this.tracer.println(3, "warning: exception = " + exception.getMessage());
            }
        }

        public void error(SAXParseException exception) throws SAXException {
            if (SioQueryXercesParser.this.tracer.isOn()) {
                SioQueryXercesParser.this.tracer.println(3, "error: exception = " + exception.getMessage());
            }
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            if (SioQueryXercesParser.this.tracer.isOn()) {
                SioQueryXercesParser.this.tracer.println(3, "fatalError: exception = " + exception.getMessage());
            }
        }
    }

    protected class DefaultContentHandler
    extends DefaultHandler {
        private ArrayList deviceList = null;
        private SioQueryDeviceElement devElement = null;
        private String characters = null;

        public List getDeviceList() {
            return this.deviceList;
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            this.characters = new String(data, start, length);
        }

        public void startDocument() throws SAXException {
            this.deviceList = null;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if (qName.equals(SioQueryXercesParser.TAG_QUERY) || qName.equals(SioQueryXercesParser.TAG_UPDATE)) {
                    this.deviceList = new ArrayList();
                } else if (qName.equals(SioQueryXercesParser.TAG_DEVICE)) {
                    this.devElement = new SioQueryDeviceElement();
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (SioQueryXercesParser.this.tracer.isOn()) {
                SioQueryXercesParser.this.tracer.println(3, "endElement: qName = " + qName);
            }
            try {
                if (qName.equals(SioQueryXercesParser.TAG_DEVICE)) {
                    this.addDevice(this.devElement);
                } else if (qName.equals(SioQueryXercesParser.TAG_SLOT_NUMBER)) {
                    this.devElement.setSlotNumber(Byte.parseByte(this.characters, 10));
                } else if (qName.equals(SioQueryXercesParser.TAG_PORT_NUMBER)) {
                    this.devElement.setPortNumber(Byte.parseByte(this.characters, 10));
                } else if (qName.equals(SioQueryXercesParser.TAG_DEVICE_NUMBER)) {
                    this.devElement.setDeviceNumber(Byte.parseByte(this.characters, 10));
                } else if (qName.equals(SioQueryXercesParser.TAG_TCP_PORT)) {
                    this.devElement.setTcpPort(Integer.parseInt(this.characters, 10));
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private void addDevice(SioQueryDeviceElement devElement) throws SAXException {
            if (devElement.getDeviceNumber() == 0) {
                throw new SAXException("Parsing Error. Unexpected device number");
            }
            this.deviceList.add(devElement);
        }
    }
}

