/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.handlers.http;

import br.com.auttar.clientservices.model.ResponseCode;
import br.com.auttar.clientservices.model.ResultModel;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.SessionMessageType;
import br.com.auttar.clientservices.util.TextUtil;
import br.com.auttar.framework.http.HttpResponseHandler;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class DefaultHttpResponseHandler
implements HttpResponseHandler {
    private Log log = LogFactory.getLog(DefaultHttpResponseHandler.class);
    private SessionMessage sessionMessage;

    public DefaultHttpResponseHandler(SessionMessage sessionMessage) {
        this.sessionMessage = sessionMessage;
    }

    @Override
    public void handle(int httpStatusCode, HttpResponse httpResponse) {
        try {
            this.log.info((Object)String.format("http response -> %s (%s), status: %s", this.sessionMessage.getType().name(), this.sessionMessage.getSessionId(), httpStatusCode));
            HttpEntity entity = httpResponse.getEntity();
            if (httpStatusCode == 204) {
                this.log.debug((Object)String.format("http response -> http: %s", httpStatusCode));
                ResultModel resultModel = new ResultModel();
                resultModel.setNoContent();
                resultModel.setCode(0);
                this.sessionMessage.send(resultModel);
            } else {
                String response = EntityUtils.toString((HttpEntity)entity);
                response = TextUtil.stripAccents(response);
                this.log.debug((Object)String.format("http response -> http: %s, message: %s", httpStatusCode, response));
                if (response != null && response.length() > 0) {
                    JsonObject jsonObject = new JsonParser().parse(response).getAsJsonObject();
                    if (this.sessionMessage.getType() == SessionMessageType.get_tax_receipt || this.sessionMessage.getType() == SessionMessageType.post_payment) {
                        if (!jsonObject.has("status")) {
                            jsonObject.addProperty("status", (Number)httpStatusCode);
                        }
                        if (!jsonObject.has("code")) {
                            if (httpStatusCode >= 200 && httpStatusCode <= 299) {
                                jsonObject.addProperty("code", (Number)ResponseCode.SUCCESS.getValue());
                            } else if (httpStatusCode == 404) {
                                jsonObject.addProperty("code", (Number)ResponseCode.CHECKOUT_NOT_FOUND.getValue());
                            }
                        }
                    }
                    this.sessionMessage.send(jsonObject);
                } else {
                    ResultModel resultModel = new ResultModel();
                    resultModel.setStatus(httpStatusCode);
                    if (httpStatusCode >= 200 && httpStatusCode <= 299) {
                        resultModel.setCode(0);
                    }
                    this.sessionMessage.send(resultModel);
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (JsonParseException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T extends Exception> void error(T e) {
        this.log.error((Object)String.format("http response -> %s (%s), erro: %s", this.sessionMessage.getType().name(), this.sessionMessage.getSessionId(), e.getMessage()));
    }
}

