/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util.configuration;

import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyType;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.util.configuration.AlertDialog;
import com.linx.touchkeyboard.util.configuration.KeyConfigurationDialog;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyConfigurationDialogController
implements Initializable {
    Logger logger = LoggerFactory.getLogger(KeyConfigurationDialogController.class);
    private Stage stageParent;
    @FXML
    private TextField tfLabel;
    @FXML
    private TextField tfAscCode;
    @FXML
    private TextField tfCharCode;
    @FXML
    private TextField tfStyleId;
    @FXML
    private Button btOK;
    @FXML
    private Button btCancel;
    @FXML
    private ChoiceBox<String> selectType;

    public TextField getTfLabel() {
        return this.tfLabel;
    }

    public TextField getTfAscCode() {
        return this.tfAscCode;
    }

    public TextField getTfCharCode() {
        return this.tfCharCode;
    }

    public TextField getTfStyleId() {
        return this.tfStyleId;
    }

    public ChoiceBox<String> getSelectType() {
        return this.selectType;
    }

    public Stage getStageParent() {
        return this.stageParent;
    }

    public void setStageParent(Stage stage) {
        this.stageParent = stage;
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.selectType.setItems(FXCollections.observableArrayList(KeyType.valuesAsArrayListString()));
    }

    private ArrayList<String> validateFields() {
        this.logger.debug("Iniciando valida\u00e7\u00e3o de campos...");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.tfAscCode.getText() == null || this.tfAscCode.getText().trim().equalsIgnoreCase("")) {
            this.logger.debug("C\u00f3digo ASC n\u00e3o informado.");
            arrayList.add("- C\u00f3digo ASC n\u00e3o informado.");
        } else {
            try {
                Integer.parseInt(this.tfAscCode.getText().trim());
            }
            catch (Exception exception) {
                this.logger.error("C\u00f3digo ASC ' {} ' inv\u00e1lido. Por favor, informe somente caracteres num\u00e9ricos", (Object)this.tfAscCode.getText().trim());
                arrayList.add("- C\u00f3digo ASC '" + this.tfAscCode.getText() + "'" + " inv\u00e1lido. Por favor, informe somente caracteres num\u00e9ricos");
            }
        }
        if (this.tfCharCode.getText() != null && this.tfCharCode.getText().length() == 0) {
            this.logger.debug("Char Code n\u00e3o informado.");
            arrayList.add("- Char Code n\u00e3o informado.");
        }
        if (this.selectType == null || this.selectType.getSelectionModel() == null || this.selectType.getSelectionModel().getSelectedItem() == null) {
            this.logger.debug("Tipo de Tecla n\u00e3o selecionado.");
            arrayList.add("- Tipo de Tecla n\u00e3o selecionado.");
        }
        this.logger.debug("Valida\u00e7\u00e3o de campos finalizada.");
        return arrayList;
    }

    @FXML
    public void confirmKeyEdit(ActionEvent actionEvent) {
        this.logger.debug("Iniciando tratamento do evento de modifica\u00e7\u00e3o de tecla.");
        Stage stage = (Stage)this.btOK.getScene().getWindow();
        ArrayList<String> arrayList = this.validateFields();
        if (arrayList == null || arrayList.size() == 0) {
            this.logger.debug("Sem erros na valida\u00e7\u00e3o das informa\u00e7\u00f5es da tecla.");
            if (stage instanceof KeyConfigurationDialog) {
                KeyConfigurationDialog keyConfigurationDialog = (KeyConfigurationDialog)stage;
                Layout layout = keyConfigurationDialog.getLayout();
                TouchKeyboardKey touchKeyboardKey = keyConfigurationDialog.getTouchKeyboardKey();
                touchKeyboardKey.getKey().setKeyCode(Integer.parseInt(this.tfAscCode.getText().trim()));
                touchKeyboardKey.getKey().setKeyChar(this.tfCharCode.getText().charAt(0));
                if (this.tfStyleId.getText() != null) {
                    touchKeyboardKey.getKey().setStyleId(this.tfStyleId.getText().trim());
                }
                String string = (String)this.selectType.getSelectionModel().getSelectedItem();
                touchKeyboardKey.getKey().setType(KeyType.getKeyType(string));
                touchKeyboardKey.getKey().setLabel(this.tfLabel.getText());
                touchKeyboardKey.setText(this.tfLabel.getText());
                if (layout != null && layout.getKeys() != null) {
                    this.logger.debug("Atualizando layout com as modifica\u00e7\u00f5es da tecla.");
                    layout.getKeys().remove(new Key(touchKeyboardKey.getKey().getRow(), touchKeyboardKey.getKey().getColumn()));
                    layout.getKeys().add(touchKeyboardKey.getKey());
                    this.logger.debug("Layout atualizado.");
                }
            }
            this.getStageParent().hide();
        } else {
            this.logger.error("Erro na valida\u00e7\u00e3o das informa\u00e7\u00f5es da tecla: " + arrayList);
            new AlertDialog(this.getStageParent(), arrayList, null).showAndWait();
        }
        this.logger.debug("Finalizando tratamento do evento de modifica\u00e7\u00e3o de tecla.");
    }

    @FXML
    public void cancelKeyEdit(ActionEvent actionEvent) {
        this.getStageParent().hide();
    }

    @FXML
    public void limitAmountCharCode(KeyEvent keyEvent) {
        this.logger.debug("Iniciando tratamento de limite de tamanho. Campo: Char Code");
        if (this.tfCharCode != null && this.tfCharCode.getText() != null && this.tfCharCode.getText().length() > 0) {
            this.tfCharCode.setText(keyEvent.getText());
        }
        this.logger.debug("Finalizando tratamento de limite de tamanho. Campo: Char Code");
    }
}

