/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util.configuration;

import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.util.configuration.AlertDialog;
import com.linx.touchkeyboard.util.configuration.KeyConfigurationDialog;
import com.linx.touchkeyboard.util.configuration.KeyConfigurationDialogController;
import java.net.URL;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboardKeyEventHandler
implements EventHandler<ActionEvent> {
    Logger logger = LoggerFactory.getLogger(TouchKeyboardKeyEventHandler.class);
    private static final String KEY_CONFIG_FXML = "KeyConfigurationDialog.fxml";
    private TouchKeyboardKey keyboardKey;
    private Layout layout;

    public TouchKeyboardKeyEventHandler(Layout layout, TouchKeyboardKey touchKeyboardKey) {
        this.layout = layout;
        this.keyboardKey = touchKeyboardKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ActionEvent actionEvent) {
        try {
            this.logger.debug("Iniciando tratamento pata tecla selecionada");
            URL uRL = this.getClass().getResource(KEY_CONFIG_FXML);
            FXMLLoader fXMLLoader = new FXMLLoader(uRL);
            Parent parent = (Parent)fXMLLoader.load();
            this.logger.debug("Instanciando controller");
            KeyConfigurationDialogController keyConfigurationDialogController = (KeyConfigurationDialogController)fXMLLoader.getController();
            if (this.keyboardKey != null && this.keyboardKey.getKey() != null) {
                this.logger.debug("Incluindo informa\u00e7\u00f5es da teclas nos componentes do controller");
                keyConfigurationDialogController.getTfAscCode().setText(this.keyboardKey.getKey().getKeyCode() + "");
                keyConfigurationDialogController.getTfCharCode().setText(this.keyboardKey.getKey().getKeyChar() + "");
                keyConfigurationDialogController.getTfLabel().setText(this.keyboardKey.getKey().getLabel());
                keyConfigurationDialogController.getTfStyleId().setText(this.keyboardKey.getKey().getStyleId());
                if (this.keyboardKey.getKey().getType() != null) {
                    keyConfigurationDialogController.getSelectType().getSelectionModel().select((Object)this.keyboardKey.getKey().getType().getLabel());
                }
                this.logger.debug("Informa\u00e7\u00f5es inclupidas no controller com sucesso.");
            }
            this.logger.debug("Inicializando Tela de Edi\u00e7\u00e3o de Teclas");
            Scene scene = new Scene(parent);
            KeyConfigurationDialog keyConfigurationDialog = new KeyConfigurationDialog(StageStyle.TRANSPARENT);
            keyConfigurationDialog.initModality(Modality.WINDOW_MODAL);
            keyConfigurationDialog.initOwner(this.keyboardKey.getScene().getWindow());
            keyConfigurationDialog.setScene(scene);
            keyConfigurationDialog.setTouchKeyboardKey((TouchKeyboardKey)((Object)actionEvent.getSource()));
            keyConfigurationDialog.setLayout(this.layout);
            keyConfigurationDialog.centerOnScreen();
            keyConfigurationDialogController.setStageParent(keyConfigurationDialog);
            keyConfigurationDialog.show();
            this.logger.debug("Tela de Edi\u00e7\u00e3o de Teclas configurada e liberada para exibi\u00e7\u00e3o");
        }
        catch (Exception exception) {
            new AlertDialog((Stage)this.keyboardKey.getScene().getWindow(), "N\u00e3o foi poss\u00edvel exibir informa\u00e7\u00f5es da Tecla Selecionada").showAndWait();
            this.logger.error("N\u00e3o foi poss\u00edvel exibir informa\u00e7\u00f5es da Tecla Selecionada", (Throwable)exception);
        }
        finally {
            this.logger.debug("Finalizandio tratamento pata tecla selecionada");
        }
    }
}

