/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj;

import com.ibm.posj.AbstractHandleCmd;
import com.ibm.posj.DefaultSystemCmd;
import com.ibm.posj.HandleCmd;
import com.ibm.posj.HandleCmdVisitor;
import com.ibm.posj.HandleConst;
import com.ibm.posj.HandleException;
import com.ibm.posj.MICRCmd;
import com.ibm.posj.MICRCmdVisitor;

abstract class DefaultMICRCmd
extends AbstractHandleCmd
implements MICRCmd {
    private String name = "";
    private int code = 0;
    protected byte[] byteArray = new byte[0];
    private Factory factory = new Factory();

    DefaultMICRCmd(HandleCmd.Factory factory, String name, int code) {
        super(factory);
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public byte[] toBytes() {
        return this.byteArray;
    }

    public void accept(HandleCmdVisitor visitor) {
        visitor.visitMICRCmd(this);
    }

    public abstract void accept(MICRCmdVisitor var1) throws HandleException;

    public static class Factory
    extends DefaultSystemCmd.Factory
    implements MICRCmd.Factory,
    HandleConst {
        public MICRCmd createBeginInsertionCmd() {
            return new BeginInsertionCmd(this, "BeginInsertion", 502);
        }

        public MICRCmd createEndInsertionCmd() {
            return new EndInsertionCmd(this, "EndInsertion", 503);
        }

        public MICRCmd createBeginRemovalCmd() {
            return new BeginRemovalCmd(this, "BeginRemoval", 504);
        }

        public MICRCmd createEndRemovalCmd() {
            return new EndRemovalCmd(this, "EndInsertion", 505);
        }

        public void recycle(HandleCmd cmd) {
            cmd.clean();
        }
    }

    public static class EndRemovalCmd
    extends DefaultMICRCmd
    implements MICRCmd.EndRemovalCmd {
        public EndRemovalCmd(HandleCmd.Factory factory, String name, int code) {
            super(factory, "EndRemoval", 505);
        }

        public void accept(MICRCmdVisitor v) throws HandleException {
            v.visitEndRemovalCmd(this);
        }
    }

    public static class BeginRemovalCmd
    extends DefaultMICRCmd
    implements MICRCmd.BeginRemovalCmd {
        public BeginRemovalCmd(HandleCmd.Factory factory, String name, int code) {
            super(factory, "BeginRemoval", 504);
        }

        public void accept(MICRCmdVisitor v) throws HandleException {
            v.visitBeginRemovalCmd(this);
        }
    }

    public static class EndInsertionCmd
    extends DefaultMICRCmd
    implements MICRCmd.EndInsertionCmd {
        public EndInsertionCmd(HandleCmd.Factory factory, String name, int code) {
            super(factory, "EndInsertion", 503);
        }

        public void accept(MICRCmdVisitor v) throws HandleException {
            v.visitEndInsertionCmd(this);
        }
    }

    public static class BeginInsertionCmd
    extends DefaultMICRCmd
    implements MICRCmd.BeginInsertionCmd {
        public BeginInsertionCmd(HandleCmd.Factory factory, String name, int code) {
            super(factory, "BeginInsertion", 502);
        }

        public void accept(MICRCmdVisitor v) throws HandleException {
            v.visitBeginInsertionCmd(this);
        }
    }
}

