/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.hid.javaxusb;

import com.ibm.hid.DisconnectEvent;
import com.ibm.hid.HidDevice;
import com.ibm.hid.HidException;
import com.ibm.hid.HidExceptionEvent;
import com.ibm.hid.HidListener;
import com.ibm.hid.ReportEvent;
import com.ibm.jutil.BooleanMonitor;
import com.ibm.jutil.SleepPolicy;
import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.HandleException;
import com.ibm.posj.bus.PrinterSubDevices;
import com.ibm.posj.bus.hid.AbstractHidHandleImp;
import com.ibm.posj.bus.hid.DefaultHidKeylockStrategy;
import com.ibm.posj.bus.hid.DefaultHidPOSKeyboardStrategy;
import com.ibm.posj.bus.hid.DefaultHidToneIndicatorStrategy;
import com.ibm.posj.bus.hid.Hid4610PrinterHandleImp;
import com.ibm.posj.bus.hid.Hid4689PrinterHandleImp;
import com.ibm.posj.bus.hid.HidAPALineDisplayHandleImp;
import com.ibm.posj.bus.hid.HidBootModePOSKeyboardHandleImp;
import com.ibm.posj.bus.hid.HidCashDrawerHandleImp;
import com.ibm.posj.bus.hid.HidFiscalPrinterHandleImp;
import com.ibm.posj.bus.hid.HidFlashHandleImp;
import com.ibm.posj.bus.hid.HidHandleImp;
import com.ibm.posj.bus.hid.HidHandleKey;
import com.ibm.posj.bus.hid.HidHardTotalsHandleImp;
import com.ibm.posj.bus.hid.HidKeylockHandleImp;
import com.ibm.posj.bus.hid.HidKeylockStrategy;
import com.ibm.posj.bus.hid.HidLineDisplayHandleImp;
import com.ibm.posj.bus.hid.HidMSRHandleImp;
import com.ibm.posj.bus.hid.HidPOSKeyboardHandleImp;
import com.ibm.posj.bus.hid.HidPOSKeyboardStrategy;
import com.ibm.posj.bus.hid.HidPOSPrinterCashDrawerHandleImp;
import com.ibm.posj.bus.hid.HidPOSPrinterCheckScannerHandleImp;
import com.ibm.posj.bus.hid.HidPOSPrinterMICRHandleImp;
import com.ibm.posj.bus.hid.HidPOSPrinterToneIndicatorHandleImp;
import com.ibm.posj.bus.hid.HidScaleHandleImp;
import com.ibm.posj.bus.hid.HidScannerHandleImp;
import com.ibm.posj.bus.hid.HidToneIndicatorHandleImp;
import com.ibm.posj.bus.hid.HidToneIndicatorStrategy;
import com.ibm.posj.bus.hid.javaxusb.HidDeviceUsbFactory;
import com.ibm.posj.bus.hid.javaxusb.UsbHandlePopulator;
import com.ibm.posj.bus.hid.javaxusb.UsbIDUtil;
import com.ibm.posj.bus.hid.javaxusb.UsbInitializationManager;
import com.ibm.posj.printer.IBM4610SSTToneIndicatorImp;
import com.ibm.posj.printer.ibm4610.IBM4610CashDrawerImp;
import com.ibm.posj.printer.ibm4610.IBM4610CheckScannerImp;
import com.ibm.posj.printer.ibm4610.IBM4610MICRImp;
import com.ibm.posj.util.DevCat;
import com.ibm.posj.util.DevCats;
import com.ibm.posj.util.POSKeyboardUtil;
import com.ibm.posj.util.PosjUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;

public class UsbHandleImpFactory {
    private UsbInitializationManager initializer = null;
    private UsbHandlePopulator usbHandlePopulator = null;
    private HidDeviceUsbFactory factory = new HidDeviceUsbFactory();
    private Hashtable numberTable = new Hashtable();
    private List handleImpTmpList = new ArrayList();
    private List processedDevices = new Vector();
    private List switched = null;
    private Hashtable hidHandleImpTable = new Hashtable();
    private HidKeylockStrategy.Factory keylockStrategyFactory = null;
    private HidToneIndicatorStrategy.Factory toneStrategyFactory = null;
    private HidPOSKeyboardStrategy.Factory kbdStrategyFactory = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("HID", "UsbHandleImpFactory");
    private boolean isCheckScannerPresent = false;
    private boolean isMicrPresent = false;
    private boolean isTIPresent = false;
    private int cashDrawer4610DevNum = 4;
    private int printerID_microcodeLevel = -1;
    private final List EMPTY_LIST = new ArrayList();
    public static final byte TI4_EMULATION_BIT_POSITION = 1;
    public static boolean REMOVE_MOD4_EMU = false;
    public static byte[] MOD4_MCT = null;
    private static byte PRINTER_REPORT_ID = (byte)53;
    private static byte MAX_RETRIES = (byte)2;

    public UsbHandleImpFactory(UsbHandlePopulator populator) {
        this.usbHandlePopulator = populator;
        this.initializer = new UsbInitializationManager(populator);
    }

    public synchronized List createHandleImps(UsbInterface usbInterface) throws HidException {
        byte bInterfaceNumber = usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber();
        String bInterfaceNumberString = Integer.toString(Util.unsignedInt((byte)bInterfaceNumber));
        if (this.tracer.isOn()) {
            this.tracer.println("Creating HandleImps for UsbInterface " + bInterfaceNumberString);
        }
        short pId = usbInterface.getUsbConfiguration().getUsbDevice().getUsbDeviceDescriptor().idProduct();
        short vId = usbInterface.getUsbConfiguration().getUsbDevice().getUsbDeviceDescriptor().idVendor();
        byte interfaceNumber = usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber();
        if (this.ignoreUsbInterface(usbInterface) || UsbIDUtil.getInstance().ignoreInterface(vId, pId, interfaceNumber)) {
            if (this.tracer.isOn()) {
                this.tracer.println("Ignoring interface.");
            }
            return new ArrayList();
        }
        HidDevice hidDevice = this.factory.createHidDevice(usbInterface);
        try {
            hidDevice.connect();
        }
        catch (HidException hE) {
            if (this.tracer.isOn()) {
                this.tracer.println("Could not connect HidDevice : " + hE.getMessage());
                this.tracer.print((Exception)hE);
            }
            hidDevice.disconnect();
            throw hE;
        }
        int usage = 0;
        try {
            usage = this.getUsage(hidDevice);
        }
        catch (HidException hE) {
            if (this.tracer.isOn()) {
                this.tracer.println("Could not get Usage : " + hE.getMessage());
            }
            hidDevice.disconnect();
            throw hE;
        }
        try {
            short usagePage = this.getUsagePage(usage);
            if (this.tracer.isOn()) {
                this.tracer.println("UsagePage =" + Util.toHexString((short)usagePage) + ", Usage =" + Util.toHexString((short)((short)usage)));
            }
            switch (usagePage) {
                case 1: {
                    return this.createGenericDesktopHandleImps(usbInterface, hidDevice, usage);
                }
                case -187: {
                    return this.createIbmHandleImps(usbInterface, hidDevice, usage);
                }
            }
            if (this.tracer.isOn()) {
                this.tracer.println("Unrecognized UsbInterface UsagePage 0x" + Util.toHexString((short)usagePage) + ", ignoring.");
            }
            hidDevice.disconnect();
            return new ArrayList();
        }
        catch (HidException hE) {
            hidDevice.disconnect();
            throw hE;
        }
    }

    public synchronized List createHandleImps(UsbDevice usbDevice) {
        Iterator usbInterfaces;
        String serialNumberString;
        String idString;
        short idProduct;
        short idVendor;
        block28: {
            if (usbDevice.isUsbHub()) {
                return this.createHandleImps((UsbHub)usbDevice);
            }
            UsbDeviceDescriptor usbDeviceDescriptor = usbDevice.getUsbDeviceDescriptor();
            idVendor = usbDeviceDescriptor.idVendor();
            idProduct = usbDeviceDescriptor.idProduct();
            String idVendorString = "0x" + Util.toHexString((short)idVendor);
            String idProductString = "0x" + Util.toHexString((short)idProduct);
            idString = "<" + idVendorString + "," + idProductString + ">";
            serialNumberString = "";
            if (this.tracer.isOn()) {
                this.tracer.println("Creating HandleImps for UsbDevice " + idString + " S/N " + serialNumberString);
            }
            if (!this.isKnownPosDevice(usbDevice)) {
                if (this.tracer.isOn()) {
                    this.tracer.println("UsbDevice " + idString + " is not known POS device, skipping.");
                }
                return this.EMPTY_LIST;
            }
            if (this.processedDevices.contains(new Integer(usbDevice.hashCode()))) {
                if (this.tracer.isOn()) {
                    this.tracer.println("Device (hashCode " + usbDevice.hashCode() + ") already processed, ignoring.");
                }
                return this.EMPTY_LIST;
            }
            if (this.tracer.isOn()) {
                this.tracer.println("Processing device (hashcode " + usbDevice.hashCode() + ")");
            }
            this.processedDevices.add(new Integer(usbDevice.hashCode()));
            try {
                serialNumberString = usbDevice.getSerialNumberString();
                if (this.tracer.isOn()) {
                    this.tracer.println("UsbDevice has SerialNumber '" + serialNumberString + "'");
                }
            }
            catch (UnsupportedEncodingException ued) {
                this.tracer.print((Exception)ued);
            }
            catch (UsbDisconnectedException ude) {
                if (this.tracer.isOn()) {
                    short pId = usbDevice.getUsbDeviceDescriptor().idProduct();
                    this.tracer.print((Exception)((Object)ude));
                    this.tracer.println("UsbDisconnectedException " + ude.toString() + " during usbDevice.getSerialNumberString() ignoring device:" + Util.toHexString((short)pId));
                }
                return this.EMPTY_LIST;
            }
            catch (Exception e) {
                if (!this.tracer.isOn()) break block28;
                this.tracer.println("Could not get device SerialNumber : " + e.getMessage());
                this.tracer.print(e);
            }
        }
        if (!this.initializer.initializeUsbDevice(usbDevice)) {
            if (this.tracer.isOn()) {
                this.tracer.println("Device not initialized, deferring to initializer.");
            }
            return this.EMPTY_LIST;
        }
        LinkedList list = new LinkedList();
        try {
            usbInterfaces = usbDevice.getActiveUsbConfiguration().getUsbInterfaces().iterator();
        }
        catch (NullPointerException npE) {
            if (this.tracer.isOn()) {
                this.tracer.println("Got NPE while getting UsbInterfaces : " + npE.getMessage());
                this.tracer.print((Exception)npE);
            }
            return this.EMPTY_LIST;
        }
        try {
            while (usbInterfaces.hasNext()) {
                list.addAll(this.createHandleImps((UsbInterface)usbInterfaces.next()));
            }
        }
        catch (UsbDisconnectedException ude) {
            if (this.tracer.isOn()) {
                this.tracer.println("UsbDisconnectedException during HandleImp creation, disconnecting " + list.size() + " HandleImps and ignoring device : " + ude.getMessage());
            }
            for (int i = 0; i < list.size(); ++i) {
                ((HidHandleImp)list.get(i)).getHidDevice().disconnect();
            }
            return this.EMPTY_LIST;
        }
        catch (Exception e) {
            if (this.tracer.isOn()) {
                this.tracer.println("Exception during HandleImp creation, disconnecting " + list.size() + " HandleImps and ignoring device : " + e.getMessage());
            }
            for (int i = 0; i < list.size(); ++i) {
                ((HidHandleImp)list.get(i)).getHidDevice().disconnect();
            }
            return this.EMPTY_LIST;
        }
        for (int i = 0; i < list.size(); ++i) {
            HidHandleImp hidHandleImp = (HidHandleImp)list.get(i);
            hidHandleImp.setSerialNumber(serialNumberString);
            hidHandleImp.setVendorID(idVendor);
            hidHandleImp.setProductID(idProduct);
            hidHandleImp.setBCDLevel(usbDevice.getUsbDeviceDescriptor().bcdDevice());
            hidHandleImp.getHandleImpGroup().clear();
            hidHandleImp.getHandleImpGroup().addAll(list);
            this.addToTable(hidHandleImp);
        }
        if (this.tracer.isOn()) {
            this.tracer.println("HandleImp creation successful, " + list.size() + " HandleImps created for device " + idString + " bcdLevel 0x" + Util.toHexString((short)usbDevice.getUsbDeviceDescriptor().bcdDevice()) + " S/N " + serialNumberString);
        }
        return list;
    }

    public synchronized List createHandleImps(UsbHub usbHub) {
        LinkedList list = new LinkedList();
        List usbDevices = usbHub.getAttachedUsbDevices();
        Iterator uii = usbDevices.iterator();
        while (uii.hasNext()) {
            list.addAll(this.createHandleImps((UsbDevice)uii.next()));
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    protected List createIbmHandleImps(UsbInterface usbInterface, HidDevice hd, int usage) throws HidException {
        list = new LinkedList<AbstractHidHandleImp>();
        key = null;
        productID = 0;
        switch ((short)usage) {
            case 14336: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.FISCALPRINTER_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.FISCALPRINTER_DEVCAT);
                list.add(new HidFiscalPrinterHandleImp(key, hd));
                break;
            }
            case 28160: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.SCALE_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.SCALE_DEVCAT);
                list.add(new HidScaleHandleImp(key, hd));
                break;
            }
            case 8704: 
            case 9216: 
            case 9472: 
            case 9728: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.LINEDISPLAY_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.LINEDISPLAY_DEVCAT);
                list.add(new HidLineDisplayHandleImp(key, hd));
                break;
            }
            case 10752: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.LINEDISPLAY_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.LINEDISPLAY_DEVCAT);
                list.add(new HidAPALineDisplayHandleImp(key, hd));
                break;
            }
            case 18944: 
            case 19200: {
                this.disableScanner(hd);
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.SCANNER_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.SCANNER_DEVCAT);
                list.add(new HidScannerHandleImp(key, hd));
                break;
            }
            case 13056: {
                if (!UsbHandleImpFactory.REMOVE_MOD4_EMU) break;
                sn = "";
                try {
                    sn = usbInterface.getUsbConfiguration().getUsbDevice().getSerialNumberString();
                }
                catch (Exception e) {
                    if (!this.tracer.isOn()) ** GOTO lbl46
                    this.tracer.println("Failed getting serial number before mod4 switch");
                    this.tracer.print(e);
                }
lbl46:
                // 3 sources

                this.switchMod4Emulation(hd, sn);
                break;
            }
            case 13568: {
                if (this.reconnectPOSPrinter(list, hd.getSynchronizedHidDevice(), usbInterface)) break;
                return this.createPOSPrinterHandleImps(usbInterface, hd);
            }
            case 14080: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.POSPRINTER_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.POSPRINTER_DEVCAT);
                list.add(new Hid4689PrinterHandleImp(key, hd));
                break;
            }
            case 20480: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.HARDTOTALS_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.HARDTOTALS_DEVCAT);
                list.add(new HidHardTotalsHandleImp(key, hd));
                break;
            }
            case 21504: {
                if (this.reconnectHidDevice(list, hd.getSynchronizedHidDevice(), usbInterface, DevCats.CASHDRAWER_DEVCAT)) {
                    this.reconnectHidDevice(list, hd.getSynchronizedHidDevice(), usbInterface, DevCats.CASHDRAWER_DEVCAT);
                    break;
                }
                this.createCashDrawerHandleImps(hd, usage, list);
                break;
            }
            case 5120: {
                if (this.reconnectHidDevice(list, hd.getSynchronizedHidDevice(), usbInterface, DevCats.POSKEYBOARD_DEVCAT)) {
                    this.reconnectHidDevice(list, hd.getSynchronizedHidDevice(), usbInterface, DevCats.KEYLOCK_DEVCAT);
                    this.reconnectHidDevice(list, hd.getSynchronizedHidDevice(), usbInterface, DevCats.TONEINDICATOR_DEVCAT);
                    break;
                }
                number = this.getNumber(usage);
                productID = usbInterface.getUsbConfiguration().getUsbDevice().getUsbDeviceDescriptor().idProduct();
                key = new HidHandleKey(usage, number, DevCats.POSKEYBOARD_DEVCAT);
                list.add(new HidPOSKeyboardHandleImp(key, hd.getSynchronizedHidDevice(), this.getPOSKeyboardStrategyFactory().createLegacyModePOSKeyboardStrategy(POSKeyboardUtil.isDBCS(productID))));
                key = new HidHandleKey(usage, number, DevCats.KEYLOCK_DEVCAT);
                list.add(new HidKeylockHandleImp(key, hd.getSynchronizedHidDevice(), this.getKeylockStrategyFactory().createLegacyModeKbdKeylockStrategy()));
                key = new HidHandleKey(usage, number, DevCats.TONEINDICATOR_DEVCAT);
                if (POSKeyboardUtil.isSurepointDevice(usbInterface.getUsbConfiguration().getUsbDevice().getUsbDeviceDescriptor().idProduct())) {
                    list.add(new HidToneIndicatorHandleImp(key, hd.getSynchronizedHidDevice(), this.getToneIndicatorStrategyFactory().createLegacyModeSurepointToneStrategy()));
                    break;
                }
                if (18454 == usbInterface.getUsbConfiguration().getUsbDevice().getUsbDeviceDescriptor().idProduct()) {
                    list.add(new HidToneIndicatorHandleImp(key, hd.getSynchronizedHidDevice(), this.getToneIndicatorStrategyFactory().createLegacyMode485K03ToneStrategy()));
                    break;
                }
                list.add(new HidToneIndicatorHandleImp(key, hd.getSynchronizedHidDevice(), this.getToneIndicatorStrategyFactory().createLegacyModeKbdToneStrategy()));
                break;
            }
            case 5632: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.MSR_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.MSR_DEVCAT);
                list.add(new HidMSRHandleImp(key, hd, usbInterface.getUsbConfiguration().getUsbDevice().getUsbDeviceDescriptor().idProduct()));
                break;
            }
            case -24576: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.UNKNOWN_DEVCAT)) break;
                key = new HidHandleKey(usage, this.getNumber(usage), DevCats.UNKNOWN_DEVCAT);
                hidFlashHandleImp = new HidFlashHandleImp(key, hd);
                list.add(new HidFlashHandleImp(key, hd));
                list.add(hidFlashHandleImp);
                this.checkNonBootKbd(hidFlashHandleImp);
                break;
            }
            case 5376: {
                if (this.initializer.isSystemKeyboard(usbInterface.getUsbConfiguration().getUsbDevice())) {
                    if (this.reconnectHidDevice(list, hd.getSynchronizedHidDevice(), usbInterface, DevCats.POSKEYBOARD_DEVCAT)) {
                        this.reconnectHidDevice(list, hd.getSynchronizedHidDevice(), usbInterface, DevCats.KEYLOCK_DEVCAT);
                        this.reconnectHidDevice(list, hd.getSynchronizedHidDevice(), usbInterface, DevCats.TONEINDICATOR_DEVCAT);
                        break;
                    }
                    number = this.getNumber(usage);
                    productID = usbInterface.getUsbConfiguration().getUsbDevice().getUsbDeviceDescriptor().idProduct();
                    if (POSKeyboardUtil.isBootMode(productID)) {
                        this.createBootModeHandles(productID, hd, usage, list, number);
                        break;
                    }
                    this.createNonBootModeHandles(productID, hd, usage, list, number);
                    break;
                }
            }
            default: {
                hd.disconnect();
            }
        }
        return list;
    }

    private void checkNonBootKbd(HidFlashHandleImp hidFlashHandleImp) {
        Iterator iterator = this.handleImpTmpList.iterator();
        while (iterator.hasNext()) {
            HidPOSKeyboardHandleImp kbd;
            HidHandleImp current = (HidHandleImp)iterator.next();
            if (!(current instanceof HidBootModePOSKeyboardHandleImp) || !(kbd = (HidPOSKeyboardHandleImp)current).isNonBootModeOn()) continue;
            kbd.getHandleImpGroup().add(hidFlashHandleImp);
        }
    }

    protected void createNonBootModeHandles(short productId, HidDevice hd, int usage, List list, int number) {
        HidHandleKey key = new HidHandleKey(usage, number, DevCats.POSKEYBOARD_DEVCAT);
        HidBootModePOSKeyboardHandleImp bootModePOSKeyboardHandleImp = new HidBootModePOSKeyboardHandleImp(key, hd.getSynchronizedHidDevice(), this.getPOSKeyboardStrategyFactory().createNonBootModePOSKeyboardStrategy(POSKeyboardUtil.isDBCS(productId)));
        list.add(bootModePOSKeyboardHandleImp);
        key = new HidHandleKey(usage, number, DevCats.KEYLOCK_DEVCAT);
        list.add(new HidKeylockHandleImp(key, hd.getSynchronizedHidDevice(), this.getKeylockStrategyFactory().createNonBootModeKbdKeylockStrategy()));
        key = new HidHandleKey(usage, number, DevCats.TONEINDICATOR_DEVCAT);
        list.add(new HidToneIndicatorHandleImp(key, hd.getSynchronizedHidDevice(), this.getToneIndicatorStrategyFactory().createNonBootModeKbdToneStrategy()));
    }

    protected void createBootModeHandles(short productId, HidDevice hd, int usage, List list, int number) {
        HidHandleKey key = new HidHandleKey(usage, number, DevCats.POSKEYBOARD_DEVCAT);
        list.add(new HidBootModePOSKeyboardHandleImp(key, hd.getSynchronizedHidDevice(), this.getPOSKeyboardStrategyFactory().createBootModePOSKeyboardStrategy(POSKeyboardUtil.isDBCS(productId))));
        key = new HidHandleKey(usage, number, DevCats.KEYLOCK_DEVCAT);
        list.add(new HidKeylockHandleImp(key, hd.getSynchronizedHidDevice(), this.getKeylockStrategyFactory().createBootModeKbdKeylockStrategy()));
        key = new HidHandleKey(usage, number, DevCats.TONEINDICATOR_DEVCAT);
        list.add(new HidToneIndicatorHandleImp(key, hd.getSynchronizedHidDevice(), this.getToneIndicatorStrategyFactory().createBootModeKbdToneStrategy()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void createCashDrawerHandleImps(HidDevice hd, int usage, List list) {
        HidHandleKey key;
        if (this.tracer.isOn()) {
            this.tracer.println("->createCashDrawerHandleImps()");
        }
        final byte[] statusCmd = new byte[]{32};
        final ArrayList arrayList = new ArrayList();
        HidListener hL = new HidListener(){

            public void hidExceptionEventOccurred(HidExceptionEvent heE) {
            }

            public void hidDeviceDisconnected(DisconnectEvent dE) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reportEventOccurred(ReportEvent rE) {
                if (UsbHandleImpFactory.this.tracer.isOn() && rE.getData() != null) {
                    UsbHandleImpFactory.this.tracer.println(Util.toFormatedHexString((byte[])rE.getData()));
                }
                arrayList.add(rE.getData());
                byte[] byArray = statusCmd;
                synchronized (statusCmd) {
                    statusCmd.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        hd.addHidListener(hL);
        try {
            for (int i = 0; i < MAX_RETRIES; ++i) {
                byte[] byArray = statusCmd;
                // MONITORENTER : statusCmd
                hd.setReport((byte)2, (byte)0, (byte)statusCmd.length, statusCmd);
                try {
                    statusCmd.wait(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        catch (HidException he) {
            this.tracer.print((Exception)he);
        }
        finally {
            hd.removeHidListener(hL);
        }
        if (arrayList.isEmpty()) {
            if (!this.tracer.isOn()) return;
            this.tracer.println("No response for Cash Drawer, do not create Handles");
            return;
        }
        byte[] status = (byte[])arrayList.get(0);
        if (!PosjUtil.isBitSelected(status[0], 4)) {
            key = new HidHandleKey(usage, 0, DevCats.CASHDRAWER_DEVCAT);
            list.add(new HidCashDrawerHandleImp(key, hd, 1));
        }
        if (!PosjUtil.isBitSelected(status[0], 3)) {
            key = new HidHandleKey(usage, 1, DevCats.CASHDRAWER_DEVCAT);
            list.add(new HidCashDrawerHandleImp(key, hd, 2));
        }
        if (!this.tracer.isOn()) return;
        this.tracer.println("<-createCashDrawerHandleImps()");
    }

    protected List createGenericDesktopHandleImps(UsbInterface usbInterface, HidDevice hd, int usage) throws HidException {
        LinkedList<HidPOSKeyboardHandleImp> list = new LinkedList<HidPOSKeyboardHandleImp>();
        HidHandleKey key = null;
        switch ((short)usage) {
            case 6: {
                if (this.reconnectHidDevice(list, hd, usbInterface, DevCats.POSKEYBOARD_DEVCAT)) break;
                key = new HidHandleKey(this.getUsagePage(usage), this.getUsageID(usage), DevCats.POSKEYBOARD_DEVCAT);
                list.add(new HidPOSKeyboardHandleImp(key, hd, this.getPOSKeyboardStrategyFactory().createBootModePOSKeyboardStrategy(false)));
                break;
            }
            default: {
                hd.disconnect();
            }
        }
        return list;
    }

    protected int getUsage(HidDevice hd) throws HidException {
        byte[] report = null;
        int u = 0;
        int i = 0;
        report = hd.getDescriptor((byte)34, (byte)0);
        if (6 > report.length) {
            throw new HidException("Usage too short (length " + report.length + ")");
        }
        switch (report[i++]) {
            case 5: {
                u |= 0xFF0000 & report[i++] << 16;
                break;
            }
            case 6: {
                u |= 0xFF0000 & report[i++] << 16;
                u |= 0xFF000000 & report[i++] << 24;
                break;
            }
            default: {
                this.tracer.println("Invalid UsagePage prefix byte : " + report[i - 1] + "... Ignoring!!");
            }
        }
        switch (report[i++]) {
            case 9: {
                u |= 0xFF & report[i++];
                break;
            }
            case 10: {
                u |= 0xFF & report[i++];
                u |= 0xFF00 & report[i++] << 8;
                break;
            }
            default: {
                this.tracer.println("Invalid Usage ID prefix byte : " + report[i - 1] + "... Ignoring!!");
            }
        }
        return u;
    }

    protected short getUsagePage(int usage) {
        return (short)(usage >> 16);
    }

    protected short getUsageID(int usage) {
        return (short)(usage & 0xFFFF);
    }

    protected short getUsagePage(HidDevice hd) throws HidException {
        return this.getUsagePage(this.getUsage(hd));
    }

    protected short getUsageID(HidDevice hd) throws HidException {
        return this.getUsageID(this.getUsage(hd));
    }

    protected HidKeylockStrategy.Factory getKeylockStrategyFactory() {
        if (this.keylockStrategyFactory == null) {
            this.keylockStrategyFactory = new DefaultHidKeylockStrategy.Factory();
        }
        return this.keylockStrategyFactory;
    }

    protected HidToneIndicatorStrategy.Factory getToneIndicatorStrategyFactory() {
        if (this.toneStrategyFactory == null) {
            this.toneStrategyFactory = new DefaultHidToneIndicatorStrategy.Factory();
        }
        return this.toneStrategyFactory;
    }

    protected HidPOSKeyboardStrategy.Factory getPOSKeyboardStrategyFactory() {
        if (this.kbdStrategyFactory == null) {
            this.kbdStrategyFactory = new DefaultHidPOSKeyboardStrategy.Factory();
        }
        return this.kbdStrategyFactory;
    }

    protected boolean ignoreUsbInterface(UsbInterface usbInterface) {
        if (3 != usbInterface.getUsbInterfaceDescriptor().bInterfaceClass()) {
            return true;
        }
        return this.initializer.isSystemKeyboard(usbInterface.getUsbConfiguration().getUsbDevice()) && 0 == usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber();
    }

    private boolean reconnectPOSPrinter(List list, HidDevice hd, UsbInterface iface) {
        if (this.reconnectHidDevice(list, hd, iface, DevCats.POSPRINTER_DEVCAT)) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    Hid4610PrinterHandleImp h4phI = (Hid4610PrinterHandleImp)list.get(i);
                    Iterator iterator = h4phI.getSecondaryHandleImps();
                    while (iterator.hasNext()) {
                        HidHandleImp hhI = (HidHandleImp)iterator.next();
                        if (this.tracer.isOn()) {
                            this.tracer.println("Reusing HidHandleImp type " + hhI.getDevCat() + " from POSPrinter");
                        }
                        list.add(hhI);
                    }
                    continue;
                }
                catch (ClassCastException ccE) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    private List createPOSPrinterHandleImps(UsbInterface usbInterface, HidDevice hidDevice) throws HidException {
        AbstractHidHandleImp hi;
        String sn;
        Hid4610PrinterHandleImp h4phI;
        int number;
        int usage;
        LinkedList<AbstractHidHandleImp> list;
        HidDevice hd;
        block10: {
            hd = hidDevice.getUnsynchronizedHidDevice();
            UsbIDUtil.getInstance();
            if (!UsbIDUtil.isPrinterAdapterResetNeeded(usbInterface.getUsbConfiguration().getUsbDevice().getUsbDeviceDescriptor().bcdDevice())) {
                if (this.tracer.isOn()) {
                    this.tracer.println("Doing a Hid Read instead of reset the adapter");
                }
                hd.getReport((byte)3, PRINTER_REPORT_ID);
            }
            byte type = 99;
            try {
                type = this.areSubDevicesPresent(hd);
            }
            catch (Exception e) {
                // empty catch block
            }
            list = new LinkedList<AbstractHidHandleImp>();
            usage = this.getUsage(hd);
            number = this.getNumber(usage);
            HidHandleKey key = new HidHandleKey(usage, number, DevCats.POSPRINTER_DEVCAT);
            h4phI = new Hid4610PrinterHandleImp(key, hd, type);
            sn = "";
            try {
                sn = usbInterface.getUsbConfiguration().getUsbDevice().getSerialNumberString();
            }
            catch (Exception e) {
                if (!this.tracer.isOn()) break block10;
                this.tracer.println("Failed getting serial number before mod4 switch check");
                this.tracer.print(e);
            }
        }
        if (null != this.switched && this.switched.contains(sn)) {
            h4phI.setFormerMod4(true);
        }
        h4phI.setPrinterID_microcodeLevel(this.getPrinterID_microcodeLevel());
        list.add(h4phI);
        if (this.isMicrPresent) {
            HidHandleKey micrKey = new HidHandleKey(usage, number, DevCats.MICR_DEVCAT);
            IBM4610MICRImp micrLinker = new IBM4610MICRImp(micrKey, h4phI);
            HidPOSPrinterMICRHandleImp h4mhI = new HidPOSPrinterMICRHandleImp(micrKey, hd, micrLinker);
            micrLinker.setHandleImp(h4mhI);
            h4phI.addDevice(micrKey, micrLinker);
            list.add(h4mhI);
        }
        HidHandleKey cd1Key = new HidHandleKey(usage, this.cashDrawer4610DevNum++, DevCats.CASHDRAWER_DEVCAT);
        IBM4610CashDrawerImp cd1Linker = new IBM4610CashDrawerImp(cd1Key, h4phI, 1);
        HidPOSPrinterCashDrawerHandleImp h4cdhI1 = new HidPOSPrinterCashDrawerHandleImp(cd1Key, hd, cd1Linker);
        cd1Linker.setHandleImp(h4cdhI1);
        h4phI.addDevice(cd1Key, cd1Linker);
        list.add(h4cdhI1);
        HidHandleKey cd2Key = new HidHandleKey(usage, this.cashDrawer4610DevNum++, DevCats.CASHDRAWER_DEVCAT);
        IBM4610CashDrawerImp cd2Linker = new IBM4610CashDrawerImp(cd2Key, h4phI, 2);
        HidPOSPrinterCashDrawerHandleImp h4cdhI2 = new HidPOSPrinterCashDrawerHandleImp(cd2Key, hd, cd2Linker);
        cd2Linker.setHandleImp(h4cdhI2);
        h4phI.addDevice(cd2Key, cd2Linker);
        list.add(h4cdhI2);
        if (this.isTIPresent) {
            HidHandleKey tiKey = new HidHandleKey(usage, number, DevCats.TONEINDICATOR_DEVCAT);
            IBM4610SSTToneIndicatorImp ti = new IBM4610SSTToneIndicatorImp(h4phI);
            hi = new HidPOSPrinterToneIndicatorHandleImp(tiKey, hd, ti);
            h4phI.addDevice(tiKey, (PrinterSubDevices)((Object)hi));
            list.add(hi);
        }
        if (this.isCheckScannerPresent) {
            HidHandleKey csKey = new HidHandleKey(usage, number, DevCats.CHECKSCANNER_DEVCAT);
            IBM4610CheckScannerImp csLinker = new IBM4610CheckScannerImp(csKey, h4phI);
            hi = new HidPOSPrinterCheckScannerHandleImp(csKey, hd, csLinker);
            csLinker.setHandleImp(hi);
            h4phI.addDevice(csKey, csLinker);
            list.add(hi);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchMod4Emulation(HidDevice hd, String sn) throws HidException {
        if (null == this.switched) {
            this.switched = new ArrayList(1);
        }
        if (this.switched.size() > 0 && this.switched.contains(sn)) {
            return;
        }
        this.switched.add(sn);
        final BooleanMonitor flag = new BooleanMonitor(false);
        HidListener hL = new HidListener(){

            public void hidExceptionEventOccurred(HidExceptionEvent heE) {
            }

            public void hidDeviceDisconnected(DisconnectEvent dE) {
            }

            public void reportEventOccurred(ReportEvent rE) {
                if (UsbHandleImpFactory.this.tracer.isOn()) {
                    UsbHandleImpFactory.this.tracer.println(3, "MOD 4 Status " + Util.toFormatedHexString((byte[])rE.getData()));
                }
                flag.set(true);
            }
        };
        hd.addHidListener(hL);
        byte[] switch1 = new byte[]{2, 7, 0, 1, 0, 0, 0, 11, 32, 0};
        hd.setReport((byte)2, (byte)0, (short)switch1.length, switch1);
        byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        try {
            flag.waitForTrue(5000);
            data = hd.getReport((byte)3, (byte)0);
        }
        catch (Exception e) {
            this.tracer.print(e);
        }
        finally {
            hd.removeHidListener(hL);
        }
        if (data != null) {
            MOD4_MCT = new byte[]{data[7], data[8]};
            if (this.tracer.isOn()) {
                this.tracer.println(3, "MOD 4 MCT Bits " + Util.toFormatedHexString((byte[])MOD4_MCT));
            }
        }
        byte[] switch4 = new byte[]{2, 9, 0, 1, 0, 0, 0, 27, 77, 32, -1, -1};
        hd.setReport((byte)2, (byte)0, (short)switch4.length, switch4);
        SleepPolicy.sleep((long)7500L);
    }

    private void disableScanner(HidDevice hd) throws HidException {
        byte[] disableCmd = HidScannerHandleImp.DISABLE_SCANNER_CMD;
        final Vector list = new Vector();
        HidListener hL = new HidListener(){

            public void hidExceptionEventOccurred(HidExceptionEvent heE) {
                UsbHandleImpFactory.this.tracer.println("hidExceptionEventOccurred while disabling Scanner" + heE);
            }

            public void hidDeviceDisconnected(DisconnectEvent dE) {
                UsbHandleImpFactory.this.tracer.println("hidDeviceDisconnected while disabling Scanner");
                UsbHandleImpFactory.this.tracer.println((Object)dE.getHidException());
            }

            public void reportEventOccurred(ReportEvent rE) {
                list.add(rE);
                UsbHandleImpFactory.this.tracer.println("reportEventOccurred while disabling Scanner -- > " + Util.toFormatedHexString((byte[])rE.getData()));
            }
        };
        hd.addHidListener(hL);
        int count = 0;
        do {
            hd.setReport((byte)2, (byte)0, (short)disableCmd.length, disableCmd);
            ++count;
            try {
                if (list.size() != 0) continue;
                Thread.sleep(100L);
            }
            catch (InterruptedException iE) {
                // empty catch block
            }
        } while (0 == list.size() && count <= 3);
        this.tracer.println("disableScanner Listsize" + list.size() + " count " + count);
        hd.removeHidListener(hL);
    }

    private byte areSubDevicesPresent(HidDevice hd) throws HidException {
        byte[] resetCmd = new byte[]{2, 7, 0, 1, 0, 0, 0, 0, 64, 0};
        byte[] idRequest = new byte[]{2, 7, 0, 1, 0, 0, 0, 0, 0, 1};
        final Vector list = new Vector();
        int resetWaitTime = 5;
        int idWaitTime = 5;
        boolean gotStatus = false;
        int type = 0;
        int printermicrocodeLevel = -1;
        HidListener hL = new HidListener(){

            public void hidExceptionEventOccurred(HidExceptionEvent heE) {
            }

            public void hidDeviceDisconnected(DisconnectEvent dE) {
            }

            public void reportEventOccurred(ReportEvent rE) {
                list.add(rE);
            }
        };
        hd.addHidListener(hL);
        hd.setReport((byte)2, (byte)0, (short)resetCmd.length, resetCmd);
        do {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException iE) {
                // empty catch block
            }
        } while (0 == list.size() && 0 < resetWaitTime--);
        list.clear();
        hd.setReport((byte)2, (byte)0, (short)idRequest.length, idRequest);
        int printer_ID = -1;
        do {
            for (int i = 0; i < list.size(); ++i) {
                byte[] data = ((ReportEvent)list.get(i)).getData();
                if (13 >= data.length || 1 != (1 & data[9])) continue;
                data = hd.getReport((byte)3, (byte)0);
                if (this.tracer.isOn()) {
                    this.tracer.println(2, Util.toFormatedHexString((byte[])data));
                }
                gotStatus = true;
                if (0 == data[12]) {
                    throw new HidException("4610 TI1/2 not yet supported");
                }
                this.isMicrPresent = PosjUtil.isBitSelected(data[13], 0) || data[11] == 49;
                boolean bl = this.isTIPresent = data[12] == 3 || data[12] == 4 || data[12] == 7;
                if (data[11] == 49 || data[11] == 48 && PosjUtil.isBitSelected(data[14], 1)) {
                    type = 49;
                    if (PosjUtil.isBitSelected(data[14], 2)) {
                        if (PosjUtil.isBitSelected(data[14], 4)) {
                            printer_ID = 11;
                            this.isCheckScannerPresent = false;
                        } else {
                            printer_ID = 10;
                            this.isCheckScannerPresent = true;
                        }
                    } else {
                        printer_ID = 9;
                        this.isCheckScannerPresent = true;
                    }
                } else {
                    type = 48;
                    printer_ID = data[12];
                }
                this.printerID_microcodeLevel = -1;
                printermicrocodeLevel = data[15];
                this.printerID_microcodeLevel = printermicrocodeLevel | (printer_ID <<= 8);
                break;
            }
            if (gotStatus) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException iE) {
                // empty catch block
            }
        } while (!gotStatus && 0 < idWaitTime--);
        if (!gotStatus) {
            throw new HidException("Printer did not respond to ID request");
        }
        hd.removeHidListener(hL);
        return (byte)type;
    }

    private int getPrinterID_microcodeLevel() {
        return this.printerID_microcodeLevel;
    }

    private int getNumber(int usage) {
        Integer key = new Integer(usage);
        int number = 0;
        if (this.numberTable.containsKey(key)) {
            number = (Integer)this.numberTable.get(key);
            ++number;
        }
        this.numberTable.put(key, new Integer(number));
        return number;
    }

    private void addToTable(HidHandleImp hhi) {
        List list;
        String key = ((Object)hhi.getDevCat()).toString();
        if (!this.hidHandleImpTable.containsKey(key)) {
            this.hidHandleImpTable.put(key, new LinkedList());
        }
        if (!(list = (List)this.hidHandleImpTable.get(key)).contains(hhi)) {
            list.add(hhi);
        }
    }

    private boolean reconnectHidDevice(List reconnectList, HidDevice hd, UsbInterface iface, DevCat dc) {
        String key = ((Object)dc).toString();
        if (!this.hidHandleImpTable.containsKey(key)) {
            return false;
        }
        List list = (List)this.hidHandleImpTable.get(key);
        for (int i = 0; i < list.size(); ++i) {
            HidHandleImp hhi = (HidHandleImp)list.get(i);
            boolean online = false;
            try {
                online = hhi.getHandle().isOnline();
            }
            catch (NullPointerException npE) {
                continue;
            }
            String sn = hhi.getSerialNumber();
            if (null == sn) {
                sn = "";
            }
            try {
                String newSn = iface.getUsbConfiguration().getUsbDevice().getSerialNumberString();
                if (this.tracer.isOn()) {
                    this.tracer.println("Handle=" + hhi.getHandle().getName() + " (S/N:'" + sn + "', isOnline=" + online + ")");
                    this.tracer.println(3, "new UsbDevice S/N:'" + newSn + "'");
                }
                if (online || !sn.equals(newSn)) continue;
                this.tracer.println("Reconnecting interface to existing " + hhi.getDevCat() + " type Handle");
                try {
                    hhi.reattachHidDevice(hd);
                    reconnectList.add(hhi);
                    return true;
                }
                catch (HandleException hE) {
                    this.tracer.println("Could not reconnect interface to existing Handle : " + hE.getMessage());
                    return false;
                }
            }
            catch (Exception e) {
                this.tracer.println("Could not access serial number string" + e.getMessage());
                return false;
            }
        }
        return false;
    }

    private boolean isKnownPosDevice(UsbDevice device) {
        return UsbIDUtil.getInstance().isKnownPosDevice(device.getUsbDeviceDescriptor().idVendor(), device.getUsbDeviceDescriptor().idProduct());
    }
}

