/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.rs232;

import com.ibm.jutil.ByteBuffer;
import com.ibm.jutil.Timer;
import com.ibm.jutil.Timerable;
import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.bus.rs232.javaxcomm.Rs232PortCommAdapter;
import com.ibm.rs232.Rs232Port;
import com.ibm.rs232.event.Rs232DataEvent;
import java.io.IOException;
import java.io.InputStream;

public class Rs232MSRReader
implements Rs232PortCommAdapter.DataReaderStrategy {
    private ByteBuffer byteBuffer = new ByteBuffer();
    private boolean timerExpired = true;
    private Tracer tracer = TracerFactory.getInstance().createTracer("MSR", "Rs232MSRReader");
    public static int TIMEOUT = 350;

    public void dataAvailable(InputStream is, Rs232Port.EventHelper helper) {
        try {
            Thread.currentThread();
            Thread.sleep(TIMEOUT);
        }
        catch (InterruptedException iE) {
            // empty catch block
        }
        try {
            int bytesAvailable = is.available();
            while (bytesAvailable > 0) {
                byte[] data = new byte[bytesAvailable];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (byte)is.read();
                }
                if (this.tracer.isOn()) {
                    this.tracer.println("Data available [" + data.length + "]" + Util.toFormatedHexString((byte[])data));
                }
                this.process(data, helper);
                bytesAvailable = is.available();
            }
        }
        catch (IOException ioE) {
            if (this.tracer.isOn()) {
                this.tracer.println("Error Occurred while getting MSR data :");
            }
            this.tracer.println((Object)ioE);
        }
    }

    protected void process(byte[] data, final Rs232Port.EventHelper helper) {
        if (this.timerExpired) {
            if (this.tracer.isOn()) {
                this.tracer.println("time expired start again");
            }
            this.timerExpired = false;
            this.byteBuffer.reset();
            this.byteBuffer.append(data);
            Timer timer = new Timer(new Timerable(){

                public void timerExpired() {
                    if (Rs232MSRReader.this.tracer.isOn()) {
                        Rs232MSRReader.this.tracer.println("timerExpired!");
                    }
                    Rs232MSRReader.this.timerExpired = true;
                    helper.fireDataEvent(new Rs232DataEvent(this, Rs232MSRReader.this.byteBuffer.getBytes()));
                }
            });
            timer.setTime(TIMEOUT + 100);
            timer.start();
            return;
        }
        if (this.tracer.isOn()) {
            this.tracer.println("add to previous data");
        }
        this.byteBuffer.append(data);
    }
}

