/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.printer.parser.ibm4689;

import com.ibm.jutil.ByteBuffer;
import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.bus.printer.cmds.ibm4689.Cmd4689;
import com.ibm.posj.printer.parser.PrinterParserLine;
import com.ibm.posj.printer.parser.ibm4689.Printer4689ParserLine;
import com.ibm.posj.printer.parser.ibm4689.Printer4689PropertiesManager;
import java.util.List;

public class Printer4689ParserRotate {
    private PrinterParserLine.AlignedText lfLine;
    private PrinterParserLine.AlignedText ctLine;
    private PrinterParserLine.AlignedText rtLine;
    private Printer4689PropertiesManager propMgr;
    private Cmd4689 cmdBytes = new Cmd4689();
    ByteBuffer lineMasterText = ByteBuffer.getByteBufferFactory().createByteBuffer();
    private boolean isbld = false;
    private boolean isurl = false;
    private boolean isDhi = false;
    private boolean isDwi = false;
    private boolean isDhw = false;
    private boolean isNml = false;
    private boolean isReV = false;
    private boolean dWide = false;
    private boolean dHigh = false;
    private boolean LFlag = false;
    private int Xval;
    private int Yval;
    boolean[] High;
    private static String bytemask = new String("-");
    private static String space = new String("20 ");
    private static Tracer tracer = TracerFactory.getInstance().createTracer("4689Rotate");

    public Printer4689ParserRotate(int X, int Y) {
        this.Xval = X;
        this.Yval = Y + 1;
    }

    public void add(Printer4689ParserLine line) {
        List alignedElement;
        if (Printer4689ParserRotate.getTracer().isOn()) {
            Printer4689ParserRotate.getTracer().println(2, "--> add()");
        }
        this.lfLine = line.getLeftText();
        this.ctLine = line.getCenterText();
        this.rtLine = line.getRightText();
        if (this.lfLine.isTextPresent()) {
            alignedElement = ((Printer4689ParserLine.IBM4689AlignedText)this.lfLine).getElemList();
            if (Printer4689ParserRotate.getTracer().isOn()) {
                Printer4689ParserRotate.getTracer().println(2, "Left has text and its size is -> " + alignedElement.size());
            }
            this.appendBuffer(alignedElement);
        }
        if (this.ctLine.isTextPresent()) {
            alignedElement = ((Printer4689ParserLine.IBM4689AlignedText)this.ctLine).getElemList();
            if (Printer4689ParserRotate.getTracer().isOn()) {
                Printer4689ParserRotate.getTracer().println(2, "Center has text and its size is -> " + alignedElement.size());
            }
            this.appendBuffer(alignedElement);
        }
        if (this.rtLine.isTextPresent()) {
            alignedElement = ((Printer4689ParserLine.IBM4689AlignedText)this.rtLine).getElemList();
            if (Printer4689ParserRotate.getTracer().isOn()) {
                Printer4689ParserRotate.getTracer().println(2, "Right has text and its size is -> " + alignedElement.size());
            }
            this.appendBuffer(alignedElement);
        }
        if (this.lineMasterText.getByteCount() != 0 && this.LFlag) {
            this.lineMasterText.append((byte)-1);
            this.LFlag = false;
        }
    }

    public ByteBuffer getBuffer() {
        return this.rotate();
    }

    public static Tracer getTracer() {
        return tracer;
    }

    private void appendBuffer(List alignedElement) {
        for (int i = 0; i < alignedElement.size(); ++i) {
            ByteBuffer tempBuffer = ByteBuffer.getByteBufferFactory().createByteBuffer();
            tempBuffer.replace(((Printer4689ParserLine.LineElement)alignedElement.get(i)).getText().getBytes());
            this.propMgr = ((Printer4689ParserLine.LineElement)alignedElement.get(i)).getPropMngr();
            if (((Printer4689ParserLine.LineElement)alignedElement.get(i)).getElementType() == 1) {
                int textLength = ((Printer4689ParserLine.LineElement)alignedElement.get(i)).getText().getByteCount();
                if (Printer4689ParserRotate.getTracer().isOn()) {
                    Printer4689ParserRotate.getTracer().println(2, "Element is TEXT type and its size is -> " + textLength);
                }
                for (int x = 0; x < textLength; ++x) {
                    this.LFlag = true;
                    if (this.propMgr.isBold()) {
                        this.lineMasterText.append(this.cmdBytes.EMPHASIZE_MODE);
                    }
                    if (this.propMgr.isUnderline()) {
                        this.lineMasterText.append(this.cmdBytes.UNDERLINE_MODE);
                    }
                    if (this.propMgr.isDoubleHigh() && !this.propMgr.isDoubleWide()) {
                        this.lineMasterText.append(this.cmdBytes.DOUBLE_HIGH_MODE);
                    }
                    if (this.propMgr.isDoubleWide()) {
                        this.dWide = true;
                        if (!this.propMgr.isDoubleHigh()) {
                            this.lineMasterText.append(this.cmdBytes.DOUBLE_WIDE_MODE);
                        }
                    }
                    if (this.propMgr.isDoubleHighWide()) {
                        this.lineMasterText.append(this.cmdBytes.DOUBLE_HIGH_WIDE_MODE);
                    }
                    if (this.propMgr.isNormalMode()) {
                        this.lineMasterText.append(this.cmdBytes.NORMAL_MODE);
                    }
                    if (this.propMgr.isReverseVideo()) {
                        this.lineMasterText.append(this.cmdBytes.REVERSE_VIDEO);
                    }
                    this.lineMasterText.append(tempBuffer.byteAt(x));
                    if (!this.dWide) continue;
                    this.lineMasterText.append(" ".getBytes());
                    this.dWide = false;
                }
            }
            tempBuffer.recycle();
        }
    }

    private String getFilter(String cmd) {
        String filter = new String();
        filter = cmd.replaceAll(space, bytemask);
        return filter;
    }

    private String getMask(int Xval) {
        String mask = new String();
        mask = mask.concat("[14]");
        for (int x = 0; x < Xval; ++x) {
            mask = mask.concat(bytemask);
        }
        return mask;
    }

    private ByteBuffer rotate() {
        int y;
        int x;
        int index = 0;
        ByteBuffer charRotated = ByteBuffer.getByteBufferFactory().createByteBuffer();
        ByteBuffer[][] matrix = new ByteBuffer[this.Xval][this.Yval];
        ByteBuffer cmdLine = ByteBuffer.getByteBufferFactory().createByteBuffer();
        this.High = new boolean[this.Yval];
        for (x = 0; x < this.Xval; ++x) {
            for (y = 0; y < this.Yval; ++y) {
                matrix[x][y] = ByteBuffer.getByteBufferFactory().createByteBuffer();
            }
        }
        if (Printer4689ParserRotate.getTracer().isOn()) {
            Printer4689ParserRotate.getTracer().println(2, "--> rotate()");
        }
        if (Printer4689ParserRotate.getTracer().isOn()) {
            Printer4689ParserRotate.getTracer().println(2, "createBuffer size: " + this.lineMasterText.getByteCount());
        }
        if (Printer4689ParserRotate.getTracer().isOn()) {
            Printer4689ParserRotate.getTracer().println(3, "buffer ->" + Util.toFormatedHexString((byte[])this.lineMasterText.getBytes()));
        }
        for (x = this.Xval - 1; x >= 0; --x) {
            for (y = 0; y < this.Yval; ++y) {
                if (this.lineMasterText.getByteCount() == index) {
                    matrix[x][y].append(" ".getBytes());
                    continue;
                }
                charRotated.reset();
                while (this.lineMasterText.byteAt(index) == 27) {
                    if (this.lineMasterText.byteAt(index + 2) == 16) {
                        this.isbld = true;
                    } else if (this.lineMasterText.byteAt(index + 2) == 2) {
                        this.isurl = true;
                    } else if (this.lineMasterText.byteAt(index + 2) == -128) {
                        this.isDhi = true;
                    } else if (this.lineMasterText.byteAt(index + 2) == 64) {
                        this.isDwi = true;
                    } else if (this.lineMasterText.byteAt(index + 2) == -64) {
                        this.isDhw = true;
                    } else if (this.lineMasterText.byteAt(index + 2) == 0) {
                        this.isNml = true;
                    } else if (this.lineMasterText.byteAt(index + 2) == 32) {
                        this.isReV = true;
                    }
                    index += 3;
                }
                if (this.isbld) {
                    charRotated.append(this.cmdBytes.EMPHASIZE_MODE);
                    this.isbld = false;
                } else if (this.isurl) {
                    charRotated.append(this.cmdBytes.UNDERLINE_MODE);
                    this.isurl = false;
                } else if (this.isDhi) {
                    charRotated.append(this.cmdBytes.DOUBLE_HIGH_MODE);
                    this.isDhi = false;
                    this.dHigh = true;
                } else if (this.isDwi) {
                    charRotated.append(this.cmdBytes.DOUBLE_WIDE_MODE);
                    this.isDwi = false;
                } else if (this.isDhw) {
                    charRotated.append(this.cmdBytes.DOUBLE_HIGH_WIDE_MODE);
                    this.isDhw = false;
                    this.dHigh = true;
                } else if (this.isNml) {
                    charRotated.append(this.cmdBytes.NORMAL_MODE);
                    this.isNml = false;
                } else if (this.isReV) {
                    charRotated.append(this.cmdBytes.REVERSE_VIDEO);
                    this.isReV = false;
                }
                if (this.lineMasterText.byteAt(index) == -1) {
                    charRotated.append(" ".getBytes());
                    for (int z = y; z < this.Yval; ++z) {
                        matrix[x][z].append(charRotated.getBytes());
                    }
                    ++index;
                    if (y != 0) {
                        y = this.Yval;
                        continue;
                    }
                    --y;
                    continue;
                }
                charRotated.append(this.lineMasterText.byteAt(index));
                if (this.dHigh) {
                    this.High[y] = this.dHigh;
                    this.dHigh = false;
                } else {
                    charRotated.append(this.cmdBytes.NORMAL_MODE);
                }
                matrix[x][y].append(charRotated.getBytes());
                ++index;
            }
        }
        charRotated.recycle();
        String tmp = new String();
        cmdLine.append(this.cmdBytes.MULTI_LINE_MODE);
        cmdLine.append(this.cmdBytes.ROTATE_CHARS90);
        cmdLine.append(this.cmdBytes.FEED_LINE_4689);
        for (y = 0; y < this.Yval; ++y) {
            ByteBuffer cmd = ByteBuffer.getByteBufferFactory().createByteBuffer();
            for (int x2 = 0; x2 < this.Xval; ++x2) {
                cmd.append(matrix[x2][y].getBytes());
            }
            ByteBuffer tmpHigh = ByteBuffer.getByteBufferFactory().createByteBuffer();
            if (this.High[y]) {
                for (int h = 0; h < cmd.getByteCount(); ++h) {
                    int z;
                    if (cmd.byteAt(h) != 27 || cmd.byteAt(h + 2) != -128 && cmd.byteAt(h + 2) != -64) continue;
                    for (z = 1; z < h; ++z) {
                        tmpHigh.append(cmd.byteAt(z));
                    }
                    for (z = h; z < cmd.getByteCount(); ++z) {
                        tmpHigh.append(cmd.byteAt(z));
                        if (z != h + 3) continue;
                        tmpHigh.append(" ".getBytes());
                    }
                }
                cmd.replace(tmpHigh.getBytes());
                tmpHigh.recycle();
            }
            if (Printer4689ParserRotate.getTracer().isOn()) {
                Printer4689ParserRotate.getTracer().println(3, "Rotated Column -> " + Util.toFormatedHexString((byte[])cmd.getBytes()));
            }
            if ((tmp = this.getFilter(Util.toFormatedHexString((byte[])cmd.getBytes()))).compareTo(this.getMask(this.Xval)) != 0) {
                cmdLine.append(cmd.getBytes());
                cmdLine.append(this.cmdBytes.FEED_LINE_4689);
            }
            cmd.recycle();
        }
        for (int x3 = 0; x3 < this.Xval; ++x3) {
            for (int y2 = 0; y2 < this.Yval; ++y2) {
                matrix[x3][y2].recycle();
            }
        }
        this.lineMasterText.reset();
        if (Printer4689ParserRotate.getTracer().isOn()) {
            Printer4689ParserRotate.getTracer().println(3, "RotBuffer ->" + Util.toFormatedHexString((byte[])cmdLine.getBytes()));
        }
        if (Printer4689ParserRotate.getTracer().isOn()) {
            Printer4689ParserRotate.getTracer().println(2, "<-- rotate()");
        }
        return cmdLine;
    }
}

