/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.util.FileWatcher;

public class ConfiguratonFileWatcher
implements FileWatcher {
    private final Reconfigurable reconfigurable;
    private final List<ConfigurationListener> configurationListeners;

    public ConfiguratonFileWatcher(Reconfigurable reconfigurable, List<ConfigurationListener> configurationListeners) {
        this.reconfigurable = reconfigurable;
        this.configurationListeners = configurationListeners;
    }

    public List<ConfigurationListener> getListeners() {
        return this.configurationListeners;
    }

    @Override
    public void fileModified(File file) {
        for (ConfigurationListener configurationListener : this.configurationListeners) {
            LoggerContext.getContext(false).submitDaemon(new ReconfigurationRunnable(configurationListener, this.reconfigurable));
        }
    }

    private static class ReconfigurationRunnable
    implements Runnable {
        private final ConfigurationListener configurationListener;
        private final Reconfigurable reconfigurable;

        public ReconfigurationRunnable(ConfigurationListener configurationListener, Reconfigurable reconfigurable) {
            this.configurationListener = configurationListener;
            this.reconfigurable = reconfigurable;
        }

        @Override
        public void run() {
            this.configurationListener.onChange(this.reconfigurable);
        }
    }
}

