/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbHubImp;
import com.ibm.jusb.UsbPortImp;
import com.ibm.jusb.os.AbstractUsbServices;
import com.ibm.jusb.os.windows.JavaxUsb;
import com.ibm.jusb.os.windows.WindowsDeviceOsImp;
import com.ibm.jusb.os.windows.WindowsDeviceProxy;
import com.ibm.jusb.os.windows.util.WindowsUsbTracer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;
import javax.usb.event.UsbServicesEvent;

public class WindowsUsbServices
extends AbstractUsbServices
implements UsbServices {
    public static final String COULD_NOT_ACCESS_USB_SUBSYSTEM = "Could not access USB subsystem.";
    public static final String NATIVE_TRACE_LEVEL = "com.ibm.jusb.os.windows.WindowsUsbServices.nativetracelevel";
    private Thread topologyMonitor = null;
    private int topologyMonitorError = 0;
    private Object topologyLock = new Object();
    private int topologyUpdateResult = 0;
    private List addedDevices = null;
    private List removedDevices = null;

    public WindowsUsbServices() throws UsbException {
        JavaxUsb.loadLibrary();
        this.checkProperties();
    }

    public String getApiVersion() {
        return "1.0.5";
    }

    public String getImpVersion() {
        return "1.0.5";
    }

    public String getImpDescription() {
        return "javax.usb Implementation for Windows 2000 and XP.\n\n*\n* Copyright (c) 2005, International Business Machines Corporation.\n* All Rights Reserved.\n*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UsbHub getRootUsbHub() throws UsbException {
        if (!this.isListening()) {
            Object object = this.topologyLock;
            synchronized (object) {
                this.startTopologyMonitor();
                try {
                    this.topologyLock.wait();
                }
                catch (InterruptedException iE) {
                    throw new UsbException("Interrupted while enumerating USB devices, try again");
                }
            }
        }
        if (0 != this.topologyMonitorError) {
            throw new UsbException("Could not access USB subsystem. : " + this.topologyMonitorError);
        }
        if (0 != this.topologyUpdateResult) {
            throw new UsbException("Could not access USB subsystem. : " + this.topologyUpdateResult);
        }
        return this.getRootUsbHubImp();
    }

    private void checkProperties() {
        Properties p = null;
        try {
            p = UsbHostManager.getProperties();
        }
        catch (Exception e) {
            return;
        }
        try {
            JavaxUsb.native_log_settings = 0;
            if (p.containsKey(NATIVE_TRACE_LEVEL)) {
                String val = p.getProperty(NATIVE_TRACE_LEVEL).trim();
                JavaxUsb.native_log_settings = WindowsUsbTracer.getIntTraceLevel(val);
            }
            JavaxUsb.nativeSetTraceData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disconnectDevice(UsbDeviceImp device) {
        device.disconnect();
        try {
            ((WindowsDeviceOsImp)device.getUsbDeviceOsImp()).getWindowsDeviceProxy().stop();
            ((WindowsDeviceOsImp)device.getUsbDeviceOsImp()).releaseWindowsDeviceProxy();
        }
        catch (UsbException usbException) {
            // empty catch block
        }
    }

    private void fireDeviceConnectedEvent(UsbDeviceImp device) {
        this.listenerImp.usbDeviceAttached(new UsbServicesEvent((UsbServices)this, (UsbDevice)device));
    }

    private boolean isListening() {
        try {
            return this.topologyMonitor.isAlive();
        }
        catch (NullPointerException npE) {
            return false;
        }
    }

    private void startTopologyMonitor() {
        Runnable r = new Runnable(){

            public void run() {
                WindowsUsbServices.this.topologyMonitorExit(JavaxUsb.nativeTopologyMonitor(WindowsUsbServices.this));
            }
        };
        this.topologyMonitor = new Thread(r);
        this.topologyMonitor.setDaemon(true);
        this.topologyMonitor.setName("javax.usb Windows implementation Topology Listener");
        this.topologyMonitorError = 0;
        this.topologyMonitor.start();
    }

    private void topologyChange() {
        this.updateTopology();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topologyMonitorExit(int error) {
        this.topologyMonitorError = error;
        Object object = this.topologyLock;
        synchronized (object) {
            this.topologyLock.notifyAll();
        }
    }

    private void fillDeviceList(UsbDeviceImp device, List list) {
        list.add(device);
        if (device.isUsbHub()) {
            UsbHubImp hub = (UsbHubImp)device;
            Iterator iterator = hub.getAttachedUsbDevices().iterator();
            while (iterator.hasNext()) {
                this.fillDeviceList((UsbDeviceImp)iterator.next(), list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTopology() {
        UsbDeviceImp device;
        int i;
        this.addedDevices = new ArrayList();
        this.removedDevices = new ArrayList();
        this.fillDeviceList((UsbDeviceImp)this.getRootUsbHubImp(), this.removedDevices);
        this.removedDevices.remove(this.getRootUsbHubImp());
        this.topologyUpdateResult = JavaxUsb.nativeTopologyBuilder(this);
        for (i = 0; i < this.removedDevices.size(); ++i) {
            device = (UsbDeviceImp)this.removedDevices.get(i);
            device.getParentUsbPortImp().detachUsbDeviceImp(device);
            this.disconnectDevice(device);
        }
        for (i = 0; i < this.addedDevices.size(); ++i) {
            device = (UsbDeviceImp)this.addedDevices.get(i);
            try {
                device.getParentUsbPortImp().attachUsbDeviceImp(device);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (i = 0; i < this.removedDevices.size(); ++i) {
            this.listenerImp.usbDeviceDetached(new UsbServicesEvent((UsbServices)this, (UsbDevice)this.removedDevices.get(i)));
        }
        for (i = 0; i < this.addedDevices.size(); ++i) {
            this.listenerImp.usbDeviceAttached(new UsbServicesEvent((UsbServices)this, (UsbDevice)this.addedDevices.get(i)));
        }
        Object object = this.topologyLock;
        synchronized (object) {
            this.topologyLock.notifyAll();
        }
    }

    private UsbDeviceImp checkUsbDeviceImp(UsbHubImp hub, int p, UsbDeviceImp device) {
        byte port = (byte)p;
        UsbPortImp usbPortImp = hub.getUsbPortImp(port);
        if (null == usbPortImp) {
            hub.resize((int)port);
            usbPortImp = hub.getUsbPortImp(port);
        }
        if (!usbPortImp.isUsbDeviceAttached()) {
            this.addedDevices.add(device);
            device.setParentUsbPortImp(usbPortImp);
            return device;
        }
        UsbDeviceImp existingDevice = usbPortImp.getUsbDeviceImp();
        if (this.isUsbDevicesEqual(existingDevice, device)) {
            this.removedDevices.remove(existingDevice);
            if (existingDevice != device) {
                try {
                    ((WindowsDeviceOsImp)device.getUsbDeviceOsImp()).getWindowsDeviceProxy().stop();
                    ((WindowsDeviceOsImp)device.getUsbDeviceOsImp()).releaseWindowsDeviceProxy();
                }
                catch (UsbException e) {
                    // empty catch block
                }
            }
            return existingDevice;
        }
        this.addedDevices.add(device);
        device.setParentUsbPortImp(usbPortImp);
        return device;
    }

    protected boolean isUsbDevicesEqual(UsbDeviceImp dev1, UsbDeviceImp dev2) {
        try {
            WindowsDeviceProxy wdp2;
            WindowsDeviceProxy wdp1;
            UsbDeviceDescriptor desc1 = dev1.getUsbDeviceDescriptor();
            UsbDeviceDescriptor desc2 = dev2.getUsbDeviceDescriptor();
            try {
                wdp1 = ((WindowsDeviceOsImp)dev1.getUsbDeviceOsImp()).getWindowsDeviceProxy();
                wdp2 = ((WindowsDeviceOsImp)dev2.getUsbDeviceOsImp()).getWindowsDeviceProxy();
            }
            catch (UsbException e) {
                return false;
            }
            return dev1.isUsbHub() == dev1.isUsbHub() && dev1.getSpeed() == dev2.getSpeed() && wdp1.getKey().compareToIgnoreCase(wdp2.getKey()) == 0;
        }
        catch (NullPointerException npE) {
            return false;
        }
    }
}

