/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poskbd.bus.ps2;

import com.ibm.jutil.RunnableManager;
import com.ibm.pattern.Recyclable;
import com.ibm.pattern.RecycleFactory;
import com.ibm.pattern.Recycler;
import com.ibm.poskbd.bus.ps2.PS2FunctionImp;
import com.ibm.poskbd.bus.ps2.PS2PS2Command;
import com.ibm.poskbd.bus.ps2.PS2Proxy;
import com.ibm.poskbd.bus.ps2.PosKbd;

public class PS2PS2Proxy
extends PS2Proxy {
    private PS2FunctionImp ps2FunctionImp = null;
    private Runnable ps2Runnable = new Runnable(){

        public void run() {
            PosKbd.startPS2(PS2PS2Proxy.this);
        }
    };
    private Object commandLock = new Object();
    private PS2PS2Command ps2PS2Command = null;
    private boolean commandWaiting = false;
    private RunnableManager runnableManager = new RunnableManager(true);
    private Recycler kbdRunnables = new KbdRunnableFactory();
    private Recycler msrRunnables = new MsrRunnableFactory();
    private static final int COMMAND_TIMEOUT = 1;

    public PS2PS2Proxy(PS2FunctionImp function) {
        this.ps2FunctionImp = function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeCommand(PS2PS2Command command) {
        if (!this.isRunning()) {
            throw new RuntimeException("Proxy is not running");
        }
        Object object = this.commandLock;
        synchronized (object) {
            this.ps2PS2Command = command;
            this.commandWaiting = true;
            this.commandLock.notifyAll();
            while (this.commandWaiting) {
                try {
                    this.commandLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected String getProxyName() {
        return "PS2PS2Proxy Thread";
    }

    protected Runnable getProxyRunnable() {
        return this.ps2Runnable;
    }

    protected void processKbdStatus(byte[] status, int length) {
        if (length > status.length) {
            length = status.length;
        }
        byte[] newStatus = new byte[length];
        System.arraycopy(status, 0, newStatus, 0, length);
        KbdRunnable kbdRunnable = (KbdRunnable)this.kbdRunnables.takeRecyclable();
        kbdRunnable.setScancodes(newStatus);
        this.runnableManager.add((Runnable)kbdRunnable);
    }

    protected void processMsrData(byte[] data, int length) {
        if (length > data.length) {
            length = data.length;
        }
        byte[] newData = new byte[length];
        System.arraycopy(data, 0, newData, 0, length);
        MsrRunnable msrRunnable = (MsrRunnable)this.msrRunnables.takeRecyclable();
        msrRunnable.setData(newData);
        this.runnableManager.add((Runnable)msrRunnable);
    }

    protected boolean verifyLibLoaded() {
        return PosKbd.loadLib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPS2Command() {
        Object object = this.commandLock;
        synchronized (object) {
            try {
                this.commandLock.wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.commandWaiting) {
                this.ps2PS2Command.execute();
                this.commandWaiting = false;
                this.commandLock.notifyAll();
            }
        }
    }

    private class MsrRunnableFactory
    extends RecycleFactory {
        private MsrRunnableFactory() {
        }

        protected Recyclable createRecyclable() {
            return new MsrRunnable(this){
                private final /* synthetic */ MsrRunnableFactory this$1;
                {
                    this.this$1 = this$1;
                }

                public void recycle() {
                    MsrRunnableFactory.access$800(this.this$1, this);
                }
            };
        }

        static /* synthetic */ PS2PS2Proxy access$700(MsrRunnableFactory x0) {
            return x0.PS2PS2Proxy.this;
        }

        static /* synthetic */ void access$800(MsrRunnableFactory x0, Recyclable x1) {
            x0.returnRecyclable(x1);
        }
    }

    private class KbdRunnableFactory
    extends RecycleFactory {
        private KbdRunnableFactory() {
        }

        protected Recyclable createRecyclable() {
            return new KbdRunnable(this){
                private final /* synthetic */ KbdRunnableFactory this$1;
                {
                    this.this$1 = this$1;
                }

                public void recycle() {
                    KbdRunnableFactory.access$500(this.this$1, this);
                }
            };
        }

        static /* synthetic */ PS2PS2Proxy access$400(KbdRunnableFactory x0) {
            return x0.PS2PS2Proxy.this;
        }

        static /* synthetic */ void access$500(KbdRunnableFactory x0, Recyclable x1) {
            x0.returnRecyclable(x1);
        }
    }

    private abstract class MsrRunnable
    implements Runnable,
    Recyclable {
        private byte[] data = null;

        private MsrRunnable() {
        }

        public void run() {
            PS2PS2Proxy.this.ps2FunctionImp.fireMsrData(this.getData());
            this.recycle();
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] d) {
            this.data = d;
        }

        public void clean() {
            this.setData(null);
        }
    }

    private abstract class KbdRunnable
    implements Runnable,
    Recyclable {
        private byte[] scancodes = null;

        private KbdRunnable() {
        }

        public void run() {
            PS2PS2Proxy.this.ps2FunctionImp.fireKbdStatus(this.getScancodes());
            this.recycle();
        }

        public byte[] getScancodes() {
            return this.scancodes;
        }

        public void setScancodes(byte[] sc) {
            this.scancodes = sc;
        }

        public void clean() {
            this.setScancodes(null);
        }
    }
}

