/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poskbd.bus.ps2;

import com.ibm.jutil.Util;
import com.ibm.poskbd.ClickCmd;
import com.ibm.poskbd.KeyboardDevInfo;
import com.ibm.poskbd.LedCmd;
import com.ibm.poskbd.Leds;
import com.ibm.poskbd.MsrTracks;
import com.ibm.poskbd.ToneCmd;
import com.ibm.poskbd.TrapKeys;
import com.ibm.poskbd.bus.ps2.PS2PS2Command;
import com.ibm.poskbd.bus.ps2.PS2PS2Proxy;
import com.ibm.poskbd.bus.ps2.PS2SnifferProxy;

public class PosKbd {
    public static byte UNKNOWN = 0;
    public static byte SUCCESS = 1;
    public static byte FAILED = (byte)2;
    public static byte KBDLoaded = UNKNOWN;
    private static final String POSKBD_LIBRARY = "PosKbd";
    private static final long SET_LED_DELAY = 750L;

    private PosKbd() {
    }

    public static boolean loadLib() {
        if (KBDLoaded == UNKNOWN) {
            try {
                System.loadLibrary(POSKBD_LIBRARY);
                KBDLoaded = SUCCESS;
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                KBDLoaded = FAILED;
            }
        }
        return KBDLoaded == SUCCESS;
    }

    static void startSniffer(PS2SnifferProxy proxy) {
        if (!PosKbd.loadLib()) {
            return;
        }
        PosKbd.nativeSniffer(proxy);
    }

    static void startPS2(PS2PS2Proxy proxy) {
        if (!PosKbd.loadLib()) {
            return;
        }
        PosKbd.nativePS2(proxy);
    }

    static Leds getLeds() {
        if (!PosKbd.loadLib()) {
            return null;
        }
        PosKbdLeds leds = new PosKbdLeds();
        PosKbd.nativeGetLeds(leds);
        return leds;
    }

    static void setLeds(Leds leds) {
        if (!PosKbd.loadLib()) {
            return;
        }
        PosKbdLeds pleds = new PosKbdLeds();
        pleds.capsLock = leds.getCapsLock();
        pleds.numLock = leds.getNumLock();
        pleds.scrollLock = leds.getScrollLock();
        PosKbd.nativeSetLeds(pleds);
        try {
            Thread.currentThread();
            Thread.sleep(750L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static native void nativeSniffer(PS2SnifferProxy var0);

    private static native void nativePS2(PS2PS2Proxy var0);

    private static native void nativeGetLeds(PosKbdLeds var0);

    private static native void nativeSetLeds(PosKbdLeds var0);

    private static native void nativeSetEnabled(SetEnabledCommand var0);

    private static native void nativeSetClick(SetClickCommand var0);

    private static native void nativeSetTypematic(SetTypematicCommand var0);

    private static native void nativeCodeUpdate(CodeUpdateCommand var0);

    private static native void nativeSetDoublekeys(SetDoublekeysCommand var0);

    private static native void nativeSetTrapKeys(SetTrapKeysCommand var0);

    private static native void nativeGetDeviceInfo(GetDeviceInfoCommand var0);

    private static native void nativeSetTone(SetToneCommand var0);

    private static native void nativeSetPosLeds(SetLedsCommand var0);

    private static native void nativeGetStatus(GetStatusCommand var0);

    private static native void nativeEnableTracks(EnableTracksCommand var0);

    public static class EnableTracksCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private MsrTracks msrTracks = null;

        public EnableTracksCommand(MsrTracks msrTracks) {
            this.msrTracks = msrTracks;
        }

        public void execute() {
            PosKbd.nativeEnableTracks(this);
        }
    }

    public static class GetStatusCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private byte[] status = null;

        public void execute() {
            PosKbd.nativeGetStatus(this);
        }

        public byte[] getStatus() {
            return this.status;
        }

        private void setStatus(byte[] status) {
            this.status = status;
        }
    }

    public static class SetLedsCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private LedCmd ledCmd = null;

        public SetLedsCommand(LedCmd ledCmd) {
            this.ledCmd = ledCmd;
        }

        public void execute() {
            PosKbd.nativeSetPosLeds(this);
        }
    }

    public static class SetToneCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private ToneCmd toneCmd = null;

        public SetToneCommand(ToneCmd toneCmd) {
            this.toneCmd = toneCmd;
        }

        public void execute() {
            PosKbd.nativeSetTone(this);
        }
    }

    public static class GetDeviceInfoCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private KeyboardDevInfo keyboardDevInfo = null;

        public void execute() {
            PosKbd.nativeGetDeviceInfo(this);
        }

        public KeyboardDevInfo getKeyboardDevInfo() {
            return this.keyboardDevInfo;
        }

        private void setDevInfo(final short keyboardID, final short keyboardSubtype, final short msrType, final byte keyboardEC, final byte msrEC) {
            this.keyboardDevInfo = new KeyboardDevInfo(){

                public short getKeyboardID() {
                    return keyboardID;
                }

                public short getKeyboardSubtype() {
                    return keyboardSubtype;
                }

                public short getMsrType() {
                    return msrType;
                }

                public byte getKeyboardEC() {
                    return keyboardEC;
                }

                public byte getMsrEC() {
                    return msrEC;
                }

                public String toString() {
                    StringBuffer sb = new StringBuffer();
                    sb.append("<KeyboardDevInfo>");
                    sb.append("\nkeyboardID : " + Util.toHexString((short)keyboardID));
                    sb.append("\nkeyboardSubtype : " + Util.toHexString((short)keyboardSubtype));
                    sb.append("\nmsrType : " + Util.toHexString((short)msrType));
                    sb.append("\nkeyboardEC : " + Util.toHexString((byte)keyboardEC));
                    sb.append("\nmsrEC : " + Util.toHexString((byte)msrEC));
                    sb.append("<\\KeyboardDevInfo>");
                    return sb.toString();
                }
            };
        }
    }

    public static class SetTrapKeysCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private TrapKeys trapKeys = null;

        public SetTrapKeysCommand(TrapKeys trapKeys) {
            this.trapKeys = trapKeys;
        }

        public void execute() {
            PosKbd.nativeSetTrapKeys(this);
        }
    }

    public static class SetDoublekeysCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private byte[] doubleKeys = null;

        public SetDoublekeysCommand(byte[] doubleKeys) {
            this.doubleKeys = doubleKeys;
        }

        public void execute() {
            PosKbd.nativeSetDoublekeys(this);
        }
    }

    public static class CodeUpdateCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private byte[] codeUpdate = null;

        public CodeUpdateCommand(byte[] codeUpdate) {
            this.codeUpdate = codeUpdate;
        }

        public void execute() {
            PosKbd.nativeCodeUpdate(this);
        }
    }

    public static class SetTypematicCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private boolean typematic = false;

        public SetTypematicCommand(boolean typematic) {
            this.typematic = typematic;
        }

        public void execute() {
            PosKbd.nativeSetTypematic(this);
        }
    }

    public static class SetClickCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private ClickCmd click = null;

        public SetClickCommand(ClickCmd click) {
            this.click = click;
        }

        public void execute() {
            PosKbd.nativeSetClick(this);
        }
    }

    public static class SetEnabledCommand
    extends DefaultPS2PS2Command
    implements PS2PS2Command {
        private boolean enabled = false;

        public SetEnabledCommand(boolean enabled) {
            this.enabled = enabled;
        }

        public void execute() {
            PosKbd.nativeSetEnabled(this);
        }
    }

    public static abstract class DefaultPS2PS2Command
    implements PS2PS2Command {
        private boolean completed = false;
        private int errorCode = 0;

        public boolean isCompleted() {
            return this.completed;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        private void setCompleted(boolean c) {
            this.completed = c;
        }

        private void setErrorCode(int e) {
            this.errorCode = e;
        }
    }

    private static class PosKbdLeds
    implements Leds {
        public boolean capsLock = false;
        public boolean numLock = false;
        public boolean scrollLock = false;

        private PosKbdLeds() {
        }

        public boolean getCapsLock() {
            return this.capsLock;
        }

        public boolean getNumLock() {
            return this.numLock;
        }

        public boolean getScrollLock() {
            return this.scrollLock;
        }
    }
}

