/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.swing;

import com.ibm.jusb.tools.swing.UsbPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbPipe;
import javax.usb.util.UsbUtil;

public class UsbInterfacePanel
extends UsbPanel {
    private UsbInterface usbInterface = null;
    private JPanel claimPanel = new JPanel();
    private JButton claimButton = new JButton("Claim");
    private ActionListener claimListener = new ActionListener(){

        public void actionPerformed(ActionEvent aE) {
            UsbInterfacePanel.this.claim();
        }
    };
    private JButton releaseButton = new JButton("Release");
    private ActionListener releaseListener = new ActionListener(){

        public void actionPerformed(ActionEvent aE) {
            UsbInterfacePanel.this.release();
        }
    };
    private JPanel policyPanel = new JPanel();
    private JCheckBox useUsbInterfacePolicyBox = new JCheckBox("Use UsbInterfacePolicy", false);
    private ActionListener usePolicyListener = new ActionListener(){

        public void actionPerformed(ActionEvent aE) {
            boolean b = UsbInterfacePanel.this.useUsbInterfacePolicyBox.isSelected();
            UsbInterfacePanel.this.allowReleaseBox.setEnabled(b);
            UsbInterfacePanel.this.allowOpenBox.setEnabled(b);
            UsbInterfacePanel.this.forceClaimBox.setEnabled(b);
        }
    };
    private JCheckBox allowReleaseBox = new JCheckBox("allow release()", true);
    private JCheckBox allowOpenBox = new JCheckBox("allow open()", true);
    private JCheckBox forceClaimBox = new JCheckBox("forceClaim()", false);

    public UsbInterfacePanel(UsbInterface iface) {
        this.usbInterface = iface;
        this.createClaimPanel();
        this.string = "UsbInterface " + UsbUtil.unsignedInt((byte)iface.getUsbInterfaceDescriptor().bInterfaceNumber());
        if (1 < iface.getNumSettings()) {
            this.string = this.string + " setting " + UsbUtil.unsignedInt((byte)iface.getUsbInterfaceDescriptor().bAlternateSetting());
        }
        this.add(Box.createVerticalGlue());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(panel);
        this.refresh();
    }

    public UsbInterface getUsbInterface() {
        return this.usbInterface;
    }

    protected void refresh() {
        this.clear();
        this.appendln(this.string);
        this.initText();
    }

    protected void initText() {
        String ifaceString = null;
        String activeSetting = "Not Active";
        try {
            ifaceString = this.usbInterface.getInterfaceString();
        }
        catch (Exception e) {
            ifaceString = "Error : " + e.getMessage();
        }
        try {
            activeSetting = Integer.toString(UsbUtil.unsignedInt((byte)this.usbInterface.getActiveSettingNumber()));
        }
        catch (UsbNotActiveException usbNotActiveException) {
            // empty catch block
        }
        if (null == ifaceString) {
            ifaceString = "<undefined>";
        }
        this.appendln("Interface String : " + ifaceString);
        this.appendln("Is Active : " + this.usbInterface.isActive());
        this.appendln("Is Claimed : " + this.usbInterface.isClaimed());
        this.appendln("Active Alternate Setting Number : " + activeSetting);
        this.appendln("Number of Alternate Settings : " + this.usbInterface.getNumSettings());
        this.append(this.usbInterface.getUsbInterfaceDescriptor().toString());
    }

    protected void createClaimPanel() {
        this.claimButton.addActionListener(this.claimListener);
        this.releaseButton.addActionListener(this.releaseListener);
        this.useUsbInterfacePolicyBox.addActionListener(this.usePolicyListener);
        this.claimPanel.add(this.useUsbInterfacePolicyBox);
        this.claimPanel.add(this.claimButton);
        this.claimPanel.add(this.releaseButton);
        boolean b = this.useUsbInterfacePolicyBox.isSelected();
        this.allowReleaseBox.setEnabled(b);
        this.allowOpenBox.setEnabled(b);
        this.forceClaimBox.setEnabled(b);
        this.policyPanel.add(this.allowReleaseBox);
        this.policyPanel.add(this.allowOpenBox);
        this.policyPanel.add(this.forceClaimBox);
        this.add(this.claimPanel);
        this.add(this.policyPanel);
    }

    protected void claim() {
        try {
            if (this.useUsbInterfacePolicyBox.isSelected()) {
                final boolean allowRelease = this.allowReleaseBox.isSelected();
                final boolean allowOpen = this.allowOpenBox.isSelected();
                final boolean forceClaim = this.forceClaimBox.isSelected();
                UsbInterfacePolicy policy = new UsbInterfacePolicy(){

                    public boolean release(UsbInterface uI, Object o) {
                        return allowRelease;
                    }

                    public boolean open(UsbPipe uP, Object o) {
                        return allowOpen;
                    }

                    public boolean forceClaim(UsbInterface uI) {
                        return forceClaim;
                    }
                };
                this.usbInterface.claim(policy);
            } else {
                this.usbInterface.claim();
            }
        }
        catch (UsbException uE) {
            JOptionPane.showMessageDialog(null, "Could not claim UsbInterface : " + uE.getMessage());
        }
        catch (UsbNotActiveException unaE) {
            JOptionPane.showMessageDialog(null, "Could not claim UsbInterface : " + unaE.getMessage());
        }
        this.refresh();
    }

    protected void release() {
        try {
            this.usbInterface.release();
        }
        catch (UsbException uE) {
            JOptionPane.showMessageDialog(null, "Could not release UsbInterface : " + uE.getMessage());
        }
        catch (UsbNotActiveException unaE) {
            JOptionPane.showMessageDialog(null, "Could not release UsbInterface : " + unaE.getMessage());
        }
        this.refresh();
    }
}

