/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Util {
    protected Util() {
    }

    public static Object convertStringPrimitiveValue(String valueString, String className) throws IllegalArgumentException, ClassNotFoundException {
        return Util.convertStringPrimitiveValue(valueString, Util.javaClassForName(className));
    }

    public static Object convertStringPrimitiveValue(String valueString, Class type) throws IllegalArgumentException {
        if (!Util.isPrimitiveWrapperClassName(type.getName())) {
            throw new IllegalArgumentException("type must be one of the primitive wrapper classes");
        }
        Object value = null;
        try {
            String typeName;
            String string = typeName = type.getName().lastIndexOf(".") != -1 ? type.getName().substring(type.getName().lastIndexOf(".") + 1) : type.getName();
            if (typeName.equals("Boolean")) {
                value = Boolean.valueOf(valueString);
            } else if (typeName.equals("Byte")) {
                value = Byte.decode(valueString);
            } else if (typeName.equals("Character")) {
                value = new Character(valueString.charAt(0));
            } else if (typeName.equals("Double")) {
                value = Double.valueOf(valueString);
            } else if (typeName.equals("Float")) {
                value = Float.valueOf(valueString);
            } else if (typeName.equals("Integer")) {
                value = Integer.decode(valueString);
            } else if (typeName.equals("Long")) {
                value = Long.decode(valueString);
            } else if (typeName.equals("Short")) {
                value = Short.decode(valueString);
            } else if (typeName.equals("String")) {
                value = valueString;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert valueString = " + valueString + " into an Object of type = " + type.getName());
        }
        return value;
    }

    public static boolean isPrimitiveWrapperClassName(String className) {
        String name;
        String string = name = className.startsWith("java.lang.") ? className.substring("java.lang.".length()) : className;
        if (name.equals("Boolean")) {
            return true;
        }
        if (name.equals("Byte")) {
            return true;
        }
        if (name.equals("Character")) {
            return true;
        }
        if (name.equals("Double")) {
            return true;
        }
        if (name.equals("Float")) {
            return true;
        }
        if (name.equals("Integer")) {
            return true;
        }
        if (name.equals("Long")) {
            return true;
        }
        if (name.equals("Short")) {
            return true;
        }
        return name.equals("String");
    }

    public static byte byteAdd(byte a, byte b) {
        int ib;
        int ia = Util.unsignedInt(a);
        int tot = ia + (ib = Util.unsignedInt(b));
        if (tot > 255) {
            tot %= 256;
        }
        return (byte)tot;
    }

    public static int unsignedInt(byte b) {
        return 0xFF & b;
    }

    public static int unsignedInt(short s) {
        return 0xFFFF & s;
    }

    public static short unsignedShort(byte b) {
        return (short)(0xFF & b);
    }

    public static long unsignedLong(byte b) {
        return 0xFF & b;
    }

    public static long unsignedLong(short s) {
        return 0xFFFF & s;
    }

    public static long unsignedLong(int i) {
        return 0xFFFFFFFF & i;
    }

    public static short toShort(byte msb, byte lsb) {
        int tmp = Util.unsignedInt(msb) << 8;
        return (short)(tmp |= Util.unsignedInt(lsb));
    }

    public static int toInt(byte msb, byte lsb) {
        return Util.toInt((byte)0, (byte)0, msb, lsb);
    }

    public static int toInt(byte msb, byte b2, byte b1, byte lsb) {
        int integer = 0;
        integer = Util.unsignedInt(msb) << 24;
        integer |= Util.unsignedInt(b2) << 16;
        integer |= Util.unsignedInt(b1) << 8;
        return integer |= Util.unsignedInt(lsb);
    }

    public static long toLong(byte msb, byte b2, byte b1, byte lsb) {
        long l = 0L;
        l = Util.unsignedInt(msb);
        l <<= 24;
        l |= (long)(Util.unsignedInt(b2) << 16);
        l |= (long)(Util.unsignedInt(b1) << 8);
        return l |= (long)Util.unsignedInt(lsb);
    }

    public static String toHexString(byte b) {
        return Util.toHexString(Util.unsignedInt(b), '0', 2, 2);
    }

    public static String toHexString(int i) {
        return Util.toHexString(Util.unsignedLong(i), '0', 8, 8);
    }

    public static String toHexString(long l) {
        return Util.toHexString(l, '0', 16, 16);
    }

    public static String toHexString(long l, char c, int min, int max) {
        StringBuffer sb = new StringBuffer(Long.toHexString(l));
        if (max < min) {
            return sb.toString();
        }
        while (sb.length() < max) {
            sb.insert(0, c);
        }
        return sb.substring(0, min);
    }

    public static String toFormatedHexString(byte[] byteArray) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(byteArray.length);
        sb.append("]");
        for (int i = 0; i < byteArray.length; ++i) {
            sb.append(Util.toHexString(byteArray[i]) + " ");
        }
        return sb.toString();
    }

    public static String toFormatedHexString(int[] intArray) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(intArray.length);
        sb.append("]");
        for (int i = 0; i < intArray.length; ++i) {
            sb.append(Util.toHexString(intArray[i]) + " ");
        }
        return sb.toString();
    }

    public static String toFormatedHexString(String[] stringArray) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(stringArray.length);
        sb.append("]");
        for (int i = 0; i < stringArray.length; ++i) {
            sb.append(stringArray[i] + " ");
        }
        return sb.toString();
    }

    public static String toFormatedHexString(byte[] byteArray, int offset, int len) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(len);
        sb.append("]");
        if (offset + len > byteArray.length) {
            len = byteArray.length;
        }
        int i = 0;
        while (i + offset < len) {
            sb.append(Util.toHexString(byteArray[i + offset]) + " ");
            ++i;
        }
        return sb.toString();
    }

    public static String toHexString(short s) {
        return Util.toHexString(Util.unsignedInt(s), '0', 4, 4);
    }

    public static String toHexString(int i, char c, int min, int max) {
        StringBuffer sb = new StringBuffer(Integer.toHexString(i));
        int length = Math.max(min, Math.min(sb.length(), max));
        if (max < min) {
            return sb.toString();
        }
        while (sb.length() < min) {
            sb.insert(0, c);
        }
        return sb.substring(0, length);
    }

    public static byte[] toByteArray(short num) {
        byte[] array = new byte[2];
        short temp = num;
        temp = (short)(temp >> 8);
        temp = (short)(temp & 0xFF);
        array[0] = (byte)temp;
        temp = num;
        temp = (short)(temp & 0xFF);
        array[1] = (byte)temp;
        return array;
    }

    public static byte[] toByteArray(int num) {
        byte[] array = new byte[4];
        for (int i = 3; i >= 0; --i) {
            int temp = num;
            temp >>= 8 * i;
            array[3 - i] = (byte)(temp &= 0xFF);
        }
        return array;
    }

    public static Vector createVector(Iterator iterator) {
        Vector v = new Vector();
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static Vector createVector(List list) {
        return Util.createVector(list.iterator());
    }

    public static Vector createVector(Enumeration enum1) {
        Vector v = new Vector();
        while (enum1.hasMoreElements()) {
            v.addElement(enum1.nextElement());
        }
        return v;
    }

    public static Vector createVector(Object[] array) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < array.length; ++i) {
            v.addElement(array[i]);
        }
        return v;
    }

    public static boolean isIdentical(List l1, List l2) {
        return Util.isIdentical(new Vector(l1).elements(), new Vector(l2).elements());
    }

    public static boolean isIdentical(Iterator i1, Iterator i2) {
        return Util.isIdentical(Util.createVector(i1).elements(), Util.createVector(i2).elements());
    }

    public static boolean isIdentical(Vector v1, Vector v2) {
        return Util.isIdentical(v1.elements(), v2.elements());
    }

    public static boolean isIdentical(Enumeration enum1, Enumeration enum2) {
        if (enum1 == null || enum2 == null) {
            return false;
        }
        if (enum1.hasMoreElements() && !enum2.hasMoreElements()) {
            return false;
        }
        if (enum2.hasMoreElements() && !enum1.hasMoreElements()) {
            return false;
        }
        while (enum1.hasMoreElements()) {
            Object enum1Obj = enum1.nextElement();
            if (!enum2.hasMoreElements()) {
                return false;
            }
            Object enum2Obj = enum2.nextElement();
            if (enum1Obj.equals(enum2Obj)) continue;
            return false;
        }
        return !enum2.hasMoreElements();
    }

    public static boolean isIdentical(Object[] array, Vector vector) {
        return Util.isIdentical(Util.createVector(array), vector);
    }

    public static boolean isIdentical(Object[] array, Enumeration enum1) {
        return Util.isIdentical(Util.createVector(array).elements(), enum1);
    }

    public static boolean isEquals(Object[] array, Vector vector) {
        return Util.isEquals(Util.createVector(array), vector);
    }

    public static boolean isEquals(Object[] array, Enumeration enum1) {
        return Util.isEquals(Util.createVector(array).elements(), enum1);
    }

    public static boolean isEquals(Enumeration enum1, Enumeration enum2) {
        if (enum1 == null || enum2 == null) {
            return false;
        }
        return Util.isEquals(Util.createVector(enum1), Util.createVector(enum2));
    }

    public static boolean isEquals(Vector v1, Vector v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        Vector v1Clone = (Vector)v1.clone();
        Vector v2Clone = (Vector)v2.clone();
        if (v1Clone.size() != v2Clone.size()) {
            return false;
        }
        for (int i = 0; i < v1Clone.size(); ++i) {
            Object v1CloneObj = v1Clone.elementAt(i);
            boolean found = false;
            Object v2CloneObj = null;
            for (int j = 0; j < v2Clone.size(); ++j) {
                v2CloneObj = v2Clone.elementAt(j);
                if (!v1CloneObj.equals(v2CloneObj)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            v2Clone.removeElement(v2CloneObj);
        }
        return v2Clone.size() == 0;
    }

    public static boolean isEquals(List l1, List l2) {
        return Util.isEquals(Util.createVector(l1), Util.createVector(l2));
    }

    public static boolean isEquals(Iterator i1, Iterator i2) {
        return Util.isEquals(Util.createVector(i1), Util.createVector(i2));
    }

    public static boolean isEquals(Enumeration enumeration, Iterator iterator) {
        if (enumeration == null) {
            return false;
        }
        if (iterator == null) {
            return false;
        }
        return Util.isEquals(enumeration, Util.createVector(iterator).elements());
    }

    public static boolean isEquals(Hashtable table1, Hashtable table2) {
        if (table1.size() != table2.size()) {
            return false;
        }
        Enumeration keys1 = table1.keys();
        while (keys1.hasMoreElements()) {
            Object key1 = keys1.nextElement();
            Object value1 = table1.get(key1);
            if (!table2.containsKey(key1)) {
                return false;
            }
            if (table2.get(key1).equals(value1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(Hashtable table, HashMap map) {
        return Util.isEquals(table, Util.createHashtable(map));
    }

    public static boolean isInList(Byte value, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof Byte) || !((Byte)obj).equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInList(Short value, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof Short) || !((Short)obj).equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInList(Integer value, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof Integer) || !((Integer)obj).equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInList(Object value, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!obj.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static List createList(Iterator iterator) {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static Hashtable createHashtable(HashMap map) {
        Hashtable table = new Hashtable();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            table.put(key, map.get(key));
        }
        return table;
    }

    public static String toString(String[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("String[" + array.length + "]{");
        for (int i = 0; i < array.length; ++i) {
            sb.append("{" + array[i] + "}");
        }
        sb.append("}");
        return sb.toString();
    }

    static Class javaClassForName(String className) throws ClassNotFoundException {
        if (className.indexOf(".") != -1) {
            return Class.forName(className);
        }
        if (Util.isPrimitiveWrapperClassName(className)) {
            return Class.forName("java.lang." + className);
        }
        return Class.forName(className);
    }
}

