/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.logging.LogEntry;
import com.ibm.jutil.logging.LogStore;
import com.ibm.jutil.logging.LoggerProperties;
import java.util.Vector;

public abstract class AbstractLogStore
implements LogStore {
    protected int threshold;
    protected Vector queue = new Vector();
    protected boolean addFlag = false;
    protected boolean flushFlag = false;
    protected static final int DEFAULT_THRESHOLD = 10;

    public AbstractLogStore() {
        this.initThresholdFromProperties();
        this.init();
    }

    private void initThresholdFromProperties() {
        try {
            this.threshold = Integer.parseInt(LoggerProperties.getProperty("com.ibm.jutil.logging.Logger.Threshold", "com.ibm.jutil.logging.default.Logger.Threshold"));
        }
        catch (Exception e) {
            this.threshold = 10;
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    protected int getQueueSize() {
        return this.queue.size();
    }

    public void setThreshold(int value) {
        if (value > 0) {
            this.threshold = value;
        }
    }

    protected boolean addCalled() {
        return this.addFlag;
    }

    protected boolean flushCalled() {
        return this.flushFlag;
    }

    public void add(LogEntry entry) {
        this.queue.addElement(entry);
        if (this.queue.size() == this.threshold) {
            this.flush();
        } else {
            this.flushFlag = false;
        }
        this.addFlag = true;
    }

    public abstract void flush();

    public abstract void init();

    public abstract void close();

    protected void clear() {
        this.queue.clear();
    }
}

