/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.logging.AbstractLogger;
import com.ibm.jutil.logging.LogEntryFactory;
import com.ibm.jutil.logging.LogStore;
import com.ibm.jutil.logging.LoggerProperties;

public class Logger
extends AbstractLogger
implements Runnable {
    private static Logger instance = null;

    protected Logger() {
    }

    protected void initFromProperties() {
        this.initLogStore();
        this.initLogEntryFactory();
    }

    private void initLogStore() {
        String className = LoggerProperties.getProperty("com.ibm.jutil.logging.LogStoreName");
        String defaultClassName = LoggerProperties.getProperty("com.ibm.jutil.logging.default.LogStoreName");
        Class<?> logStoreClass = null;
        try {
            logStoreClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                logStoreClass = Class.forName(defaultClassName);
            }
            catch (ClassNotFoundException f) {
                // empty catch block
            }
        }
        try {
            this.logStore = (LogStore)logStoreClass.newInstance();
        }
        catch (ClassCastException e) {
            try {
                logStoreClass = Class.forName(defaultClassName);
            }
            catch (ClassNotFoundException f) {
                // empty catch block
            }
            try {
                this.logStore = (LogStore)logStoreClass.newInstance();
            }
            catch (ClassCastException f) {
            }
            catch (InstantiationException f) {
            }
            catch (IllegalAccessException f) {}
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    private void initLogEntryFactory() {
        String className = LoggerProperties.getProperty("com.ibm.jutil.logging.LogEntryFactoryName");
        String defaultClassName = LoggerProperties.getProperty("com.ibm.jutil.logging.default.LogEntryFactoryName");
        Class<?> logFactoryClass = null;
        try {
            logFactoryClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                logFactoryClass = Class.forName(defaultClassName);
            }
            catch (ClassNotFoundException f) {
                // empty catch block
            }
        }
        try {
            this.logFactory = (LogEntryFactory)logFactoryClass.newInstance();
        }
        catch (ClassCastException e) {
            try {
                logFactoryClass = Class.forName(defaultClassName);
            }
            catch (ClassNotFoundException f) {
                // empty catch block
            }
            try {
                this.logFactory = (LogEntryFactory)logFactoryClass.newInstance();
            }
            catch (ClassCastException f) {
            }
            catch (InstantiationException f) {
            }
            catch (IllegalAccessException f) {}
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    public int getThreshold() {
        return this.logStore.getThreshold();
    }

    public static Logger getInstance() {
        if (!LoggerProperties.isLoaded()) {
            LoggerProperties.load();
        }
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public void setThreshold(int threshold) {
        this.logStore.setThreshold(threshold);
    }

    public synchronized void close() {
        this.stop();
        instance = null;
    }

    protected static boolean existsInstance() {
        return instance != null;
    }
}

