/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.patterns.factory;

import com.ibm.jutil.patterns.factory.AbstractRecycleFactory;
import com.ibm.jutil.patterns.factory.PoolFactory;
import com.ibm.jutil.patterns.factory.RecyclableObject;
import com.ibm.jutil.patterns.factory.RecycleFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractPoolFactory
extends AbstractRecycleFactory
implements PoolFactory {
    private int poolMax = -1;
    private int initialPoolSize = 10;
    private int poolIncrementFactor = 2;
    private float poolThreshold = 0.5f;
    private RecycleFactory.CreateMethod createMethod = null;
    private PoolFactory.Pool pool = new DefaultPool();
    public static final int DEFAULT_INITIAL_POOL_SIZE = 10;
    public static final int DEFAULT_POOL_INCREMENT_FACTOR = 2;
    public static final float DEFAULT_POOL_THRESHOLD = 0.5f;

    public AbstractPoolFactory(RecycleFactory.CreateMethod createMethod) {
        this(createMethod, 10, 2, 0.5f);
    }

    public AbstractPoolFactory(RecycleFactory.CreateMethod createMethod, int initialPoolSize, int poolIncrement, float poolThreshold) throws IllegalArgumentException {
        this.setPoolInitialSize(initialPoolSize);
        this.setPoolIncrementFactor(this.poolIncrementFactor);
        this.setPoolThreshold(poolThreshold);
        this.setCreateMethod(createMethod);
        this.initializePool();
    }

    public AbstractPoolFactory(RecycleFactory.CreateMethod createMethod, int initialPoolSize, int poolIncrement, float poolThreshold, int poolMax) throws IllegalArgumentException {
        this.setPoolInitialSize(initialPoolSize);
        this.setPoolIncrementFactor(this.poolIncrementFactor);
        this.setPoolThreshold(poolThreshold);
        this.setCreateMethod(createMethod);
        this.initializePool();
        if (1 <= poolMax) {
            this.setPoolMax(poolMax);
        }
    }

    public AbstractPoolFactory(RecycleFactory.CreateMethod createMethod, int poolMax) {
        this(createMethod, 10, 2, 0.5f, poolMax);
    }

    protected void initializePool() {
        this.increasePool(this.getPoolInitialSize() - this.pool.getSize());
    }

    protected void increasePool(int i) {
        int size = i;
        while (size-- > 0) {
            this.pool.add(this.getCreateMethod().newRecyclableObject(this));
        }
    }

    protected void setPoolInitialSize(int i) throws IllegalArgumentException {
        if (i <= 0) {
            throw new IllegalArgumentException("Incorrect argument to setPoolInitialSize must be > 0");
        }
        this.initialPoolSize = i;
    }

    protected void setPoolIncrementFactor(int i) throws IllegalArgumentException {
        if (i <= 0) {
            throw new IllegalArgumentException("Incorrect argument to setPoolIncrementFactor must be > 0");
        }
        this.poolIncrementFactor = i;
    }

    protected void setPoolThreshold(float f) throws IllegalArgumentException {
        if (f <= 0.0f || (double)f > 1.0) {
            throw new IllegalArgumentException("Incorrect argument to setInialPoolSize must be > 0");
        }
        this.poolThreshold = f;
    }

    protected void setCreateMethod(RecycleFactory.CreateMethod cMethod) throws IllegalArgumentException {
        if (cMethod == null) {
            throw new IllegalArgumentException("Incorrect argument to setCreateMethod");
        }
        this.createMethod = cMethod;
    }

    protected RecyclableObject takeFromPool() {
        if ((float)this.pool.getSize() <= (float)this.getPoolInitialSize() * this.getPoolThreshold()) {
            this.increasePool(this.getPoolInitialSize() * this.getPoolIncrementFactor() - this.pool.getSize());
        }
        RecyclableObject rObj = this.pool.get(0);
        this.pool.remove(rObj);
        return rObj;
    }

    public int getPoolMax() {
        return this.poolMax;
    }

    public void setPoolMax(int pm) {
        if (1 > pm) {
            return;
        }
        this.poolMax = pm;
    }

    public int getPoolInitialSize() {
        return this.initialPoolSize;
    }

    public int getPoolIncrementFactor() {
        return this.poolIncrementFactor;
    }

    public float getPoolThreshold() {
        return this.poolThreshold;
    }

    public RecycleFactory.CreateMethod getCreateMethod() {
        return this.createMethod;
    }

    public PoolFactory.Pool getPool() {
        return this.pool;
    }

    public void recycle(RecyclableObject recyclableObject) {
        recyclableObject.clean();
        if (!(this.pool.contains(recyclableObject) || -1 != this.poolMax && this.poolMax < this.pool.getSize())) {
            this.pool.add(recyclableObject);
        }
    }

    public static class DefaultPool
    implements PoolFactory.Pool {
        private List list = Collections.synchronizedList(new ArrayList());

        public int getSize() {
            return this.list.size();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void add(RecyclableObject rObj) {
            if (!this.list.contains(rObj)) {
                this.list.add(rObj);
            }
        }

        public void remove(RecyclableObject rObj) {
            this.list.remove(rObj);
        }

        public void removeAll() {
            this.list.clear();
        }

        public Iterator getElements() {
            return this.list.iterator();
        }

        public boolean contains(RecyclableObject rObj) {
            return this.list.contains(rObj);
        }

        public RecyclableObject get(int i) throws IllegalArgumentException {
            if (i < 0 || i >= this.getSize()) {
                throw new IllegalArgumentException("Cannot get i = " + i + " element from the pool!");
            }
            return (RecyclableObject)this.list.get(i);
        }
    }
}

