/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.swing;

import com.ibm.jutil.ResourceConst;
import com.ibm.jutil.swing.ImageComponent;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog
extends JDialog {
    private Tracer tracer = TracerFactory.getInstance().createGlobalTracer();
    public static final String SYSTEM_JAVA_VERSION_KEY = "java.version";
    public static final String SYSTEM_OS_NAME_KEY = "os.name";
    public static final String SYSTEM_OS_ARCH_KEY = "os.arch";
    public static final String SYSTEM_OS_VERSION_KEY = "os.version";
    public static final String JAVA_LOGO_FILE = "com" + File.separator + "ibm" + File.separator + "jutil" + File.separator + "res" + File.separator + "images" + File.separator + "JavaLogo.gif";
    public static final Dimension DEFAULT_SIZE = new Dimension(380, 300);

    public AboutDialog(JFrame parent) {
        this(parent, ResourceConst.TEXT_ABOUT_DIALOG, ResourceConst.TEXT_SYSTEM_INFORMATION);
    }

    public AboutDialog(JFrame parent, String titleDlg, String titleLabel) {
        super(parent, titleDlg, true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createTitlePanel(titleLabel), "North");
        contentPane.add((Component)this.createAboutPanel(titleLabel), "Center");
        contentPane.add((Component)this.createButtonPanel(), "South");
        this.setSize(DEFAULT_SIZE);
        this.setDefaultCloseOperation(1);
        this.centerDialog();
    }

    public AboutDialog(JFrame parent, String titleDlg, String titleLabel, boolean disposeOnClose) {
        this(parent, titleDlg, titleLabel);
        if (disposeOnClose) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(1);
        }
    }

    protected void centerDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
    }

    protected JPanel createTitlePanel(String titleLabel) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(titleLabel);
        label.setFont(ResourceConst.DEFAULT_FONT_BOLD_14);
        panel.add(label);
        return panel;
    }

    protected JPanel createAboutPanel(String titleLabel) {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 0, 0);
        panel.add((Component)this.createLabel(ResourceConst.TEXT_JAVA_VERSION, ResourceConst.DEFAULT_FONT_BOLD_14), this.setGBC(gbc, 1, 1, 1, 1));
        panel.add((Component)this.createLabel(ResourceConst.TEXT_OS, ResourceConst.DEFAULT_FONT_BOLD_14), this.setGBC(gbc, 1, 2, 1, 1));
        panel.add((Component)this.createLabel(ResourceConst.WORD_ARCHITECTURE, ResourceConst.DEFAULT_FONT_BOLD_14), this.setGBC(gbc, 1, 3, 1, 1));
        panel.add((Component)this.createLabel(ResourceConst.TEXT_TOTAL_MEMORY, ResourceConst.DEFAULT_FONT_BOLD_14), this.setGBC(gbc, 1, 4, 1, 1));
        panel.add((Component)this.createLabel(ResourceConst.TEXT_FREE_MEMORY, ResourceConst.DEFAULT_FONT_BOLD_14), this.setGBC(gbc, 1, 5, 1, 1));
        String info = System.getProperties().getProperty(SYSTEM_JAVA_VERSION_KEY);
        panel.add((Component)this.createLabel(info, ResourceConst.DEFAULT_FONT_PLAIN), this.setGBC(gbc, 2, 1, 1, 1));
        info = System.getProperties().getProperty(SYSTEM_OS_NAME_KEY);
        panel.add((Component)this.createLabel(info, ResourceConst.DEFAULT_FONT_PLAIN), this.setGBC(gbc, 2, 2, 1, 1));
        info = System.getProperties().getProperty(SYSTEM_OS_ARCH_KEY);
        panel.add((Component)this.createLabel(info, ResourceConst.DEFAULT_FONT_PLAIN), this.setGBC(gbc, 2, 3, 1, 1));
        info = new Long(Runtime.getRuntime().totalMemory() / 1024L).toString();
        panel.add((Component)this.createLabel(info, ResourceConst.DEFAULT_FONT_PLAIN), this.setGBC(gbc, 2, 4, 1, 1));
        info = new Long(Runtime.getRuntime().freeMemory() / 1024L).toString();
        panel.add((Component)this.createLabel(info, ResourceConst.DEFAULT_FONT_PLAIN), this.setGBC(gbc, 2, 5, 1, 1));
        info = System.getProperties().getProperty(SYSTEM_OS_VERSION_KEY);
        panel.add((Component)this.createLabel(info, ResourceConst.DEFAULT_FONT_PLAIN), this.setGBC(gbc, 3, 2, 1, 1));
        panel.add((Component)this.createLabel(ResourceConst.WORD_KBYTES, ResourceConst.DEFAULT_FONT_PLAIN), this.setGBC(gbc, 3, 4, 1, 1));
        panel.add((Component)this.createLabel(ResourceConst.WORD_KBYTES, ResourceConst.DEFAULT_FONT_PLAIN), this.setGBC(gbc, 3, 5, 1, 1));
        gbc.fill = 1;
        try {
            panel.add((Component)new ImageComponent(JAVA_LOGO_FILE), this.setGBC(gbc, 4, 2, 1, 4));
        }
        catch (Exception ie) {
            Tracer.getInstance().println("Unable to create ImageComponent : " + ie);
        }
        return panel;
    }

    protected JLabel createLabel(String text, Font font) {
        JLabel label = new JLabel(text);
        label.setFont(font);
        return label;
    }

    protected GridBagConstraints setGBC(GridBagConstraints gbc, int gridx, int gridy, int gridwidth, int gridheight) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        return gbc;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        JButton okButton = new JButton(ResourceConst.WORD_OK);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.okButtonClicked(e);
            }
        });
        panel.add(okButton);
        return panel;
    }

    protected void trace(String msg) {
        this.tracer.println("[AboutDialog]" + msg);
    }

    void okButtonClicked(ActionEvent e) {
        this.setVisible(false);
    }
}

