/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.swing;

import com.ibm.jutil.FileUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import javax.swing.JComponent;

public class ImageComponent
extends JComponent {
    private Color borderColor = Color.blue;
    private boolean paintBorder = false;
    protected Image image;

    public ImageComponent(String fileName) throws FileNotFoundException, InterruptedException {
        this.image = Toolkit.getDefaultToolkit().getImage(FileUtil.findURL(fileName));
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 0);
        tracker.waitForID(0);
    }

    public void setImageBorder(boolean b) {
        this.paintBorder = b;
    }

    public boolean getImageBorder() {
        return this.paintBorder;
    }

    public void setBorderColor(Color bc) {
        this.borderColor = bc;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public synchronized Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        if (this.paintBorder) {
            g.setColor(this.borderColor);
            g.drawRect(0, 0, this.image.getWidth(this) - 1, this.image.getHeight(this) - 1);
            g.drawRect(1, 1, this.image.getWidth(this) - 3, this.image.getHeight(this) - 3);
        }
    }
}

