/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.tasks;

import com.ibm.jutil.tasks.Task;
import com.ibm.jutil.tasks.TaskScheduler;

public abstract class AbstractTaskScheduler
implements TaskScheduler {
    protected boolean started = false;
    protected boolean stopped = true;
    protected boolean paused = false;
    protected Object startLock = new Object();
    protected Object stopLock = new Object();
    protected Object resumeLock = new Object();
    protected static int taskSchedulerCount = 0;
    public static final String DEFAULT_TASK_SCHEDULER_NAME = "TaskScheduler";

    public AbstractTaskScheduler() {
        ++taskSchedulerCount;
    }

    public abstract void post(Task var1);

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<TaskScheduler name = " + this.getName() + ">\n");
        sb.append("    <state started = " + this.started + " paused = " + this.paused + "/>\n");
        sb.append(this.getOtherData());
        sb.append("</TaskScheduler>\n");
        return sb.toString();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        Object object = this.resumeLock;
        synchronized (object) {
            this.resumeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.stopped = false;
        this.paused = false;
        Object object = this.startLock;
        synchronized (object) {
            this.startLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.started = false;
        this.paused = false;
        Object object = this.stopLock;
        synchronized (object) {
            this.stopLock.notifyAll();
        }
    }

    protected String getName() {
        return DEFAULT_TASK_SCHEDULER_NAME + taskSchedulerCount;
    }

    protected String getOtherData() {
        return "";
    }
}

