/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SdistResource {
    private static ResourceBundle resourceBundle = null;
    private static Tracer tracer = TracerFactory.getInstance().createTracer("SDIST", "SdistResource");
    private static String bundleBaseName = "com.ibm.jpos.tools.sdist.res.sdistresources";

    private SdistResource() {
    }

    public static String getString(String key) {
        try {
            return SdistResource.getResourceBundle().getString(key).trim();
        }
        catch (MissingResourceException mre) {
            tracer.print((Exception)mre);
            return "";
        }
    }

    public static ResourceBundle getResourceBundle() {
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(bundleBaseName, Locale.getDefault());
            tracer.println("Using locale: " + resourceBundle.getLocale());
        }
        return resourceBundle;
    }

    public static void setLocale(Locale locale) {
        resourceBundle = ResourceBundle.getBundle(bundleBaseName, locale);
        tracer.println("Using locale: " + resourceBundle.getLocale());
    }
}

