/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist.model;

import com.ibm.jpos.tools.sdist.SdistConst;
import com.ibm.jutil.DefaultStoreFileUtil;
import com.ibm.jutil.FileUtil;
import com.ibm.jutil.tracing.Tracer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SdistProperties
extends Properties {
    private String fullPath = "null";
    private FindPropertyPath pathFinder = new FindPropertyPath();
    private NumberFormat numericFormat;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";

    public SdistProperties() {
        this.init();
    }

    public SdistProperties(Properties defaults) {
        super(defaults);
        this.init();
    }

    public String getProperty(String key) {
        String sval;
        Object oval = super.get(key);
        String string = sval = oval instanceof PropertyValue ? ((PropertyValue)oval).value : null;
        if (sval == null && this.defaults != null) {
            return this.defaults.getProperty(key);
        }
        if (sval != null) {
            sval = sval.trim();
        }
        return sval;
    }

    public synchronized void load(InputStream inStream) throws IOException {
        int lineCount = 0;
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        String line;
        while ((line = in.readLine()) != null) {
            PropertyValue pv;
            ++lineCount;
            if (line.length() > 0) {
                int keyStart;
                int len = line.length();
                for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
                }
                char firstChar = line.charAt(keyStart);
                if (firstChar != '#' && firstChar != '!' && keyStart != len) {
                    int valueIndex;
                    int separatorIndex;
                    while (this.continueLine(line)) {
                        int startIndex;
                        String nextLine = in.readLine();
                        if (nextLine == null) {
                            nextLine = "";
                        }
                        String loppedLine = line.substring(0, len - 1);
                        for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                        }
                        nextLine = nextLine.substring(startIndex, nextLine.length());
                        line = new String(loppedLine + nextLine);
                        len = line.length();
                    }
                    for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                        char currentChar = line.charAt(separatorIndex);
                        if (currentChar == '\\') {
                            ++separatorIndex;
                            continue;
                        }
                        if (keyValueSeparators.indexOf(currentChar) != -1) break;
                    }
                    for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
                    }
                    if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                        ++valueIndex;
                    }
                    while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                        ++valueIndex;
                    }
                    String key = line.substring(keyStart, separatorIndex);
                    String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
                    key = this.loadConvert(key);
                    value = this.loadConvert(value);
                    pv = new PropertyValue("$$LINE" + this.numericFormat.format(lineCount), value);
                    this.put(key, pv);
                    continue;
                }
                String key = "$$LINE" + this.numericFormat.format(lineCount);
                pv = new PropertyValue(key, line);
                this.put(key, pv);
                continue;
            }
            String key = "$$LINE" + this.numericFormat.format(lineCount);
            pv = new PropertyValue(key, line);
            this.put(key, pv);
        }
        return;
    }

    public synchronized Object setProperty(String key, String value) {
        PropertyValue pv;
        Object mv = this.get(key);
        if (mv == null || !(mv instanceof PropertyValue)) {
            pv = new PropertyValue("$$LINE" + this.numericFormat.format(this.size() + 1), value);
        } else {
            pv = (PropertyValue)mv;
            pv.value = value;
        }
        return this.put(key, pv);
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        String val;
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        Hashtable<String, String> fileLayout = new Hashtable<String, String>();
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            PropertyValue pv = (PropertyValue)this.get(key);
            if (key.startsWith("$$")) {
                fileLayout.put(pv.line, pv.value);
                continue;
            }
            key = this.saveConvert(key, true);
            val = this.saveConvert(pv.value, false);
            fileLayout.put(pv.line, key + "=" + val);
        }
        for (int i = 0; i < fileLayout.size() + 1; ++i) {
            String key = "$$LINE" + this.numericFormat.format(i);
            val = (String)fileLayout.get(key);
            if (val == null) continue;
            awriter.write(val);
            awriter.newLine();
        }
        awriter.flush();
    }

    public Enumeration getPropertyNames() {
        Vector<String> v = new Vector<String>();
        String pn = null;
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            pn = (String)e.nextElement();
            if (pn.startsWith("$$")) continue;
            v.add(pn);
        }
        return v.elements();
    }

    public void addProperty(String propName, String propValue) {
        this.setProperty(propName, propValue);
    }

    public void storeProperties(String header, String fileName) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException fnfe) {
            try {
                File f = new File(fileName);
                String file = f.getName();
                String path = fileName.substring(0, fileName.length() - file.length());
                DefaultStoreFileUtil storeFile = new DefaultStoreFileUtil(path);
                storeFile.create(file);
                out = (FileOutputStream)storeFile.getOutputStream();
            }
            catch (IOException ioe) {
                Tracer.getInstance().println("Could not write in " + fileName);
                throw new IOException(SdistConst.MSG_CANTWRITE + " " + fileName + "\n" + SdistConst.MSG_REASONS);
            }
        }
        try {
            if (out == null) {
                return;
            }
            this.store(out, header);
            out.close();
        }
        catch (IOException e) {
            Tracer.getInstance().println("Unexpected error writting to file " + fileName);
            throw new IOException("Could not write in " + fileName);
        }
    }

    public String getPropertyString(String propName) {
        String propValue = "";
        if (System.getProperties().containsKey(propName)) {
            propValue = System.getProperties().getProperty(propName);
        } else {
            propValue = this.getProperty(propName);
            if (propValue != null && propValue.startsWith("<home>")) {
                String home = System.getProperties().getProperty("user.home");
                propValue = home + propValue.substring(propValue.lastIndexOf(">") + 1, propValue.length());
            }
        }
        return propValue.trim();
    }

    public void loadPropertiesByName(String propFileName) {
        this.findProperties(propFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void findProperties(String propFileName) {
        block12: {
            block13: {
                if (propFileName.equals("")) {
                    return;
                }
                String loadedPropFileName = propFileName;
                InputStream is = null;
                try {
                    is = FileUtil.loadFile((String)loadedPropFileName, (boolean)true, (boolean)true, (FileUtil.FindFilePath)this.pathFinder);
                }
                catch (FileNotFoundException fne) {
                    Tracer.getInstance().println("->" + propFileName + " file not found");
                }
                catch (IOException ioe) {
                    Tracer.getInstance().println("-> Error Opening file " + propFileName);
                }
                if (is == null) break block13;
                is = new BufferedInputStream(is);
                this.load(is);
                Object var6_7 = null;
                try {
                    is.close();
                }
                catch (Exception e2) {
                    Tracer.getInstance().println("SdistProperties-> Unexpected exception while closing stream Exception.message = " + e2.getMessage());
                }
                break block12;
                {
                    catch (Exception e) {
                        loadedPropFileName = "";
                        Object var6_8 = null;
                        try {
                            is.close();
                        }
                        catch (Exception e2) {
                            Tracer.getInstance().println("SdistProperties-> Unexpected exception while closing stream Exception.message = " + e2.getMessage());
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        Tracer.getInstance().println("SdistProperties-> Unexpected exception while closing stream Exception.message = " + e2.getMessage());
                    }
                    throw throwable;
                }
            }
            Tracer.getInstance().println("SdistUtilProperties->" + propFileName + " Could not be loaded");
        }
    }

    public String getStringProperty(String propName) {
        return this.getPropertyString(propName);
    }

    public boolean isPropertyDefined(String propName) {
        if (System.getProperties().containsKey(propName)) {
            return true;
        }
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.equals(propName)) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.numericFormat = NumberFormat.getInstance();
        this.numericFormat.setParseIntegerOnly(true);
        this.numericFormat.setMaximumIntegerDigits(5);
        this.numericFormat.setMinimumIntegerDigits(5);
        this.numericFormat.setMaximumFractionDigits(0);
        this.numericFormat.setMinimumFractionDigits(0);
        this.numericFormat.setGroupingUsed(false);
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(SdistProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(SdistProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(SdistProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(SdistProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    class PropertyValue {
        public String line;
        public String value;

        public PropertyValue(String line, String value) {
            this.line = line;
            this.value = value;
        }

        public String getLine() {
            return this.line;
        }

        public void setLine(String line) {
            this.line = line;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class FindPropertyPath
    implements FileUtil.FindFilePath {
        FindPropertyPath() {
        }

        public void setFoundPath(String path) {
            SdistProperties.this.fullPath = path;
        }
    }
}

