/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist.panels;

import com.ibm.jpos.tools.sdist.SdistAppModel;
import com.ibm.jpos.tools.sdist.SdistConst;
import com.ibm.jpos.tools.sdist.model.JavaPOSTracingModel;
import com.ibm.jpos.tools.sdist.panels.SdistAppPanel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class SdistPnlJavaPOSTracing
extends JPanel
implements SdistAppPanel {
    public static final String PANEL_ID = "JavaPOSPnl";
    public static final String PANEL_TAB_NAME = "JavaPOS";
    private JPanel jPnlMain;
    private JLabel jLblThreshold;
    private JCheckBox jChkEnabled;
    private JLabel jLabel9;
    private JLabel jlblFiles;
    private JTextField jTxtMaxFiles;
    private JLabel jLblMaxFiles;
    private JLabel jlblbytes2;
    private JLabel jLblFlushFreq;
    private JSeparator jSeparator1;
    private JTextField jTxtMaxFileSize;
    private JLabel jLblMaximumSize;
    private JLabel jLblSeconds;
    private JTextField jTxtFlushFrequency;
    private JLabel jLblBytes;
    private JTextField jTxtThreshold;
    private JLabel jLblOutput;
    private JComboBox jCmbOutput;
    private JButton jBtnExplore;
    private JLabel jLblTimeFormat;
    private JComboBox jCmbTimeStampFormat;
    private JLabel jLabel1;
    private JTextField jTxtFileName;
    private JButton jBtnReset;
    private JTextField jTxtFilePath;
    private JLabel jLblFilePath;
    private JComboBox jCmbLevel;
    private JLabel jLblLevel;

    public SdistPnlJavaPOSTracing() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(652, 411));
            GridLayout thisLayout = new GridLayout(1, 1);
            thisLayout.setColumns(2);
            thisLayout.setHgap(5);
            thisLayout.setVgap(5);
            this.setLayout(thisLayout);
            this.jPnlMain = new JPanel();
            this.add(this.jPnlMain);
            this.jPnlMain.setLayout(null);
            this.jPnlMain.setPreferredSize(new Dimension(651, 434));
            this.jChkEnabled = new JCheckBox();
            this.jPnlMain.add(this.jChkEnabled);
            this.jChkEnabled.setText(SdistConst.MSG_JAVAPOSTRACINGENABLED);
            this.jChkEnabled.setBounds(20, 22, 371, 28);
            this.jSeparator1 = new JSeparator();
            this.jPnlMain.add(this.jSeparator1);
            this.jSeparator1.setBounds(14, 56, 574, 28);
            this.jLblLevel = new JLabel();
            this.jPnlMain.add(this.jLblLevel);
            this.jLblLevel.setText(SdistConst.MSG_LEVEL);
            this.jLblLevel.setBounds(30, 80, 189, 28);
            DefaultComboBoxModel<Object> jCmbLevelModel = new DefaultComboBoxModel<Object>(SdistAppModel.getInstance().getLevels());
            this.jCmbLevel = new JComboBox();
            this.jPnlMain.add(this.jCmbLevel);
            this.jCmbLevel.setModel(jCmbLevelModel);
            this.jCmbLevel.setBounds(203, 77, 385, 28);
            this.jLblOutput = new JLabel();
            this.jPnlMain.add(this.jLblOutput);
            this.jLblOutput.setText(SdistConst.MSG_OUTPUT);
            this.jLblOutput.setBounds(30, 114, 189, 28);
            this.jLblFilePath = new JLabel();
            this.jLblOutput.add(this.jLblFilePath);
            this.jLblFilePath.setText(SdistConst.MSG_FILEPATH);
            this.jLblFilePath.setBounds(0, 82, 189, 28);
            DefaultComboBoxModel<Object> jCmbOutputModel = new DefaultComboBoxModel<Object>(SdistAppModel.getInstance().getOutputs());
            this.jCmbOutput = new JComboBox();
            this.jPnlMain.add(this.jCmbOutput);
            this.jCmbOutput.setModel(jCmbOutputModel);
            this.jCmbOutput.setBounds(203, 112, 385, 28);
            this.jLabel9 = new JLabel();
            this.jPnlMain.add(this.jLabel9);
            this.jLabel9.setText(SdistConst.MSG_FILEPATH);
            this.jLabel9.setBounds(30, 149, 189, 28);
            this.jTxtFilePath = new JTextField();
            this.jPnlMain.add(this.jTxtFilePath);
            this.jTxtFilePath.setEditable(false);
            this.jTxtFilePath.setBounds(203, 147, 329, 28);
            this.jBtnExplore = new JButton();
            this.jPnlMain.add(this.jBtnExplore);
            this.jBtnExplore.setText(SdistConst.MSG_EXPLORE);
            this.jBtnExplore.setBounds(539, 147, 49, 28);
            this.jBtnExplore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(1);
                    int result = fc.showOpenDialog(null);
                    if (result == 0) {
                        String path = SdistAppModel.standarizePathToShow(fc.getSelectedFile().getAbsolutePath().trim());
                        SdistPnlJavaPOSTracing.this.jTxtFilePath.setText(path);
                        return;
                    }
                }
            });
            this.jLabel1 = new JLabel();
            this.jPnlMain.add(this.jLabel1);
            this.jLabel1.setText(SdistConst.MSG_FILENAME);
            this.jLabel1.setBounds(30, 186, 189, 28);
            this.jTxtFileName = new JTextField();
            this.jPnlMain.add(this.jTxtFileName);
            this.jTxtFileName.setText("");
            this.jTxtFileName.setBounds(203, 182, 224, 28);
            this.jLblThreshold = new JLabel();
            this.jPnlMain.add(this.jLblThreshold);
            this.jLblThreshold.setText(SdistConst.MSG_FILETHRESHOLD);
            this.jLblThreshold.setBounds(30, 222, 189, 28);
            this.jTxtThreshold = new JTextField();
            this.jPnlMain.add(this.jTxtThreshold);
            this.jTxtThreshold.setText("200");
            this.jTxtThreshold.setBounds(203, 219, 42, 28);
            this.jLblBytes = new JLabel();
            this.jPnlMain.add(this.jLblBytes);
            this.jLblBytes.setText("bytes");
            this.jLblBytes.setBounds(254, 217, 63, 28);
            this.jLblFlushFreq = new JLabel();
            this.jPnlMain.add(this.jLblFlushFreq);
            this.jLblFlushFreq.setText(SdistConst.MSG_FLUSHFREQUENCY);
            this.jLblFlushFreq.setBounds(30, 257, 189, 28);
            this.jTxtFlushFrequency = new JTextField();
            this.jPnlMain.add(this.jTxtFlushFrequency);
            this.jTxtFlushFrequency.setText("1000");
            this.jTxtFlushFrequency.setBounds(203, 255, 63, 28);
            this.jLblSeconds = new JLabel();
            this.jPnlMain.add(this.jLblSeconds);
            this.jLblSeconds.setText("milliseconds");
            this.jLblSeconds.setBounds(273, 253, 105, 28);
            this.jLblMaximumSize = new JLabel();
            this.jPnlMain.add(this.jLblMaximumSize);
            this.jLblMaximumSize.setText(SdistConst.MSG_MAXIMUMFILESIZE);
            this.jLblMaximumSize.setBounds(30, 293, 189, 28);
            this.jTxtMaxFileSize = new JTextField();
            this.jPnlMain.add(this.jTxtMaxFileSize);
            this.jTxtMaxFileSize.setText("1000000");
            this.jTxtMaxFileSize.setBounds(203, 291, 70, 28);
            this.jlblbytes2 = new JLabel();
            this.jPnlMain.add(this.jlblbytes2);
            this.jlblbytes2.setText("bytes");
            this.jlblbytes2.setBounds(277, 289, 63, 28);
            this.jLblMaxFiles = new JLabel();
            this.jPnlMain.add(this.jLblMaxFiles);
            this.jLblMaxFiles.setText(SdistConst.MSG_MAXIMUMNUMBEROFFILES);
            this.jLblMaxFiles.setBounds(30, 327, 189, 28);
            this.jTxtMaxFiles = new JTextField();
            this.jPnlMain.add(this.jTxtMaxFiles);
            this.jTxtMaxFiles.setText("10");
            this.jTxtMaxFiles.setBounds(203, 327, 63, 28);
            this.jlblFiles = new JLabel();
            this.jPnlMain.add(this.jlblFiles);
            this.jlblFiles.setText("files");
            this.jlblFiles.setBounds(272, 326, 63, 28);
            this.jBtnReset = new JButton();
            this.jPnlMain.add(this.jBtnReset);
            this.jBtnReset.setText(SdistConst.MSG_BTN_RESTOREDEFAULTS);
            this.jBtnReset.setBounds(434, 364, 154, 28);
            this.jBtnReset.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SdistPnlJavaPOSTracing.this.jBtnResetActionPerformed(evt);
                }
            });
            this.jLblTimeFormat = new JLabel();
            this.jPnlMain.add(this.jLblTimeFormat);
            this.jLblTimeFormat.setText(SdistConst.MSG_TIMESTAMPFORMAT);
            this.jLblTimeFormat.setBounds(28, 364, 196, 28);
            DefaultComboBoxModel<Object> jCmbTimeStampModel = new DefaultComboBoxModel<Object>(SdistAppModel.getInstance().getTimeStampFormats());
            this.jCmbTimeStampFormat = new JComboBox();
            this.jPnlMain.add(this.jCmbTimeStampFormat);
            this.jCmbTimeStampFormat.setModel(jCmbTimeStampModel);
            this.jCmbTimeStampFormat.setBounds(203, 364, 112, 28);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getNextPanelID() {
        return null;
    }

    public String getPrevPanelID() {
        return "PNLSUBSYSTEM";
    }

    public boolean beforeHidePanel() {
        Object[] options;
        HashMap dl = JavaPOSTracingModel.getInstance().getAllDefaultProps();
        if (this.jCmbLevel.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_SELECTVALIDLEVEL, SdistConst.MSG_ERROR, 0);
            return false;
        }
        if (this.jCmbOutput.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_SELECTVALIDOUTPUT, SdistConst.MSG_ERROR, 0);
            return false;
        }
        if (this.jCmbTimeStampFormat.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_SELECTVALIDFORMAT, SdistConst.MSG_ERROR, 0);
            return false;
        }
        if (this.jTxtFilePath.getText().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_INVALIDFILE, SdistConst.MSG_ERROR, 0);
            return false;
        }
        if (!SdistAppModel.validateFileWritable(this.jTxtFilePath.getText())) {
            JOptionPane.showMessageDialog(this, this.jTxtFilePath.getText() + " " + SdistConst.MSG_READONLYPATH, SdistConst.MSG_ERROR, 0);
            return false;
        }
        if (this.jTxtFileName.getText().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_SELECTVALIDFILENAME, SdistConst.MSG_ERROR, 0);
            return false;
        }
        if (!SdistAppModel.validateFile(this.jTxtFilePath.getText() + File.separator + this.jTxtFileName.getText())) {
            JOptionPane.showMessageDialog(this, this.jTxtFilePath.getText() + File.separator + this.jTxtFileName.getText() + " " + SdistConst.MSG_INVALIDFILE, SdistConst.MSG_ERROR, 0);
            return false;
        }
        if (!SdistAppModel.validateFileWritable(this.jTxtFilePath.getText() + File.separator + this.jTxtFileName.getText())) {
            JOptionPane.showMessageDialog(this, this.jTxtFilePath.getText() + File.separator + this.jTxtFileName.getText() + " " + SdistConst.MSG_ISREADONLY, SdistConst.MSG_ERROR, 0);
            return false;
        }
        boolean rst = false;
        try {
            rst = Integer.parseInt(this.jTxtThreshold.getText()) > 0;
        }
        catch (Exception e) {
            rst = false;
        }
        if (!rst) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_SELECTVALIDTHRESHOLD, SdistConst.MSG_ERROR, 0);
            return false;
        }
        try {
            rst = Integer.parseInt(this.jTxtFlushFrequency.getText()) > 0;
        }
        catch (Exception e) {
            rst = false;
        }
        if (!rst) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_SELECTVALIDFREQUENCY, SdistConst.MSG_ERROR, 0);
            return false;
        }
        try {
            rst = Integer.parseInt(this.jTxtMaxFileSize.getText()) > 0;
        }
        catch (Exception e) {
            rst = false;
        }
        if (!rst) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_SELECTVALIDSIZE, SdistConst.MSG_ERROR, 0);
            return false;
        }
        try {
            rst = Integer.parseInt(this.jTxtMaxFiles.getText()) > 0;
        }
        catch (Exception e) {
            rst = false;
        }
        if (!rst) {
            JOptionPane.showMessageDialog(this, SdistConst.MSG_SELECTVALIDNUMBER, SdistConst.MSG_ERROR, 0);
            return false;
        }
        if (this.jCmbLevel.getSelectedItem() != dl.get("com.ibm.jutil.tracing.TracerLevel") && JOptionPane.showOptionDialog(null, SdistConst.MSG_NONDEFAULTLEVELSELECTED, SdistConst.MSG_WARNING, -1, 2, null, options = new Object[]{SdistConst.MSG_BTN_CHANGE, SdistConst.MSG_BTN_KEEP}, options[0]) == 0) {
            return false;
        }
        HashMap mdl = SdistAppModel.getInstance().getJavaPOSTraceProps();
        mdl.put("com.ibm.jutil.tracing.TracerLevel", (String)this.jCmbLevel.getSelectedItem());
        mdl.put("com.ibm.jutil.tracing.TracerOutputTo", (String)this.jCmbOutput.getSelectedItem());
        mdl.put("com.ibm.jutil.tracing.TimeStampFormat", (String)this.jCmbTimeStampFormat.getSelectedItem());
        String val = this.jTxtFilePath.getText().trim();
        if (val.startsWith(System.getProperty("user.home"))) {
            val = "~" + val.substring(System.getProperty("user.home").length());
        }
        if (val.endsWith(File.separator) && val.length() > 1) {
            val = val.substring(0, val.length() - 1);
        }
        val = SdistAppModel.standarizePathToSave(val);
        mdl.put("com.ibm.jutil.tracing.TracerOutputFileLocation", val);
        mdl.put("com.ibm.jutil.tracing.TracerOutputFileName", this.jTxtFileName.getText().trim());
        mdl.put("com.ibm.jutil.tracing.TracerOutputFileThreshold", this.jTxtThreshold.getText());
        mdl.put("com.ibm.jutil.tracing.TracerOutputFileFlushFrequency", this.jTxtFlushFrequency.getText());
        mdl.put("com.ibm.jutil.tracing.TracerOutputFileMaxSize", this.jTxtMaxFileSize.getText());
        mdl.put("com.ibm.jutil.tracing.TracerOutputFileMaxFiles", this.jTxtMaxFiles.getText());
        mdl.put("com.ibm.jutil.tracing.TurnOnAllNamedTracers", this.jChkEnabled.isSelected() ? "ON" : "OFF");
        SdistAppModel.getInstance().setJavaPOSTraceProps();
        return true;
    }

    public boolean beforeShowPanel() {
        HashMap mdl = SdistAppModel.getInstance().getJavaPOSTraceProps();
        HashMap dl = JavaPOSTracingModel.getInstance().getAllDefaultProps();
        String parsing = null;
        while (true) {
            try {
                int i;
                parsing = "com.ibm.jutil.tracing.TurnOnAllNamedTracers";
                String value = (String)mdl.get("com.ibm.jutil.tracing.TurnOnAllNamedTracers");
                if (!value.equalsIgnoreCase("OFF") && !value.equalsIgnoreCase("ON")) {
                    throw new IllegalArgumentException(SdistConst.MSG_VALIDONOFF);
                }
                this.jChkEnabled.setSelected(true);
                parsing = "com.ibm.jutil.tracing.TracerLevel";
                value = (String)mdl.get("com.ibm.jutil.tracing.TracerLevel");
                if (value != null) {
                    for (i = 0; i < this.jCmbLevel.getItemCount(); ++i) {
                        if (value.compareToIgnoreCase((String)this.jCmbLevel.getItemAt(i)) != 0) continue;
                        this.jCmbLevel.setSelectedIndex(i);
                        break;
                    }
                    if (i == this.jCmbLevel.getItemCount()) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                parsing = "com.ibm.jutil.tracing.TracerOutputTo";
                value = (String)mdl.get("com.ibm.jutil.tracing.TracerOutputTo");
                if (value != null) {
                    for (i = 0; i < this.jCmbOutput.getItemCount(); ++i) {
                        if (value.compareToIgnoreCase((String)this.jCmbOutput.getItemAt(i)) != 0) continue;
                        this.jCmbOutput.setSelectedIndex(i);
                        break;
                    }
                    if (i == this.jCmbOutput.getItemCount()) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                parsing = "com.ibm.jutil.tracing.TimeStampFormat";
                value = (String)mdl.get("com.ibm.jutil.tracing.TimeStampFormat");
                this.jCmbTimeStampFormat.setSelectedIndex(0);
                if (value != null) {
                    for (i = 0; i < this.jCmbTimeStampFormat.getItemCount(); ++i) {
                        if (value.compareToIgnoreCase((String)this.jCmbTimeStampFormat.getItemAt(i)) != 0) continue;
                        this.jCmbTimeStampFormat.setSelectedIndex(i);
                        break;
                    }
                    if (i == this.jCmbTimeStampFormat.getItemCount()) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                parsing = "com.ibm.jutil.tracing.TracerOutputFileLocation";
                String val = (String)mdl.get("com.ibm.jutil.tracing.TracerOutputFileLocation");
                if (val.startsWith("~")) {
                    val = System.getProperty("user.home") + val.substring(1);
                }
                if (val.endsWith(File.separator) && val.length() > 1) {
                    val = val.substring(0, val.length() - 1);
                }
                if (!SdistAppModel.validateDirectory(val = SdistAppModel.standarizePathToShow(val))) {
                    throw new IllegalArgumentException(val + " " + SdistConst.MSG_INVALIDPATH);
                }
                this.jTxtFilePath.setText(val);
                parsing = "com.ibm.jutil.tracing.TracerOutputFileName";
                String fn = (String)mdl.get("com.ibm.jutil.tracing.TracerOutputFileName");
                if (fn.equals("") || !SdistAppModel.validateFile(val + File.separator + fn)) {
                    throw new IllegalArgumentException(val + File.separator + fn + " " + SdistConst.MSG_INVALIDFILE);
                }
                if (!SdistAppModel.validateFileWritable(val + File.separator + fn)) {
                    throw new IllegalArgumentException(val + File.separator + fn + " " + SdistConst.MSG_ISREADONLY);
                }
                this.jTxtFileName.setText(fn);
                parsing = "com.ibm.jutil.tracing.TracerOutputFileThreshold";
                String threshold = (String)mdl.get("com.ibm.jutil.tracing.TracerOutputFileThreshold");
                Integer checkInteger = new Integer(threshold.replace('-', 'A'));
                this.jTxtThreshold.setText(threshold);
                parsing = "com.ibm.jutil.tracing.TracerOutputFileFlushFrequency";
                String flushFreq = (String)mdl.get("com.ibm.jutil.tracing.TracerOutputFileFlushFrequency");
                checkInteger = new Integer(flushFreq.replace('-', 'A'));
                this.jTxtFlushFrequency.setText(flushFreq);
                parsing = "com.ibm.jutil.tracing.TracerOutputFileMaxSize";
                String maxfilesize = (String)mdl.get("com.ibm.jutil.tracing.TracerOutputFileMaxSize");
                checkInteger = new Integer(maxfilesize.replace('-', 'A'));
                this.jTxtMaxFileSize.setText(maxfilesize);
                parsing = "com.ibm.jutil.tracing.TracerOutputFileMaxFiles";
                String maxNumFiles = (String)mdl.get("com.ibm.jutil.tracing.TracerOutputFileMaxFiles");
                checkInteger = new Integer(maxNumFiles.replace('-', 'A'));
                this.jTxtMaxFiles.setText(maxNumFiles);
            }
            catch (RuntimeException e) {
                Object[] options = new Object[]{SdistConst.MSG_BTN_CONTINUE, SdistConst.MSG_BTN_EXIT};
                if (JOptionPane.showOptionDialog(this, SdistConst.MSG_EXCEPTION + " " + SdistConst.MSG_PARSING + " " + parsing + "\n" + SdistConst.MSG_CLICKCONTINUEOREXIT, SdistConst.MSG_WARNING, -1, 0, null, options, options[0]) != 0) {
                    System.exit(0);
                }
                mdl.put(parsing, dl.get(parsing));
                continue;
            }
            break;
        }
        return true;
    }

    public void afterShowPanel() {
    }

    public String getID() {
        return PANEL_ID;
    }

    private void jBtnResetActionPerformed(ActionEvent evt) {
        SdistAppModel.getInstance().initJavaPOSTraceProps();
        this.beforeShowPanel();
    }
}

