/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jpos.config.JposEntry;
import jpos.util.JposEntryUtility;

class InvalidEntryDialog
extends JDialog {
    private JposEntry invalidEntry = null;
    private JLabel missingEntryLabel = new JLabel("Required properties missing for entry: ");
    private JTextField logicalNameTextField = new JTextField(15);
    private JTextArea missingPropertiesTextArea = new JTextArea(5, 20);
    private JButton saveWithDefaultsButton = new JButton("Save Entry With Defaults");
    private JButton dontSaveButton = new JButton("Don't Save Entry");
    private boolean saveWithDefaultsButtonClicked = false;
    public static final String MISSING_PROPERTIES_TITLE_STRING = "Missing required properties";
    public static final String MISSING_ENTRY_LABEL_STRING = "Required properties missing for entry: ";
    public static final String INVALID_ENTRY_DIALOG_TITLE = "Invalid Entry";
    public static final String SAVE_WITH_DEFAULT_BUTTON_STRING = "Save Entry With Defaults";
    public static final String DONT_SAVE_BUTTON_STRING = "Don't Save Entry";
    public static final String INVALID_ENTRY_LOGICAL_NAME_TTTEXT_STRING = "Logical name of invalid entry";
    public static final String MISSING_PROPERTIES_TTTEXT_STRING = "Required properties missing from invalid properties";
    public static final String SAVE_WITH_DEFAULTS_TTTEXT_STRING = "Save invalid entry with default values for required properties";
    public static final String DONT_SAVE_TTTEXT_STRING = "Don't save invalid entry (entry is discarded)";

    public InvalidEntryDialog(JFrame jFrame) {
        super(jFrame);
        this.setTitle(INVALID_ENTRY_DIALOG_TITLE);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.missingEntryLabel);
        jPanel.add(this.logicalNameTextField);
        this.getContentPane().add((Component)jPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(22, 30);
        jScrollPane.setViewportView(this.missingPropertiesTextArea);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), MISSING_PROPERTIES_TITLE_STRING));
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.saveWithDefaultsButton);
        jPanel2.add(this.dontSaveButton);
        this.getContentPane().add((Component)jPanel2, "South");
        this.logicalNameTextField.setToolTipText(INVALID_ENTRY_LOGICAL_NAME_TTTEXT_STRING);
        this.missingPropertiesTextArea.setToolTipText(MISSING_PROPERTIES_TTTEXT_STRING);
        this.saveWithDefaultsButton.setToolTipText(SAVE_WITH_DEFAULTS_TTTEXT_STRING);
        this.dontSaveButton.setToolTipText(DONT_SAVE_TTTEXT_STRING);
        this.saveWithDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InvalidEntryDialog.this.saveWithDefaultsButtonClicked();
            }
        });
        this.dontSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InvalidEntryDialog.this.dontSaveButtonClicked();
            }
        });
        this.logicalNameTextField.setEditable(false);
        this.missingPropertiesTextArea.setEditable(false);
        this.pack();
        this.centerFrame();
    }

    private void centerFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
    }

    private void saveWithDefaultsButtonClicked() {
        this.saveWithDefaultsButtonClicked = true;
        this.setVisible(false);
    }

    private void dontSaveButtonClicked() {
        this.saveWithDefaultsButtonClicked = false;
        this.setVisible(false);
    }

    public void setInvalidEntry(JposEntry jposEntry) {
        this.invalidEntry = jposEntry;
        this.logicalNameTextField.setText(this.invalidEntry.getPropertyValue("logicalName").toString());
        Enumeration enumeration = JposEntryUtility.getMissingRequiredPropNames(this.invalidEntry);
        this.missingPropertiesTextArea.setText("");
        while (enumeration.hasMoreElements()) {
            this.missingPropertiesTextArea.setText(this.missingPropertiesTextArea.getText() + enumeration.nextElement() + "\n");
        }
        this.saveWithDefaultsButtonClicked = false;
    }

    public boolean isSaveWithDefaultsButtonSelected() {
        return this.saveWithDefaultsButtonClicked;
    }
}

