/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpos.config.JposEntry;
import jpos.config.simple.editor.BusPropsViewPanel;
import jpos.config.simple.editor.JposEntryEditorConfig;
import jpos.config.simple.editor.JposEntryViewPanel;
import jpos.config.simple.editor.MainFrame;
import jpos.config.simple.editor.PropsViewPanel;
import jpos.config.simple.editor.StandardPropsViewPanel;
import jpos.config.simple.editor.VendorPropsViewPanel;

class JposEntryPanel
extends JPanel {
    private JposEntry jposEntry = null;
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private JposEntryViewPanel jposEntryViewPanel = new JposEntryViewPanel();
    private PropsViewPanel currentPropsViewPanel = null;
    private EditOkCancelButtonPanel editOkCancelButtonPanel = new EditOkCancelButtonPanel();
    private JPanel buttonPanel = new JPanel();
    private JPanel customButtonPanel = new JPanel(new BorderLayout());
    private MainFrame mainFrame = null;
    private StandardPropsViewPanel standardPropsPanel = new StandardPropsViewPanel();
    private BusPropsViewPanel busPropsPanel = new BusPropsViewPanel();
    private VendorPropsViewPanel vendorPropsPanel = new VendorPropsViewPanel();
    public static final String JCL12_VIEW_TAB_NAME = "JCL 1.2 View";
    public static final String STANDARD_PROPS_TAB_STRING = "Standard Properties";
    public static final String BUS_PROPS_TAB_STRING = "Bus Properties";
    public static final String VENDOR_PROPS_TAB_STRING = "Vendor Properties";
    public static final String EDIT_BUTTON_STRING = "Edit";
    public static final String OK_BUTTON_STRING = "OK";
    public static final String CANCEL_BUTTON_STRING = "Cancel";

    public JposEntryPanel(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTabbedPane, "Center");
        JScrollPane jScrollPane = new JScrollPane(this.standardPropsPanel, 22, 30);
        this.jTabbedPane.addTab(STANDARD_PROPS_TAB_STRING, jScrollPane);
        this.jTabbedPane.addTab(BUS_PROPS_TAB_STRING, this.busPropsPanel);
        this.jTabbedPane.addTab(VENDOR_PROPS_TAB_STRING, this.vendorPropsPanel);
        this.buttonPanel.setLayout(new GridLayout(4, 1));
        this.buttonPanel.add(new JPanel());
        this.buttonPanel.add(new JPanel());
        this.buttonPanel.add(this.editOkCancelButtonPanel);
        this.buttonPanel.add(this.customButtonPanel);
        this.add((Component)this.buttonPanel, "East");
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JposEntryPanel.this.tabbedPaneStateChanged();
            }
        });
        this.currentPropsViewPanel = this.standardPropsPanel;
        this.initPropsViewPanel();
    }

    private void initPropsViewPanel() {
        String string = this.jTabbedPane.getTitleAt(this.jTabbedPane.getSelectedIndex());
        if (string.equals(JCL12_VIEW_TAB_NAME)) {
            this.editOkCancelButtonPanel.setButtonsVisible(false);
        } else {
            this.editOkCancelButtonPanel.setButtonsVisible(true);
            this.customButtonPanel.removeAll();
            if (string.equals(STANDARD_PROPS_TAB_STRING)) {
                this.customButtonPanel.add((Component)this.standardPropsPanel.getCustomButtonPanel(), "Center");
                this.editOkCancelButtonPanel.setPropsViewPanel(this.standardPropsPanel);
                this.currentPropsViewPanel = this.standardPropsPanel;
            } else if (string.equals(BUS_PROPS_TAB_STRING)) {
                this.customButtonPanel.add((Component)this.busPropsPanel.getCustomButtonPanel(), "Center");
                this.editOkCancelButtonPanel.setPropsViewPanel(this.busPropsPanel);
                this.currentPropsViewPanel = this.busPropsPanel;
            } else {
                this.customButtonPanel.add((Component)this.vendorPropsPanel.getCustomButtonPanel(), "Center");
                this.editOkCancelButtonPanel.setPropsViewPanel(this.vendorPropsPanel);
                this.currentPropsViewPanel = this.vendorPropsPanel;
            }
        }
        if (this.jposEntry != null) {
            this.editOkCancelButtonPanel.getEditButton().setEnabled(true);
        }
        PropsViewPanel.Listener listener = new PropsViewPanel.Listener(){

            public void jposEntryChanged(PropsViewPanel.Event event) {
                JposEntryPanel.this.mainFrame.setEntriesChanged(true);
            }
        };
        this.standardPropsPanel.addListener(listener);
        this.busPropsPanel.addListener(listener);
        this.vendorPropsPanel.addListener(listener);
        this.standardPropsPanel.setMainFrame(this.mainFrame);
        this.busPropsPanel.setMainFrame(this.mainFrame);
        this.vendorPropsPanel.setMainFrame(this.mainFrame);
    }

    public void tabbedPaneStateChanged() {
        if (this.currentPropsViewPanel != null) {
            this.currentPropsViewPanel.aboutToLooseFocus();
        }
        this.initPropsViewPanel();
    }

    public void initFromConfig() {
        if (JposEntryEditorConfig.getInstance().isShowJCL12PropView()) {
            this.jTabbedPane.addTab(JCL12_VIEW_TAB_NAME, this.jposEntryViewPanel);
        }
    }

    public JposEntryViewPanel getJposEntryView() {
        return this.jposEntryViewPanel;
    }

    public JposEntry getJposEntry() {
        return this.jposEntry;
    }

    public void setJposEntry(JposEntry jposEntry) {
        if (jposEntry != null) {
            this.jposEntry = jposEntry;
            this.jposEntryViewPanel.setJposEntry(this.jposEntry);
            this.standardPropsPanel.setJposEntry(this.jposEntry);
            this.busPropsPanel.setJposEntry(this.jposEntry);
            this.vendorPropsPanel.setJposEntry(this.jposEntry);
            this.editOkCancelButtonPanel.getEditButton().setEnabled(true);
        } else {
            this.clearAll();
        }
    }

    public void clearAll() {
        this.jposEntryViewPanel.clearAll();
        this.standardPropsPanel.clearAll();
        this.busPropsPanel.clearAll();
        this.vendorPropsPanel.clearAll();
        this.jposEntry = null;
    }

    public void setEnabledAll(boolean bl) {
        this.editOkCancelButtonPanel.setEnabledAll(false);
        this.jposEntryViewPanel.setEnabledAll(bl);
        this.standardPropsPanel.setEnabledAll(bl);
        this.busPropsPanel.setEnabledAll(bl);
        this.vendorPropsPanel.setEnabledAll(bl);
    }

    public void setShowJCL12PropView(boolean bl) {
        if (bl) {
            if (this.jTabbedPane.indexOfTab(JCL12_VIEW_TAB_NAME) == -1) {
                this.jTabbedPane.addTab(JCL12_VIEW_TAB_NAME, this.jposEntryViewPanel);
            }
        } else if (this.jTabbedPane.indexOfTab(JCL12_VIEW_TAB_NAME) != -1) {
            this.jTabbedPane.remove(this.jposEntryViewPanel);
        }
    }

    public void closingJposRegistryOrFile() {
        if (this.currentPropsViewPanel != null) {
            this.currentPropsViewPanel.aboutToLooseFocus();
        }
    }

    static /* synthetic */ JTabbedPane access$100(JposEntryPanel jposEntryPanel) {
        return jposEntryPanel.jTabbedPane;
    }

    class EditOkCancelButtonPanel
    extends JPanel {
        private JButton editButton = new JButton("Edit");
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");
        private PropsViewPanel currentPropsViewPanel = (PropsViewPanel)((Object)JposEntryPanel.access$100(JposEntryPanel.this).getSelectedComponent());

        EditOkCancelButtonPanel() {
            this.setLayout(new GridLayout(3, 1));
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.editButton);
            this.add(jPanel);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.okButton);
            this.add(jPanel);
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.cancelButton);
            this.add(jPanel);
            this.editButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ EditOkCancelButtonPanel this$1;
                {
                    this.this$1 = editOkCancelButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.editButtonClicked();
                }
            });
            this.okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ EditOkCancelButtonPanel this$1;
                {
                    this.this$1 = editOkCancelButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.okButtonClicked();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ EditOkCancelButtonPanel this$1;
                {
                    this.this$1 = editOkCancelButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cancelButtonClicked();
                }
            });
            this.init();
        }

        private void init() {
            this.setEnabledAll(false);
        }

        void setEnabledAll(boolean bl) {
            this.editButton.setEnabled(bl);
            this.okButton.setEnabled(bl);
            this.cancelButton.setEnabled(bl);
        }

        void setEditButtonEnabled(boolean bl) {
            this.editButton.setEnabled(bl);
        }

        void editButtonClicked() {
            this.editButton.setEnabled(false);
            this.okButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            this.currentPropsViewPanel.editButtonClicked();
        }

        void okButtonClicked() {
            this.editButton.setEnabled(true);
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.currentPropsViewPanel.okButtonClicked();
        }

        void cancelButtonClicked() {
            this.editButton.setEnabled(true);
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.currentPropsViewPanel.cancelButtonClicked();
        }

        void setButtonsVisible(boolean bl) {
            this.editButton.setVisible(bl);
            this.okButton.setVisible(bl);
            this.cancelButton.setVisible(bl);
        }

        void setPropsViewPanel(PropsViewPanel propsViewPanel) {
            this.editButton.setEnabled(false);
            this.okButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.currentPropsViewPanel = propsViewPanel;
        }

        JButton getEditButton() {
            return this.editButton;
        }
    }
}

