/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.ApitefJNA;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.annotation.FormatoBigDecimal;
import com.csi.ctfclient.apitef.annotation.FormatoData;
import com.csi.ctfclient.apitef.annotation.FormatoLista;
import com.csi.ctfclient.apitef.annotation.SubCampo;
import com.csi.ctfclient.apitef.annotation.SubCampos;
import com.csi.ctfclient.apitef.annotation.Tipo;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public abstract class ApitefDefault
extends Apitef {
    private static ILogger logger = CTFClientLogger.getLogger("com.csi.ctfclient.apitef");
    protected static int MAX_OUTPUT_BUFFER = 40000;
    protected byte[] oper8;
    protected byte[] subcampos;
    protected byte[] output;

    public ApitefDefault(String versoesCTFClient, int timeOutDefault, boolean habilitaLog, int diasLog, String path) {
        super(versoesCTFClient, timeOutDefault, habilitaLog, diasLog, path);
    }

    protected byte[] prepararOper8(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        StringBuilder strIdent = new StringBuilder();
        strIdent.append(entradaApiTefC.getOperacao());
        strIdent.append(identApiTefC.getNumeroEstabelecimento());
        strIdent.append(identApiTefC.getNumeroLoja());
        strIdent.append(identApiTefC.getNumeroPdv());
        strIdent.append(ApitefDefault.completaString(entradaApiTefC.getTimeout() + "", 4, '0', true));
        strIdent.append(ApitefDefault.completaString(entradaApiTefC.getNumeroTransacao() + "", 2, '0', true));
        strIdent.append(ApitefDefault.completaString(identApiTefC.getNumeroSites(), 2, '0', true));
        strIdent.append(ApitefDefault.completaString("", 42, ' ', true));
        strIdent.append(identApiTefC.getQuantidadeVias());
        strIdent.append("\u0000\u0000\u0000\u0000");
        strIdent.append("0");
        strIdent.append("\u0000");
        return strIdent.toString().getBytes();
    }

    protected String formataSubCampo(SubCampo subCampo, Field field, Object obj) throws IllegalAccessException {
        String strSucampo;
        block38: {
            strSucampo = null;
            Object valorObj = field.get(obj);
            if (subCampo.tipo() == Tipo.INTEIRO) {
                if (field.getType().equals(Integer.TYPE) || field.getType().equals(Long.TYPE)) {
                    try {
                        long valor = field.getLong(obj);
                        if (valor == -1L) break block38;
                        String tam = valor + "";
                        String strValor = ApitefDefault.completaString(valor + "", subCampo.tamanho(), '0', true);
                        tam = ApitefDefault.completaString(strValor.length() + "", 4, '0', true);
                        strSucampo = subCampo.codigo() + tam + strValor;
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
                        }
                        break block38;
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                        }
                        break block38;
                    }
                }
                if (field.getType().equals(Integer.class) || field.getType().equals(Long.class)) {
                    try {
                        Object valor = field.get(obj);
                        if (valor != null) {
                            String tam = valor + "";
                            String strValor = ApitefDefault.completaString(valor + "", subCampo.tamanho(), '0', true);
                            tam = ApitefDefault.completaString(strValor.length() + "", 4, '0', true);
                            strSucampo = subCampo.codigo() + tam + strValor;
                            if (logger.isDebugEnabled()) {
                                logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
                            }
                        }
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                        }
                    }
                }
            } else {
                if (subCampo.tipo() == Tipo.ALFANUMERICO) {
                    try {
                        String valor;
                        if (valorObj == null || (valor = (String)valorObj).trim().length() == 0 && !subCampo.permiteBranco()) break block38;
                        if (subCampo.completa()) {
                            valor = ApitefDefault.completaString(valor, subCampo.tamanho(), ' ', false);
                        }
                        String tam = ApitefDefault.completaString(valor.length() + "", 4, '0', true);
                        strSucampo = subCampo.codigo() + tam + valor;
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
                        }
                        break block38;
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                        }
                        break block38;
                    }
                }
                if (subCampo.tipo() == Tipo.DATA) {
                    try {
                        if (valorObj == null || !field.isAnnotationPresent(FormatoData.class)) break block38;
                        FormatoData formatoData = field.getAnnotation(FormatoData.class);
                        Date date = (Date)valorObj;
                        SimpleDateFormat dateFormat = new SimpleDateFormat(formatoData.valor());
                        String tam = ApitefDefault.completaString(formatoData.valor().length() + "", 4, '0', true);
                        strSucampo = subCampo.codigo() + tam + dateFormat.format(date);
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
                        }
                        break block38;
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                        }
                        break block38;
                    }
                }
                if (subCampo.tipo() == Tipo.MONETARIO) {
                    try {
                        if (valorObj == null) break block38;
                        int casasDecimais = 2;
                        if (field.isAnnotationPresent(FormatoBigDecimal.class)) {
                            FormatoBigDecimal formatoBigDecimal = field.getAnnotation(FormatoBigDecimal.class);
                            casasDecimais = formatoBigDecimal.casasDecimais();
                        }
                        BigDecimal valor = (BigDecimal)valorObj;
                        valor = valor.movePointRight(casasDecimais);
                        String strValor = valor.toString();
                        strValor = ApitefDefault.completaString(strValor, subCampo.tamanho(), '0', true);
                        String tam = ApitefDefault.completaString(strValor.length() + "", 4, '0', true);
                        strSucampo = subCampo.codigo() + tam + strValor;
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
                        }
                        break block38;
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                        }
                        break block38;
                    }
                }
                if (subCampo.tipo() == Tipo.BOOLEANO) {
                    try {
                        if (field.getType().equals(Boolean.TYPE)) {
                            boolean valor = field.getBoolean(obj);
                            strSucampo = subCampo.codigo() + "0001" + (valor ? "1" : "0");
                            if (logger.isDebugEnabled()) {
                                logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
                            }
                        } else if (field.getType().equals(Boolean.class) && valorObj != null) {
                            boolean valor = (Boolean)valorObj;
                            strSucampo = subCampo.codigo() + "0001" + (valor ? "1" : "0");
                            if (logger.isDebugEnabled()) {
                                logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block38;
                        logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                }
            }
        }
        return strSucampo;
    }

    protected byte[] prepararSubCampo(EntradaApiTefC entrada) {
        StringBuilder builder = new StringBuilder();
        if ("1F".equals(entrada.getOperacao()) || "1G".equals(entrada.getOperacao()) || "5N".equals(entrada.getOperacao())) {
            entrada.setAdicionais(entrada.getOperacaoConsultada());
        }
        if (entrada.getDadosCreditoDigital() != null) {
            entrada.setInfo(entrada.getDadosCreditoDigital());
        }
        try {
            Comparator<FieldObject> comparator = new Comparator<FieldObject>(){

                @Override
                public int compare(FieldObject fieldA, FieldObject fieldB) {
                    if (fieldA.field.isAnnotationPresent(SubCampo.class) && fieldB.field.isAnnotationPresent(SubCampo.class)) {
                        SubCampo subCampoA = fieldA.field.getAnnotation(SubCampo.class);
                        SubCampo subCampoB = fieldB.field.getAnnotation(SubCampo.class);
                        return subCampoA.codigo().compareTo(subCampoB.codigo());
                    }
                    return -1;
                }
            };
            Class<?> clazz = entrada.getClass();
            List<Field> fieldsList = Arrays.asList(clazz.getDeclaredFields());
            TreeSet<FieldObject> fields = new TreeSet<FieldObject>(comparator);
            for (Field field : fieldsList) {
                Field[] innerFields;
                if (field.isAnnotationPresent(SubCampo.class)) {
                    FieldObject fieldObject = new FieldObject();
                    fieldObject.field = field;
                    fieldObject.object = entrada;
                    fields.add(fieldObject);
                    continue;
                }
                if (!field.isAnnotationPresent(SubCampos.class)) continue;
                for (Field innerField : innerFields = field.getType().getDeclaredFields()) {
                    if (!innerField.isAnnotationPresent(SubCampo.class)) continue;
                    FieldObject fieldObject = new FieldObject();
                    fieldObject.field = innerField;
                    field.setAccessible(true);
                    fieldObject.object = field.get(entrada);
                    if (fieldObject.object == null) continue;
                    fields.add(fieldObject);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("prepararSubcampo ->");
            }
            for (FieldObject fieldObject : fields) {
                if (fieldObject.field.isAnnotationPresent(SubCampo.class)) {
                    this.recuperaField(builder, fieldObject);
                    continue;
                }
                if (!fieldObject.field.isAnnotationPresent(SubCampos.class)) continue;
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        builder.append("\u0000");
        byte[] array = new byte[builder.length() + 100];
        System.arraycopy(builder.toString().getBytes(), 0, array, 0, builder.length());
        return array;
    }

    private void recuperaField(StringBuilder builder, FieldObject field) throws Exception {
        SubCampo subCampo = field.field.getAnnotation(SubCampo.class);
        if (field.object == null) {
            return;
        }
        field.field.setAccessible(true);
        Object valorObj = field.field.get(field.object);
        if (subCampo.lista()) {
            if (valorObj == null) {
                return;
            }
            String codigoSubcampo = subCampo.codigo();
            boolean repeteSubcampo = true;
            if (field.field.isAnnotationPresent(FormatoLista.class)) {
                FormatoLista formatoLista = field.field.getAnnotation(FormatoLista.class);
                repeteSubcampo = formatoLista.repeteCodigoSubCampo();
            }
            boolean tipoLista = valorObj instanceof List;
            boolean tipoArray = valorObj.getClass().isArray();
            if (tipoLista || tipoArray) {
                List<String> lista = null;
                if (tipoArray && valorObj instanceof String[]) {
                    lista = Arrays.asList((String[])valorObj);
                }
                if (lista != null) {
                    for (String strValor : lista) {
                        strValor = ApitefDefault.completaString(strValor.length() + "", 4, '0', true) + strValor;
                        builder.append(codigoSubcampo + strValor);
                        if (repeteSubcampo) continue;
                        int codigo = Integer.parseInt(codigoSubcampo);
                        codigoSubcampo = ApitefDefault.completaString(codigo + 1 + "", 4, '0', true);
                    }
                }
            } else {
                String dados = (String)field.field.get(field.object);
                if (dados.length() < 4) {
                    return;
                }
                int offset = 0;
                do {
                    String strTam = dados.substring(offset, offset + 4);
                    int tam = Integer.parseInt(strTam);
                    String valor = dados.substring(offset, offset + (tam += 4));
                    offset += tam;
                    builder.append(codigoSubcampo + valor);
                    if (repeteSubcampo) continue;
                    int codigo = Integer.parseInt(codigoSubcampo);
                    codigoSubcampo = ApitefDefault.completaString(codigo + 1 + "", 4, '0', true);
                } while (offset + 4 <= dados.length());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
            }
        } else {
            String strSubcampo = this.formataSubCampo(subCampo, field.field, field.object);
            if (strSubcampo != null) {
                builder.append(strSubcampo);
            }
        }
    }

    protected SaidaApiTefC preparaSaidaApiteC(String operacao, byte[] retorno, byte[] erro, byte[] output) {
        SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
        try {
            Class<?> clazz = saidaApiTefC.getClass();
            Field[] fields = clazz.getDeclaredFields();
            HashMap<String, Field> maps = new HashMap<String, Field>();
            for (Field field : fields) {
                if (!field.isAnnotationPresent(SubCampo.class)) continue;
                SubCampo subCampo = field.getAnnotation(SubCampo.class);
                field.setAccessible(true);
                maps.put(subCampo.codigo(), field);
            }
            String strOutput = new String(output);
            int tamBuffer = strOutput.length();
            int pos = 0;
            byte[] sc80 = null;
            byte[] sc29 = null;
            if (logger.isDebugEnabled()) {
                logger.debug("preparaSaidaApiteC ->");
            }
            byte[] campoZerado = new byte[]{0, 0, 0, 0};
            String stringZerada = new String(campoZerado);
            while (pos < tamBuffer && !strOutput.substring(pos, pos + 4).equals(stringZerada)) {
                String codigo = strOutput.substring(pos, pos + 4);
                String tamStr = strOutput.substring(pos += 4, pos + 4);
                int tamInt = Integer.parseInt(tamStr);
                String valor = strOutput.substring(pos += 4, pos + tamInt);
                pos += tamInt;
                Field field = (Field)maps.get(codigo);
                if (field == null) continue;
                SubCampo subCampo = field.getAnnotation(SubCampo.class);
                if (logger.isDebugEnabled()) {
                    logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
                }
                if (codigo.equals("0029")) {
                    sc29 = new byte[pos - (pos - tamInt)];
                    System.arraycopy(output, pos - tamInt, sc29, 0, sc29.length);
                    continue;
                }
                if (codigo.equals("0080")) {
                    sc80 = new byte[pos - (pos - tamInt)];
                    System.arraycopy(output, pos - tamInt, sc80, 0, sc80.length);
                    continue;
                }
                if (subCampo.tipo() == Tipo.INTEIRO) {
                    try {
                        if (field.getType().equals(Integer.TYPE)) {
                            field.setInt(saidaApiTefC, Integer.parseInt(valor.trim()));
                            continue;
                        }
                        if (field.getType().equals(Long.TYPE)) {
                            field.setLong(saidaApiTefC, Long.parseLong(valor.trim()));
                            continue;
                        }
                        if (field.getType().equals(Integer.class)) {
                            field.set(saidaApiTefC, new Integer(valor.trim()));
                            continue;
                        }
                        if (!field.getType().equals(Long.class)) continue;
                        field.set(saidaApiTefC, new Long(valor.trim()));
                    }
                    catch (Exception e) {
                        logger.info("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() == Tipo.ALFANUMERICO) {
                    try {
                        if (subCampo.lista()) {
                            Object obj = field.get(saidaApiTefC);
                            if (obj != null) {
                                String strObj = (String)obj;
                                strObj = strObj + tamStr + valor;
                                field.set(saidaApiTefC, strObj);
                                continue;
                            }
                            field.set(saidaApiTefC, tamStr + valor);
                            continue;
                        }
                        field.set(saidaApiTefC, valor);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() == Tipo.DATA) {
                    try {
                        if (!field.isAnnotationPresent(FormatoData.class)) continue;
                        FormatoData formatoData = field.getAnnotation(FormatoData.class);
                        SimpleDateFormat dateFormat = new SimpleDateFormat(formatoData.valor());
                        Date data = dateFormat.parse(valor);
                        field.set(saidaApiTefC, data);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() == Tipo.MONETARIO) {
                    try {
                        int casasDecimais = 2;
                        if (field.isAnnotationPresent(FormatoBigDecimal.class)) {
                            FormatoBigDecimal formatoBigDecimal = field.getAnnotation(FormatoBigDecimal.class);
                            casasDecimais = formatoBigDecimal.casasDecimais();
                        }
                        BigDecimal bigValor = new BigDecimal(valor.trim());
                        bigValor = bigValor.movePointLeft(casasDecimais);
                        field.set(saidaApiTefC, bigValor);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() != Tipo.BOOLEANO) continue;
                try {
                    boolean retornoBoolean = !"0".equals(valor.trim());
                    field.set(saidaApiTefC, retornoBoolean);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                }
            }
            if (sc29 != null) {
                int pos29 = 0;
                String strSC29 = new String(sc29);
                if ("1F".equals(operacao) && strSC29.length() >= 17) {
                    saidaApiTefC.setDadosAdicionais(strSC29);
                    pos29 = 2;
                    String valor = "";
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdMinimaParcelaSemJuros(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdMaximaParcelaSemJuros(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdMinimoParcelaComJuros(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdMaximaParcelaComJuros(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "00";
                        }
                        saidaApiTefC.setTaxaServico(new BigDecimal(valor));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setCompraSaque(this.convertBoolean(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setMaximoMesesAgendamento(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "00";
                        }
                        saidaApiTefC.setTaxaEmbarque(new BigDecimal(valor));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else {
                    saidaApiTefC.setDadosAdicionais(strSC29);
                }
                if ("1F".equals(operacao) && strSC29.length() >= 21) {
                    String valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setConsultaFinanciamento(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "0";
                        }
                        saidaApiTefC.setCapturaCiclos(this.convertINT(valor));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "0";
                        }
                        saidaApiTefC.setFlagCodAutDig(valor);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "0";
                        }
                        saidaApiTefC.setFlagCodAutMag(valor);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
                if ("F4".equals(operacao) && strSC29.length() >= 224) {
                    pos29 = 0;
                    String valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValorMinimoCD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValorMaximoCD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdeValoresCD(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor1CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor2CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor3CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor4CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor5CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor6CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor7CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor8CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor9CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor10CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdeBonusCD(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus1CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus2CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus3CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus4CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus5CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus6CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus7CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus8CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus9CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus10CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            if (sc80 != null) {
                int pos80 = 0;
                String strSC80 = new String(sc80);
                String valor = "";
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 2);
                    pos80 += 2;
                    if ((saidaApiTefC.getCodigoAutorizadora() == null || "00".equals(saidaApiTefC.getCodigoAutorizadora())) && valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoAutorizadora(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 12);
                    pos80 += 12;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNomeAutorizadora(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 2);
                    pos80 += 2;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoVan(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 12);
                    pos80 += 12;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNomeVan(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 6);
                    pos80 += 6;
                    if (saidaApiTefC.getCodigoAprovacao() == null && valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoAprovacao(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 4);
                    pos80 += 4;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoInstituicaoFinanceira(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 12);
                    pos80 += 12;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNomeInstituicaoFinanceira(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 6);
                pos80 += 6;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNsuCTF(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 12);
                pos80 += 12;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setValorParcela(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 12);
                pos80 += 12;
                try {
                    if (saidaApiTefC.getValorTotal() == null && valor.trim().length() > 0) {
                        saidaApiTefC.setValorTotal(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 5);
                pos80 += 5;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setTaxaJuros(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setValidaCartao(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                byte sol_senha = sc80[pos80];
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setFlagTrataSenha((char)sol_senha);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 9);
                pos80 += 9;
                try {
                    if ((saidaApiTefC.getNsuAutorizacao() == null || "0".equals(saidaApiTefC.getNsuAutorizacao())) && valor.trim().length() > 0) {
                        saidaApiTefC.setNsuAutorizacao(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setHabilitaCDC_PRE(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 15);
                pos80 += 15;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoEstabelecimento(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 14);
                pos80 += 14;
                try {
                    if (valor.trim().length() > 0) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmmss");
                        saidaApiTefC.setDataAutorizadora(dateFormat.parse(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 12);
                pos80 += 12;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setValorTransacao_SC80(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNumeroViasCartao(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 50);
                pos80 += 50;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setLogomarca(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 12);
                pos80 += 12;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setSaldoCliente(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 4);
                pos80 += 4;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setVencimentoCartao(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setTipoAprovacao(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 6);
                pos80 += 6;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoProcesso(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 4);
                pos80 += 4;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setMac(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setTipoCartao(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 16);
                    pos80 += 16;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setWK80(valor);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            saidaApiTefC.setRetorno(Integer.parseInt(new String(retorno)));
            saidaApiTefC.setCodigoErro(Integer.parseInt(new String(erro)));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            saidaApiTefC.setRetorno(20);
            saidaApiTefC.setCodigoErro(5331);
            saidaApiTefC.setDisplayCTF("0015TENTE NOVAMENTE");
        }
        return saidaApiTefC;
    }

    private String recuperaBuffer(String buffer, int pos, int tam) {
        try {
            return buffer.substring(pos, pos + tam);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return "";
        }
    }

    private int convertINT(String valor) {
        if (valor == null || valor.trim().length() == 0) {
            return 0;
        }
        return Integer.parseInt(valor.trim());
    }

    private BigDecimal convertBigDecimal(String valor) {
        if (valor == null || valor.trim().length() == 0) {
            return null;
        }
        return new BigDecimal(valor.trim()).movePointLeft(2);
    }

    private boolean convertBoolean(String valor) {
        if (valor == null || valor.trim().length() == 0) {
            return false;
        }
        int b = Integer.parseInt(valor);
        return b == 1;
    }

    public static String completaString(String texto, int tamanho, char complemento, boolean esquerda) {
        while (texto.length() < tamanho) {
            if (esquerda) {
                texto = complemento + texto;
                continue;
            }
            texto = texto + complemento;
        }
        return texto;
    }

    public static void main(String[] args) {
        ApitefJNA apitef = new ApitefJNA("", 0, true, 0, "");
        String msg = "0004000800000000002900221200120012000  0000000001500020000110002SZ00780003028005700529F269F279F109F379F36959A9C9F025F2A829F1A9F039F339F340124000100125000100155000100126000100127000800000000012800040000012900080000000001300004000002080001100600001100870032EF9149787DE0A59B5754C2077CEB1CD8017600020200800233SZCREDITO ITAU00ITAUSX                CREDITO ITAU0000000000000000000000000000000000002         0               05092016165533000000000000 CREDITO ITAUSX                                                                123456789012345600310006";
        ((ApitefDefault)apitef).preparaSaidaApiteC("1F", "00".getBytes(), "0000".getBytes(), msg.getBytes());
    }

    static class FieldObject {
        public Field field;
        public Object object;

        FieldObject() {
        }
    }
}

