/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfCTFClientHandler;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class ControladorConfCTFClient {
    private static ILogger logger = CTFClientLogger.getConfigurator();
    public static final long TIME_OUT_DELAY = 1500L;
    public static final long TIME_OUT_DELAY_PLATAFORMA_PROMOCIONAL = 5000L;
    public static final String VERSAO_CIELO = "C0212";
    public static final String VERSAO_REDECARD = "C0138";
    public static final String VERSAO_ESPECIFICACAO_REDECARD = "L0602";
    public static final String VERSAO_CLIENT = "C030201";
    public static String VERSAO_CLIENT_DRAFT = "D22";
    public static final String DATA_VERSAO = "29/05/2019";
    public static final String FABRICANTE_TEF = "AUTTAR PROCESSAMENTO DE DADOS";
    public static final String CTFCLIENT_HOME = "CTFCLIENT_HOME";
    public static final String PIN_EMV = "16";
    public static final String PIN_PPVISA = "14";
    public static final String INTEGRACAO_STANDALONE = "standalone";
    public static final String INTEGRACAO_DLL = "dll";
    public static final String INTEGRACAO_TEF_DISC = "tef_disc";
    public static final String INTEGRACAO_TEF_IP = "tef_ip";
    public static final String INTEGRACAO_WEB = "web";
    public static final String INTEGRACAO_ANDROID = "android";
    public static final String INTEGRACAO_WEB_SOCKET = "websocket";
    private static final String DEFAULT_HANDLER = "com.csi.ctfclient.config.ConfCTFClientAutenticacaoHandler";
    private static String HANDLER = null;
    private static ControladorConfCTFClient readerConfClientCTF = null;
    private static ConfCTFClientHandler configCTFClintHandler = null;

    private ControladorConfCTFClient() {
    }

    public static synchronized ControladorConfCTFClient getInstance() throws ExcecaoApiAc {
        if (readerConfClientCTF == null) {
            logger.log("INFO", "Inicializando controlador de configuracoes...");
            if (HANDLER == null) {
                HANDLER = DEFAULT_HANDLER;
            }
            try {
                configCTFClintHandler = (ConfCTFClientHandler)Class.forName(HANDLER).newInstance();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                return null;
            }
            readerConfClientCTF = new ControladorConfCTFClient();
            readerConfClientCTF.reader();
        }
        return readerConfClientCTF;
    }

    public ConfCTFClient getConfig() {
        return configCTFClintHandler.getConfCTFClient();
    }

    public static void setHandler(String nome) {
        HANDLER = nome;
    }

    public ConfCTFClientHandler getHandler() {
        return configCTFClintHandler;
    }

    public static String getDiretorioTrabalho() {
        return configCTFClintHandler.getDiretorioTrabalho();
    }

    public void resetDadosAutenticacao() throws ExcecaoApiAc {
        configCTFClintHandler.resetDadosAutenticacao();
    }

    private ConfCTFClient reader() throws ExcecaoApiAc {
        logger.log("INFO", "inicializando carga dos parametros de configuracao...");
        try {
            logger.log("INFO", "inicializando leitura do arquivo de configuracoes");
            logger.log("INFO", "CTFCLIENT_HOME = " + ControladorConfCTFClient.getDiretorioTrabalho());
            logger.log("INFO", "SO = " + System.getProperty("os.name").toLowerCase());
            configCTFClintHandler.reader();
            logger.log("INFO", "Finalizando atualizacao do arquivo de configuracoes...");
        }
        catch (Exception e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        return configCTFClintHandler.getConfCTFClient();
    }

    public void save(ConfCTFClient confCTFClient) throws ExcecaoApiAc {
        this.save(confCTFClient, !this.getConfig().isSuporteHttps());
    }

    public void save(ConfCTFClient confCTFClient, boolean ignoreSuporteHttps) throws ExcecaoApiAc {
        logger.log("INFO", "Inicializando atualizacao do arquivo de configuracoes...");
        try {
            configCTFClintHandler.save(confCTFClient, ignoreSuporteHttps);
        }
        catch (Exception e) {
            logger.log("FATAL", e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
    }

    public boolean isEstabelecimentoValido() {
        return configCTFClintHandler.isEstabelecimentoValido();
    }

    public boolean isLojaValida() {
        return configCTFClintHandler.isLojaValida();
    }

    public boolean isTerminalValido() {
        return configCTFClintHandler.isTerminalValido();
    }

    public boolean isListaIPValida() {
        return configCTFClintHandler.isListaIPValida();
    }

    public void configuraPinpad(String portaPinpad) throws ExcecaoApiAc {
        ConfCTFClient confCTFClient = this.getConfig();
        ConfPeriferico confPeriferico = confCTFClient.getLeitorCartao();
        if (confPeriferico != null) {
            confPeriferico.getParametros()[0] = portaPinpad;
            if (confPeriferico.getParametros()[2].length() == 0) {
                confPeriferico.getParametros()[2] = "Auttar";
            }
        } else {
            ConfPeriferico leitorCartao = new ConfPeriferico("PARAMS_LEITOR_CARTAO");
            leitorCartao.setNomeClasse("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
            String[] parametrosLeitorCartao = new String[]{portaPinpad, "PASSE O CARTAO", "Auttar"};
            leitorCartao.setParametros(parametrosLeitorCartao);
            confCTFClient.setLeitorCartao(leitorCartao);
            ConfPeriferico leitorPinpad = new ConfPeriferico("PARAMS_PINPAD");
            leitorPinpad.setNomeClasse("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
            String[] parametrosPinpad = new String[]{portaPinpad, "Auttar", "DIGITE A SENHA", "PROCESSANDO..."};
            leitorPinpad.setParametros(parametrosPinpad);
            confCTFClient.setPin(leitorPinpad);
        }
        this.save(confCTFClient);
    }
}

