/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import com.csi.ctfclient.apitef.model.OperadoraTelefonia;
import com.csi.ctfclient.config.ConfCreditoDigital;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import com.csi.ctfclient.tools.util.xml.Config;
import com.csi.ctfclient.tools.util.xml.MultipleNamesFoundException;
import com.csi.ctfclient.tools.util.xml.NoSuchParameterException;
import com.csi.ctfclient.tools.util.xml.ParameterSet;
import com.csi.ctfclient.tools.util.xml.ParseConfigException;
import com.csi.ctfclient.tools.util.xml.StructureConfigException;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;

public class ControladorConfCreditoDigital {
    private static ILogger logger = CTFClientLogger.getLogger("ControladorConfCreditoDigital");
    private final String FILE_CONFIG = "configCreditoDigital.xml";
    private final String INVALID_PARAMETER = "valor de parametro invalido";
    private static ConfCreditoDigital confCreditoDigital;
    private static ControladorConfCreditoDigital readerConfCreditoDigital;

    private ControladorConfCreditoDigital() {
    }

    public static synchronized ControladorConfCreditoDigital getInstance() throws ExcecaoApiAc {
        if (readerConfCreditoDigital == null) {
            logger.info("Inicializando controlador de configura\u00e7\u00f5es de cr\u00e9dito digital...");
            readerConfCreditoDigital = new ControladorConfCreditoDigital();
            confCreditoDigital = readerConfCreditoDigital.read();
        }
        return readerConfCreditoDigital;
    }

    public ConfCreditoDigital getConfig() {
        return confCreditoDigital;
    }

    private ConfCreditoDigital read() throws ExcecaoApiAc {
        logger.info("Inicializando carga dos parametros de configura\u00e7\u00e3o...");
        ConfCreditoDigital confCreditoDigital = new ConfCreditoDigital();
        try {
            LinkedHashSet<OperadoraTelefonia> operadorasTelefonia;
            logger.info("Inicializando leitura do arquivo de configura\u00e7\u00f5es");
            Config config = ControladorConfCTFClient.getDiretorioTrabalho() != null ? Config.getConfig(ControladorConfCTFClient.getDiretorioTrabalho() + "configCreditoDigital.xml") : Config.getConfig("configCreditoDigital.xml");
            logger.info("Arquivo de configura\u00e7\u00e3o carregado...");
            ParameterSet root = config.getParameterSet("configCreditoDigital");
            ParameterSet ipsParameter = root.getParameterSet("operadoras");
            if (ipsParameter != null && ipsParameter.getParameterSets("operadora") != null && ipsParameter.getParameterSets("operadora").size() > 0) {
                operadorasTelefonia = new LinkedHashSet<OperadoraTelefonia>();
                List listaOperadora = ipsParameter.getParameterSets("operadora");
                for (ParameterSet paramOperadora : listaOperadora) {
                    int digitoInt;
                    String codigo = paramOperadora.getParameter("codigo").getContent();
                    if (codigo == null || codigo.equals("")) {
                        logger.info("valor de parametro invalido ==> operadora = codigo");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    String nome = paramOperadora.getParameter("nome").getContent();
                    if (nome == null || nome.equals("")) {
                        logger.info("valor de parametro invalido ==> operadora = nome");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    String digito = paramOperadora.getParameter("digito").getContent();
                    if (digito == null || digito.equals("")) {
                        logger.info("valor de parametro invalido ==> operadora = digito");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    try {
                        digitoInt = Integer.parseInt(digito);
                    }
                    catch (NumberFormatException e) {
                        logger.info("valor de parametro invalido ==> operadora = digito");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    OperadoraTelefonia operadora = new OperadoraTelefonia();
                    operadora.setAutorizadora(codigo);
                    operadora.setNome(nome);
                    operadora.setDigito(digitoInt == 1);
                    operadorasTelefonia.add(operadora);
                }
            } else {
                logger.info("lista de operadoras n\u00e3o configurada ==> operadoras");
                throw new ExcecaoApiAc("valor de parametro invalido");
            }
            confCreditoDigital.setOperadorasTelefonia(operadorasTelefonia);
        }
        catch (SecurityException e) {
            logger.error(e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (ParseConfigException e) {
            logger.error(e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (StructureConfigException e) {
            logger.error(e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (MultipleNamesFoundException e) {
            logger.error(e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (NoSuchParameterException e) {
            logger.error(e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new ExcecaoApiAc("Erro ao ler o arquivo configCreditoDigital.xml");
        }
        return confCreditoDigital;
    }

    public void save(ConfCreditoDigital confCreditoDigital) throws ExcecaoApiAc {
        logger.info("Inicializando leitura do arquivo de configura\u00e7\u00f5es de cr\u00e9dito digital");
        try {
            logger.info("Arquivo de configura\u00e7\u00e3o carregado...");
            logger.info("Inicializando atualiza\u00e7\u00e3o do arquivo de configura\u00e7\u00f5es...");
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            ControladorConfCreditoDigital controlador = ControladorConfCreditoDigital.getInstance();
            ConfCreditoDigital conf = controlador.getConfig();
            conf.getOperadorasTelefonia();
        }
        catch (ExcecaoApiAc e) {
            e.printStackTrace();
        }
    }
}

