/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.gui;

import com.csi.ctfclient.gui.EventSplash;
import com.csi.ctfclient.gui.SplashListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.event.EventListenerList;

public class SplashScreen
extends JWindow {
    private static final long serialVersionUID = 1L;
    private static final String PATH_IMAGEN = "/imagens/splash.png";
    private JLabel labelImage;
    private JTextArea textArea;
    private JButton button;
    protected EventListenerList listenerList = new EventListenerList();

    public SplashScreen() {
        this.buildLayout();
        this.pack();
        this.centralize();
    }

    public synchronized boolean fireSplash() {
        Object[] listListener = this.listenerList.getListenerList();
        EventSplash eventSplash = new EventSplash(this, true, this.getTextArea());
        for (int i = 0; i < listListener.length; i += 2) {
            if (!SplashListener.class.equals(listListener[i])) continue;
            try {
                ((SplashListener)listListener[i + 1]).processar(eventSplash);
                continue;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Erro", 0);
            }
        }
        this.getButton().setEnabled(!eventSplash.isProcessSucess());
        while (this.getButton().isEnabled() && this.isVisible()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return eventSplash.isProcessSucess();
    }

    public void addSplashScreen(SplashListener listener) {
        this.listenerList.add(SplashListener.class, listener);
    }

    public void removeSplashScreen(SplashListener listener) {
        this.listenerList.remove(SplashListener.class, listener);
    }

    public void centralize() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = dim.width / 2 - this.getWidth() / 2;
        int y = dim.height / 2 - this.getHeight() / 2;
        this.setLocation(x, y);
    }

    public void buildLayout() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getLabelImage(), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.getTextArea());
        scrollPane.setOpaque(false);
        panel.add(scrollPane);
        panel.add((Component)this.getButton(), "East");
        panel.setOpaque(false);
        container.add((Component)panel, "South");
        container.setBackground(Color.WHITE);
    }

    private JButton getButton() {
        if (this.button == null) {
            this.button = new JButton("OK");
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SplashScreen.this.dispose();
                }
            });
        }
        return this.button;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 2, 5));
            this.textArea.setOpaque(false);
            this.textArea.setRows(2);
        }
        return this.textArea;
    }

    private JLabel getLabelImage() {
        if (this.labelImage == null) {
            ImageIcon icon = new ImageIcon(SplashScreen.class.getResource(PATH_IMAGEN));
            this.labelImage = new JLabel(icon);
            this.labelImage.setBorder(BorderFactory.createEtchedBorder());
            this.labelImage.setOpaque(false);
        }
        return this.labelImage;
    }

    public static void main(String[] args) {
        SplashScreen splashScreen = new SplashScreen();
        splashScreen.centralize();
        splashScreen.setVisible(true);
    }
}

