/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.info.tiposgerais;

import com.csi.ctfclient.info.tiposgerais.CSIHashEntry;
import com.csi.ctfclient.info.tiposgerais.CSIHashIterator;
import com.csi.ctfclient.info.tiposgerais.CSIIteratorVazio;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CSIHashMap
implements Map,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int KEYS = 0;
    protected static final int VALUES = 1;
    private CSIHashEntry[] tabelaEntradas;
    private int numeroEntradasTabela;
    private int reorgThreshold;
    private static boolean lazyAllocationDefault = false;
    static CSIIteratorVazio ITERATOR_VAZIO = new CSIIteratorVazio();
    private static int[] hashPrimos = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 37, 41, 47, 53, 59, 67, 79, 89, 101, 113, 127, 149, 167, 191, 211, 233, 257, 283, 313, 347, 383, 431, 479, 541, 599, 659, 727, 809, 907, 1009, 1117, 1231, 1361, 1499, 1657, 1823, 2017, 2221, 2447, 2707, 2999, 3301, 3659, 4027, 4451, 4919, 5431, 6011, 6673, 7369, 8167, 9029, 10009, 11093, 12281, 13513, 14983, 16493, 18313, 20147, 22193, 24631, 27127, 29881, 32971, 36319, 40013, 44101, 48623, 53629, 59149, 65269, 72043, 79493, 87721, 96769, 106823, 117911, 130147, 143719, 158581, 175081, 193327, 213461, 235699, 260231, 287333, 317269, 350293, 386809, 427181, 471769, 521023, 575441, 635567, 701969, 775309, 856249, 945701, 1044529, 1153687, 1274249, 1407397, 1554529, 1717099, 1896647, 2095021, 2314097, 2556041, 2823389, 3118673, 3444851, 3805057, 4203019, 4642549, 5128037, 5664401, 6256951, 6911447, 7634387, 8432923, 9315109};

    public CSIHashMap() {
        this(50, lazyAllocationDefault, 10.0f);
    }

    public CSIHashMap(int capacidadeInicial, boolean flag, float fator) {
        if (capacidadeInicial <= 0) {
            throw new IllegalArgumentException("CSIHashMap initialCapacity");
        }
        if ((double)fator <= 0.0) {
            throw new IllegalArgumentException("CSIHashMap loadFactor");
        }
        int j = CSIHashMap.recommendedSlots(capacidadeInicial, fator);
        if (flag) {
            this.numeroEntradasTabela = -j;
            this.reorgThreshold = (int)((float)j * fator);
            return;
        }
        this.reorg(j, false, fator);
    }

    private void allocateLazyTable() {
        this.reorg(-this.numeroEntradasTabela, false, this.loadFactor());
        this.numeroEntradasTabela = 0;
    }

    @Override
    public void clear() {
        if (this.tabelaEntradas != null) {
            for (int i = 0; i < this.tabelaEntradas.length; ++i) {
                if (this.tabelaEntradas[i] == null) continue;
                this.tabelaEntradas[i] = null;
            }
            this.numeroEntradasTabela = 0;
        }
    }

    public boolean contains(Object elemento) {
        if (this.tabelaEntradas == null) {
            return false;
        }
        for (int i = 0; i < this.tabelaEntradas.length; ++i) {
            for (CSIHashEntry entry = this.tabelaEntradas[i]; entry != null; entry = entry.getNext()) {
                if (!entry.getElement().equals(elemento)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object chave) {
        if (this.tabelaEntradas == null) {
            return false;
        }
        return this.get(chave) != null;
    }

    @Override
    public boolean containsValue(Object obj) {
        return this.contains(obj);
    }

    public Enumeration elements() {
        if (this.tabelaEntradas == null) {
            return ITERATOR_VAZIO;
        }
        return new CSIHashIterator(1, this);
    }

    public Set entrySet() {
        throw new IllegalAccessError("CSIHashMap - entrySet");
    }

    public Object get(Object chave) {
        CSIHashEntry retorno = this.getEntry(chave);
        if (retorno == null) {
            return null;
        }
        return retorno.getElement();
    }

    protected int getTableSize() {
        return this.tabelaEntradas.length;
    }

    private void grow() {
        float f = this.loadFactor();
        int i = CSIHashMap.recommendedSlots(this.numeroEntradasTabela * 3 / 2, f);
        this.reorg(i, false, f);
    }

    @Override
    public boolean isEmpty() {
        if (this.tabelaEntradas == null) {
            return true;
        }
        return this.numeroEntradasTabela == 0;
    }

    public Enumeration keys() {
        if (this.tabelaEntradas == null) {
            return ITERATOR_VAZIO;
        }
        return new CSIHashIterator(0, this);
    }

    public Set keySet() {
        final CSIHashMap aux = this;
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new CSIHashIterator(0, aux);
            }

            @Override
            public int size() {
                return CSIHashMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return CSIHashMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                return CSIHashMap.this.remove(o) != null;
            }

            @Override
            public void clear() {
                CSIHashMap.this.clear();
            }
        };
    }

    private float loadFactor() {
        int i = this.tabelaEntradas != null ? this.tabelaEntradas.length : -this.numeroEntradasTabela;
        return (float)this.reorgThreshold / (float)i;
    }

    private static int nextPrime(int i) {
        int j = 0;
        int k = hashPrimos.length - 1;
        while (j < k) {
            int l = j + k >> 1;
            int i1 = hashPrimos[l];
            if (i1 < i) {
                j = l + 1;
                continue;
            }
            if (i1 > i) {
                k = l - 1;
                continue;
            }
            return i1;
        }
        if (hashPrimos[j] < i) {
            ++j;
        }
        if (j >= hashPrimos.length) {
            return i;
        }
        return hashPrimos[j];
    }

    public Object put(Object chave, Object elemento) {
        if (this.tabelaEntradas == null) {
            this.allocateLazyTable();
        }
        int i = chave.hashCode();
        int j = (i & Integer.MAX_VALUE) % this.tabelaEntradas.length;
        CSIHashEntry entry = null;
        for (entry = this.tabelaEntradas[j]; entry != null; entry = entry.getNext()) {
            boolean flag = false;
            flag = this.matchEntry(entry, chave, i);
            if (!flag) continue;
            Object obj2 = entry.getElement();
            entry.setElement(elemento);
            return obj2;
        }
        if (this.numeroEntradasTabela >= this.reorgThreshold) {
            this.grow();
            j = (i & Integer.MAX_VALUE) % this.tabelaEntradas.length;
        }
        ++this.numeroEntradasTabela;
        entry = new CSIHashEntry(chave, elemento, i);
        CSIHashEntry entry1 = this.tabelaEntradas[j];
        if (entry1 != null) {
            entry.setNext(entry1.getNext());
            entry1.setNext(entry);
        } else {
            entry.setNext(null);
            this.tabelaEntradas[j] = entry;
        }
        return null;
    }

    public void putAll(Map map) {
    }

    private static int recommendedSlots(int capacidadeInicial, float fator) {
        int byte0 = (double)fator >= 1.0 ? 5 : 11;
        return Math.max(byte0, CSIHashMap.nextPrime((int)((float)capacidadeInicial / fator)));
    }

    public Object remove(Object chave) {
        if (this.tabelaEntradas == null) {
            return null;
        }
        int i = chave.hashCode();
        int j = (i & Integer.MAX_VALUE) % this.tabelaEntradas.length;
        CSIHashEntry obj1 = null;
        for (CSIHashEntry entry = this.tabelaEntradas[j]; entry != null; entry = entry.getNext()) {
            boolean flag = false;
            flag = this.matchEntry(entry, chave, i);
            if (flag) {
                Object obj2 = entry.getElement();
                if (obj1 == null) {
                    this.tabelaEntradas[j] = entry.getNext();
                } else {
                    obj1.setNext(entry.getNext());
                }
                --this.numeroEntradasTabela;
                return obj2;
            }
            obj1 = entry;
        }
        return null;
    }

    private void reorg(int i, boolean flag, float fator) {
        this.reorgThreshold = (int)((float)i * fator);
        CSIHashEntry[] aentry = new CSIHashEntry[i];
        if (this.tabelaEntradas != null) {
            for (int j = 0; j < this.tabelaEntradas.length; ++j) {
                CSIHashEntry entry = this.tabelaEntradas[j];
                while (entry != null) {
                    CSIHashEntry entry1 = entry.getNext();
                    if (flag) {
                        entry.rehash();
                    }
                    int k = (entry.getHash() & Integer.MAX_VALUE) % aentry.length;
                    entry.setNext(aentry[k]);
                    aentry[k] = entry;
                    entry = entry1;
                }
            }
        }
        this.tabelaEntradas = aentry;
    }

    @Override
    public int size() {
        if (this.numeroEntradasTabela < 0) {
            return 0;
        }
        return this.numeroEntradasTabela;
    }

    public Collection values() {
        final CSIHashMap aux = this;
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                return new CSIHashIterator(1, aux);
            }

            @Override
            public int size() {
                return CSIHashMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return CSIHashMap.this.containsValue(o);
            }

            @Override
            public void clear() {
                CSIHashMap.this.clear();
            }
        };
    }

    protected CSIHashEntry getEntrada(int pos) {
        return this.tabelaEntradas[pos];
    }

    private CSIHashEntry getEntry(Object obj) {
        int i = obj.hashCode();
        int j = (i & Integer.MAX_VALUE) % this.tabelaEntradas.length;
        for (CSIHashEntry entry = this.tabelaEntradas[j]; entry != null; entry = entry.getNext()) {
            if (!this.matchEntry(entry, obj, i)) continue;
            return entry;
        }
        return null;
    }

    private boolean matchEntry(CSIHashEntry entry, Object chave, int hash) {
        return entry.getHash() == hash && chave.equals(entry.getKey());
    }
}

