/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.event.HandlerEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;

public class FileHandler
extends Handler {
    private Logger logger = Logger.getLogger("com.csi.apitef.integracao.FileHandler");
    private String path;
    private int timeCheck;
    private long lastModified = -1L;
    private boolean enable;
    private Thread thread;

    public FileHandler(Map map) {
        this((String)map.get("path"), Integer.parseInt((String)map.get("timecheck")));
    }

    public FileHandler(String path, int timeCheck) {
        this.path = path;
        this.timeCheck = timeCheck;
        this.thread = new Thread(new FileThreadHandler());
        this.thread.setName("File Handler");
    }

    private InputStream readFile() throws FileNotFoundException {
        File file = new File(this.path);
        FileInputStream stream = new FileInputStream(file);
        if (file.lastModified() == this.lastModified) {
            throw new FileNotFoundException();
        }
        this.lastModified = file.lastModified();
        return stream;
    }

    @Override
    public void start() {
        if (this.enable) {
            return;
        }
        this.enable = true;
        this.thread.start();
        this.logger.info("FileHandler Active Thread name = " + this.thread.getName() + " priority = " + this.thread.getPriority());
    }

    @Override
    public void stop() {
        this.enable = false;
        this.logger.info("FileHandler desactive");
    }

    class FileThreadHandler
    implements Runnable {
        FileThreadHandler() {
        }

        @Override
        public void run() {
            while (FileHandler.this.enable) {
                try {
                    InputStream stream = FileHandler.this.readFile();
                    HandlerEvent handlerEvent = new HandlerEvent(FileHandler.this, stream, null);
                    FileHandler.this.fireReadStream(handlerEvent);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(FileHandler.this.timeCheck);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

