/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.integracao.ConfiguracaoIntegrador;
import com.csi.ctfclient.integracao.ParserInput;
import com.csi.ctfclient.integracao.ParserOutput;
import com.csi.ctfclient.integracao.SocketHandler;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.integracao.TrataErroIntegracao;
import com.csi.ctfclient.integracao.event.HandlerEvent;
import com.csi.ctfclient.integracao.event.HandlerListener;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.RespostaConsultaConfiguracao;
import com.csi.ctfclient.servicos.SaidaCTFClient;
import com.csi.ctfclient.tools.devices.ControladorTranslator;
import com.csi.ctfclient.tools.util.CSISecurity;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;

public class HandlerManager
implements HandlerListener {
    private ConfiguracaoIntegrador integrador;
    private ILogger logger = CTFClientLogger.getIntegrador();

    public HandlerManager(ConfiguracaoIntegrador integrador) {
        this.integrador = integrador;
    }

    @Override
    public void readStream(HandlerEvent event) {
        ParserInput parserInput = this.integrador.createParserInput();
        InputStream inputStream = event.getInputStream();
        OutputStream outputStream = event.getOutputStream();
        EntradaCTFClient entrada = null;
        SaidaCTFClient saida = null;
        IdentTerminal identTerminal = null;
        CTFClient ctfClient = null;
        try {
            ctfClient = CTFClient.getInstancia();
            if (ctfClient.getConfig().isIntegracaoCriptografada()) {
                this.logger.log("DEBUG", "Descriptografando buffer de entrada...");
                CSISecurity security = new CSISecurity();
                InputStreamReader isr = new InputStreamReader(inputStream);
                LineNumberReader reader = new LineNumberReader(isr);
                byte[] buffer = null;
                String bufferCripto = reader.readLine();
                if (!ctfClient.getConfig().isIntegracaoWeb() && ctfClient.getConfig().isIntegracaoDll()) {
                    buffer = security.getOriginalArrayMsg(bufferCripto);
                } else {
                    String msg = security.getOriginalMsg(bufferCripto);
                    if (msg != null) {
                        buffer = msg.getBytes();
                    }
                }
                if (buffer == null) {
                    this.logger.log("ERROR", "A mensagem n\u00e3o p\u00f4de ser descriptografada, mensagem com problemas");
                    throw new IllegalArgumentException("A mensagem n\u00e3o p\u00f4de ser descriptografada, mensagem com problemas");
                }
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(buffer);
                inputStream = byteInputStream;
            } else {
                this.logger.log("DEBUG", "CTFClient n\u00e3o configurado para se integrar com automa\u00e7\u00f5es de forma criptografada");
            }
            if (ctfClient.getConfig().isIntegracaoDll() && event.getSource() instanceof SocketHandler) {
                ControladorTranslator.getInstancia().bindSocketTranslator(inputStream, outputStream);
            }
            parserInput.parseStream(inputStream, ctfClient.getConfig().isIntegracaoCriptografada());
            entrada = parserInput.getEntrada();
            identTerminal = parserInput.getIdentTerminal();
            if (entrada.getOperacao() == 5) {
                this.logger.log("INFO", "Opera\u00e7\u00e3o de configura\u00e7\u00e3o do Client solicitada");
                ConfCTFClient config = parserInput.getConfig();
                ctfClient.config(config);
                saida = new SaidaCTFClient();
                saida.setOperacao(entrada.getOperacao());
                saida.setEstabelecimento(identTerminal.getEstabelecimento());
                saida.setLoja(identTerminal.getLoja());
                saida.setTerminal(identTerminal.getTerminal());
                saida.setDocumento(saida.getDocumento());
                saida.setCodigoRetorno(0);
                String[] mensagens = new String[]{"CONFIGURACAO BEM SUCEDIDA"};
                saida.setMensagemCTF(mensagens);
            } else if (entrada.getOperacao() == 228) {
                this.logger.log("INFO", "Opera\u00e7\u00e3o de consulta de configura\u00e7\u00e3o solicitada");
                saida = new SaidaCTFClient();
                saida.setOperacao(entrada.getOperacao());
                saida.setEstabelecimento(ctfClient.getConfig().getEstabelecimento());
                saida.setLoja(ctfClient.getConfig().getLoja());
                saida.setTerminal(ctfClient.getConfig().getTerminal());
                RespostaConsultaConfiguracao consConfig = this.copyDataRespostaConsultaConfiguracao(ctfClient.getConfig());
                saida.setRespostaConsultaConfiguracao(consConfig);
                saida.setCodigoRetorno(0);
            } else if (entrada.getOperacao() == 226) {
                this.logger.log("INFO", "Opera\u00e7\u00e3o de consulta cart\u00e3o solicitada");
                saida = ctfClient.efetuarConsulta(identTerminal, entrada);
            } else if (entrada.isConsulta()) {
                this.logger.log("INFO", "Transa\u00e7\u00e3o de consulta solicitada");
                saida = ctfClient.efetuarConsulta(identTerminal, entrada);
            } else if (entrada.getOperacao() == 227 || entrada.getOperacao() == 303 || entrada.getOperacao() == 304 || entrada.getOperacao() == 305) {
                this.logger.log("INFO", "Opera\u00e7\u00e3o de Bypass por dentro do Client solicitada");
                saida = ctfClient.efetuarTransacao(identTerminal, entrada, entrada.getTimestamp());
            } else if (entrada.getIdentConsulta() > 0L) {
                this.logger.log("INFO", "Ident da consulta informado");
                saida = ctfClient.efetuarTransacao(identTerminal, entrada, entrada.getIdentConsulta());
            } else {
                saida = ctfClient.efetuarTransacao(identTerminal, entrada);
            }
        }
        catch (Exception e) {
            this.logger.error("Tratando erro no processamento");
            if (saida == null) {
                saida = new SaidaCTFClient();
                if (entrada == null) {
                    entrada = parserInput.getEntrada();
                }
                if (identTerminal == null) {
                    identTerminal = parserInput.getIdentTerminal();
                }
                if (entrada != null && identTerminal != null) {
                    saida.setOperacao(entrada.getOperacao());
                    saida.setEstabelecimento(identTerminal.getEstabelecimento());
                    saida.setLoja(identTerminal.getLoja());
                    saida.setTerminal(identTerminal.getTerminal());
                    saida.setDocumento(saida.getDocumento());
                }
                TrataErroIntegracao trataErroIntegracao = new TrataErroIntegracao(e);
                String codigoErro = trataErroIntegracao.getCodigoErro();
                saida.setMensagemCTF(trataErroIntegracao.getMensagens());
                saida.setCodigoRetorno(20);
                saida.setCodigoErro(codigoErro);
            }
            this.logger.error("Erro na entrada/execu\u00e7\u00e3o da opera\u00e7\u00e3o, retorno: " + saida.getCodigoErro());
            e.printStackTrace();
        }
        ParserOutput parserOutput = this.integrador.createParserOut();
        try {
            parserOutput.parse(saida, outputStream);
            if (ctfClient.getConfig() != null && ctfClient.getConfig().isIntegracaoDll() && event.getSource() instanceof SocketHandler) {
                ControladorTranslator.getInstancia().clearSocketTranslator();
            }
        }
        catch (SyntaxError e) {
            this.logger.error("Erro de sintaxe ao gerar o stream de sa\u00edda");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error("Erro gen\u00e9rico ao gerar o stream de sa\u00edda");
            e.printStackTrace();
        }
    }

    private RespostaConsultaConfiguracao copyDataRespostaConsultaConfiguracao(ConfCTFClient confCTFClient) {
        RespostaConsultaConfiguracao consConf = new RespostaConsultaConfiguracao();
        consConf.setVersaoAc(confCTFClient.getVersaoAC());
        consConf.setHostClient(confCTFClient.getHostClient());
        consConf.setPortClient(confCTFClient.getPortClient());
        consConf.setIpsCTF(confCTFClient.getIps());
        consConf.setTeclado(confCTFClient.getTeclado());
        consConf.setDisplayOperador(confCTFClient.getDisplayOperador());
        consConf.setDisplayCliente(confCTFClient.getDisplayCliente());
        consConf.setLeitorCartao(confCTFClient.getLeitorCartao());
        consConf.setPin(confCTFClient.getPin());
        consConf.setLeitorDocumento(confCTFClient.getLeitorDocumento());
        consConf.setScanner(confCTFClient.getScanner());
        consConf.setIntegracaoCriptografada(confCTFClient.isIntegracaoCriptografada());
        consConf.setCapturaCmc7(confCTFClient.isCapturaCmc7());
        consConf.setCreditoCelularHabilitado(confCTFClient.isCreditoCelularHabilitado());
        return consConf;
    }
}

